/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.download;

import com.esotericsoftware.minlog.Log;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.UiCommand;
import forge.gui.error.BugReporter;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IProgressBar;
import forge.gui.interfaces.ITextField;
import forge.util.FileUtil;
import forge.util.HttpUtil;
import forge.util.TextUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GuiDownloadService
implements Runnable {
    public static final Proxy.Type[] TYPES = Proxy.Type.values();
    private ITextField txtAddress;
    private ITextField txtPort;
    protected IProgressBar progressBar;
    private IButton btnStart;
    private UiCommand cmdClose;
    private Runnable onUpdate;
    private boolean clearImageCache = false;
    private final UiCommand cmdStartDownload = new UiCommand(){

        @Override
        public void run() {
            if (GuiDownloadService.this.clearImageCache) {
                GuiBase.getInterface().clearImageCache();
            }
            FThreads.invokeInBackgroundThread(GuiDownloadService.this);
            GuiDownloadService.this.btnStart.setEnabled(false);
        }
    };
    private int type;
    private Map<String, String> files;
    protected boolean cancel;
    private final long[] times = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    private int tptr = 0;
    private int skipped = 0;
    private long lTime = System.currentTimeMillis();

    protected GuiDownloadService() {
    }

    public void initialize(ITextField txtAddress0, ITextField txtPort0, IProgressBar progressBar0, IButton btnStart0, UiCommand cmdClose0, Runnable onReadyToStart, Runnable onUpdate0) {
        this.txtAddress = txtAddress0;
        this.txtPort = txtPort0;
        this.progressBar = progressBar0;
        this.btnStart = btnStart0;
        this.cmdClose = cmdClose0;
        this.onUpdate = onUpdate0;
        this.clearImageCache = txtAddress0.getText().contains(".jpg") || txtAddress0.getText().contains(".png");
        String startOverrideDesc = this.getStartOverrideDesc();
        if (startOverrideDesc == null) {
            FThreads.invokeInBackgroundThread(() -> {
                try {
                    this.files = this.getNeededFiles();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FThreads.invokeInEdtLater(() -> {
                    if (onReadyToStart != null) {
                        onReadyToStart.run();
                    }
                    this.readyToStart();
                });
            });
        } else {
            if (onReadyToStart != null) {
                onReadyToStart.run();
            }
            this.progressBar.setDescription("Click \"Start\" to download and extract " + startOverrideDesc);
            this.btnStart.setCommand(this.cmdStartDownload);
            this.btnStart.setEnabled(true);
            FThreads.invokeInEdtLater(() -> this.btnStart.requestFocusInWindow());
        }
    }

    protected String getStartOverrideDesc() {
        return null;
    }

    private void readyToStart() {
        if (this.files == null) {
            this.progressBar.setDescription("Connection error?");
            this.btnStart.setText("OK");
            this.btnStart.setCommand(this.cmdClose);
        } else if (this.files.isEmpty()) {
            this.progressBar.setDescription("All items have been downloaded.");
            this.btnStart.setText("OK");
            this.btnStart.setCommand(this.cmdClose);
        } else {
            this.progressBar.setMaximum(this.files.size());
            this.progressBar.setDescription(this.files.size() == 1 ? "1 item found." : this.files.size() + " items found.");
            this.btnStart.setCommand(this.cmdStartDownload);
        }
        this.btnStart.setEnabled(true);
        FThreads.invokeInEdtLater(() -> this.btnStart.requestFocusInWindow());
    }

    public void setType(int type0) {
        this.type = type0;
    }

    public void setCancel(boolean cancel0) {
        this.cancel = cancel0;
    }

    protected final int getAverageTimePerObject() {
        int numNonzero = 10;
        if (this.tptr > 9) {
            this.tptr = 0;
        }
        this.times[this.tptr] = System.currentTimeMillis() - this.lTime;
        this.lTime = System.currentTimeMillis();
        int tTime = 0;
        for (int i = 0; i < 10; ++i) {
            tTime = (int)((long)tTime + this.times[i]);
            if (this.times[i] != 0L) continue;
            --numNonzero;
        }
        ++this.tptr;
        return tTime / Math.max(1, numNonzero);
    }

    private void update(int count) {
        FThreads.invokeInEdtLater(() -> {
            if (this.onUpdate != null) {
                this.onUpdate.run();
            }
            StringBuilder sb = new StringBuilder();
            int a = this.getAverageTimePerObject();
            if (count != this.files.size()) {
                sb.append(count).append("/").append(this.files.size()).append(" - ");
                long t2Go = (this.files.size() - count) * a;
                if (t2Go > 3600000L) {
                    sb.append(String.format("%02d:", t2Go / 3600000L));
                    t2Go %= 3600000L;
                }
                if (t2Go > 60000L) {
                    sb.append(String.format("%02d:", t2Go / 60000L));
                    t2Go %= 60000L;
                } else {
                    sb.append("00:");
                }
                sb.append(String.format("%02d remaining.", t2Go / 1000L));
            } else {
                sb.append(String.format("%d of %d items finished! Skipped " + this.skipped + " items. Please close!", count, this.files.size()));
                this.finish();
            }
            this.progressBar.setValue(count);
            this.progressBar.setDescription(sb.toString());
        });
    }

    protected void finish() {
        this.btnStart.setText("OK");
        this.btnStart.setCommand(this.cmdClose);
        this.btnStart.setEnabled(true);
        this.btnStart.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        GuiBase.getInterface().preventSystemSleep(true);
        Proxy p = this.getProxy();
        int count = 0;
        int totalCount = this.files.size();
        byte[] buffer = new byte[1024];
        for (Map.Entry<String, String> kv : this.files.entrySet()) {
            boolean cardSkipped;
            block39: {
                boolean isJPG = true;
                boolean isLogged = false;
                boolean fullborder = false;
                if (this.cancel) {
                    GuiBase.getInterface().preventSystemSleep(false);
                    break;
                }
                cardSkipped = true;
                String url = kv.getValue();
                String decodedKey = GuiDownloadService.decodeURL(kv.getKey());
                File fileDest = new File(decodedKey);
                String filePath = fileDest.getPath();
                String subLastIndex = filePath.contains("pics") ? "\\pics\\" : (filePath.contains("skins") ? "\\" + FileUtil.getParent(filePath) + "\\" : "\\db\\");
                System.out.println(++count + "/" + totalCount + " - .." + filePath.substring(filePath.lastIndexOf(subLastIndex) + 1));
                FileOutputStream fos = null;
                try {
                    File base = fileDest.getParentFile();
                    if (FileUtil.ensureDirectoryExists(base)) {
                        URL imageUrl = new URL(url);
                        HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection(p);
                        if (url.contains("api.scryfall.com")) {
                            conn.setInstanceFollowRedirects(true);
                            TimeUnit.MILLISECONDS.sleep(100L);
                        } else {
                            conn.setInstanceFollowRedirects(false);
                        }
                        conn.connect();
                        if (conn.getResponseCode() == 404 && url.contains(".full.jpg")) {
                            fullborder = true;
                            conn.disconnect();
                            url = TextUtil.fastReplace(url, ".full.jpg", ".fullborder.jpg");
                            imageUrl = new URL(url);
                            conn = (HttpURLConnection)imageUrl.openConnection(p);
                            conn.setInstanceFollowRedirects(false);
                            conn.connect();
                        }
                        if (conn.getResponseCode() == 404 && url.endsWith(".jpg")) {
                            fullborder = false;
                            isJPG = false;
                            conn.disconnect();
                            if (url.contains("/images/")) {
                                isLogged = true;
                                System.out.println("File not found: .." + url.substring(url.lastIndexOf("/images/") + 1));
                            }
                            url = url.substring(0, url.length() - 4) + ".png";
                            imageUrl = new URL(TextUtil.fastReplace(url, ".fullborder.", ".full."));
                            conn = (HttpURLConnection)imageUrl.openConnection(p);
                            conn.setInstanceFollowRedirects(false);
                            conn.connect();
                        }
                        if (fullborder) {
                            fileDest = new File(TextUtil.fastReplace(decodedKey, ".full.jpg", ".fullborder.jpg"));
                        }
                        switch (conn.getResponseCode()) {
                            case 200: {
                                int bufferLength;
                                fos = new FileOutputStream(fileDest);
                                InputStream inputStream = conn.getInputStream();
                                while ((bufferLength = inputStream.read(buffer)) > 0) {
                                    fos.write(buffer, 0, bufferLength);
                                }
                                cardSkipped = false;
                                break;
                            }
                            case 404: {
                                conn.disconnect();
                                if (url.contains("/images/") && !isJPG && !isLogged) {
                                    System.out.println("File not found: .." + url.substring(url.lastIndexOf("/images/") + 1));
                                    break;
                                }
                                break block39;
                            }
                            default: {
                                conn.disconnect();
                                System.out.println("  Connection failed for url: " + url);
                                break;
                            }
                        }
                        break block39;
                    }
                    System.out.println("  Can't create folder: " + base.getAbsolutePath());
                }
                catch (ConnectException ce) {
                    System.out.println("  Connection refused for url: " + url);
                }
                catch (MalformedURLException mURLe) {
                    System.out.println("  Error - possibly missing URL for: " + fileDest.getName());
                }
                catch (FileNotFoundException fnfe) {
                    String formatStr = "  Error - the LQ picture %s could not be found on the server. [%s] - %s";
                    System.out.printf(formatStr + "%n", fileDest.getName(), url, fnfe.getMessage());
                }
                catch (Exception ex) {
                    Log.error("LQ Pictures", "Error downloading pictures", ex);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            System.out.println("  Error closing output stream");
                        }
                    }
                }
            }
            this.update(count);
            if (!cardSkipped) continue;
            ++this.skipped;
        }
        GuiBase.getInterface().preventSystemSleep(false);
    }

    private static String decodeURL(String key) {
        return URLDecoder.decode(key);
    }

    protected Proxy getProxy() {
        if (this.type == 0) {
            return Proxy.NO_PROXY;
        }
        try {
            return new Proxy(TYPES[this.type], new InetSocketAddress(this.txtAddress.getText(), Integer.parseInt(this.txtPort.getText())));
        }
        catch (Exception ex) {
            BugReporter.reportException(ex, "Proxy connection could not be established!\nProxy address: %s\nProxy port: %s", this.txtAddress.getText(), this.txtPort.getText());
            return null;
        }
    }

    public abstract String getTitle();

    protected abstract Map<String, String> getNeededFiles();

    protected static void addMissingItems(Map<String, String> list, String nameUrlFile, String dir) {
        GuiDownloadService.addMissingItems(list, nameUrlFile, dir, false);
    }

    protected static void addMissingItems(Map<String, String> list, String nameUrlFile, String dir, boolean includeParent) {
        Iterator<Pair<String, String>> iterator = FileUtil.readNameUrlFile(nameUrlFile).iterator();
        while (iterator.hasNext()) {
            Pair<String, String> nameUrlPair;
            File f = new File(includeParent ? dir + FileUtil.getParent(nameUrlPair.getRight()) : dir, GuiDownloadService.decodeURL((nameUrlPair = iterator.next()).getLeft()));
            if (f.exists()) continue;
            list.put(f.getAbsolutePath(), nameUrlPair.getRight());
        }
    }

    protected static HashSet<String> retrieveManifestDirectory() {
        String manifestUrl = "https://downloads.cardforge.org/images/cards/";
        HashSet<String> existingSets = new HashSet<String>();
        String response = HttpUtil.getURL(manifestUrl);
        if (response == null) {
            return null;
        }
        String[] strings = response.split("<a href=\"");
        Pattern pattern = Pattern.compile(">([A-Z0-9_]+)/<");
        for (String s2 : strings) {
            Matcher matcher = pattern.matcher(s2);
            if (!matcher.find()) continue;
            existingSets.add(matcher.group(1));
        }
        return existingSets;
    }
}

