/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.download;

import forge.ImageKeys;
import forge.StaticData;
import forge.gui.download.GuiDownloadService;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.ImageUtil;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GuiDownloadPicturesLQ
extends GuiDownloadService {
    final Map<String, String> downloads = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    Set<String> existingSets;

    @Override
    public String getTitle() {
        return "Download LQ Card Pictures";
    }

    @Override
    protected final Map<String, String> getNeededFiles() {
        this.existingSets = GuiDownloadPicturesLQ.retrieveManifestDirectory();
        for (PaperCard c : FModel.getMagicDb().getCommonCards().getAllCards()) {
            this.addDLObject(c, "");
            if (!c.hasBackFace()) continue;
            this.addDLObject(c, "back");
        }
        for (PaperCard c : FModel.getMagicDb().getVariantCards().getAllCards()) {
            this.addDLObject(c, "");
        }
        GuiDownloadPicturesLQ.addMissingItems(this.downloads, ForgeConstants.IMAGE_LIST_TOKENS_FILE, ForgeConstants.CACHE_TOKEN_PICS_DIR);
        return this.downloads;
    }

    private void addDLObject(PaperCard c, String face) {
        String imageKey = ImageUtil.getImageKey(c, face, false);
        String destPath = ForgeConstants.CACHE_CARD_PICS_DIR + imageKey + ".jpg";
        if (ImageKeys.getImageFile(imageKey) != null) {
            return;
        }
        if (this.downloads.containsKey(destPath)) {
            return;
        }
        String setCode3 = c.getEdition();
        String setCode2 = StaticData.instance().getEditions().getCode2ByCode(setCode3);
        if (!this.existingSets.contains(setCode3) && !this.existingSets.contains(setCode2)) {
            return;
        }
        this.downloads.put(destPath, "https://downloads.cardforge.org/images/cards/" + ImageUtil.getDownloadUrl(c, face));
    }
}

