/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.card;

import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CardScriptInfo {
    private String text;
    private final File file;
    private static Map<String, CardScriptInfo> allScripts = new ConcurrentHashMap<String, CardScriptInfo>();

    public CardScriptInfo(String text0, File file0) {
        this.text = text0;
        this.file = file0;
    }

    public String getText() {
        return this.text;
    }

    public File getFile() {
        return this.file;
    }

    public boolean canEdit() {
        return this.file != null;
    }

    public boolean trySetText(String text0) {
        if (this.file == null) {
            return false;
        }
        PrintWriter p = new PrintWriter(this.file);
        try {
            p.print(text0);
            if (!text0.endsWith("\n")) {
                p.print("\n");
            }
            this.text = text0;
            boolean bl = true;
            p.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                System.err.println("Problem writing file - " + this.file);
                ex.printStackTrace();
                return false;
            }
        }
    }

    public static CardScriptInfo getScriptFor(String name) {
        CardScriptInfo script = allScripts.get(name);
        if (script == null) {
            String[] folders;
            String filename = name.toLowerCase().replaceAll("[^-a-z0-9_\\s]", "").replaceAll("[-\\s]", "_").replaceAll("__", "_") + ".txt";
            for (String folder : folders = new String[]{ForgeConstants.CARD_DATA_DIR + File.separator + String.valueOf(filename.charAt(0)), ForgeConstants.CARD_DATA_DIR + File.separator + "upcoming", ForgeConstants.USER_CUSTOM_CARDS_DIR + File.separator + String.valueOf(filename.charAt(0)), ForgeConstants.USER_CUSTOM_CARDS_DIR}) {
                File file = new File(folder + File.separator + filename);
                if (!file.exists()) continue;
                script = new CardScriptInfo(FileUtil.readFileToString(file), file);
                allScripts.put(name, script);
                break;
            }
        }
        return script;
    }
}

