/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.card;

import forge.CardStorageReader;
import forge.card.CardRules;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CardReaderExperiments {
    public static void parseAllCards(String[] args) {
        if (args.length < 2) {
            return;
        }
        int totalParsedCount = 0;
        ArrayList output = new ArrayList();
        for (int i = 1; i < args.length; ++i) {
            output.add(new ArrayList());
        }
        List<File> allFiles = CardStorageReader.collectCardFiles(new ArrayList<File>(), new File(ForgeConstants.CARD_DATA_DIR));
        Charset charset = Charset.forName("UTF-8");
        CardRules.Reader rulesReader = new CardRules.Reader();
        for (File file : allFiles) {
            rulesReader.reset();
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), charset);
                List<String> lines = FileUtil.readAllLines(isr, true);
                CardRules rules = rulesReader.readCard(lines);
                System.out.println();
                System.out.print(rules.getName());
                ++totalParsedCount;
                for (int i = 1; i < args.length; ++i) {
                    switch (args[i]) {
                        case "updateAbilityManaSymbols": {
                            CardReaderExperiments.updateAbilityManaSymbols(rules, lines, file, (List)output.get(i - 1));
                        }
                    }
                }
            }
            catch (FileNotFoundException lines) {
            }
        }
        System.out.println();
        System.out.println();
        System.out.print("Total cards: " + totalParsedCount);
        for (int i = 1; i < args.length; ++i) {
            List singleOutput = (List)output.get(i - 1);
            System.out.println();
            System.out.println();
            System.out.println(args[i] + ":");
            System.out.println();
            for (String line : singleOutput) {
                System.out.println(line);
            }
            System.out.println();
            System.out.print("Total cards: " + singleOutput.size());
        }
    }

    private static void updateAbilityManaSymbols(CardRules rules, List<String> lines, File file, List<String> output) {
        String[] phrases;
        String pattern;
        String[] sentences;
        String newLine;
        int i;
        boolean updated = false;
        String wubrg = "WUBRG";
        for (i = 0; i < lines.size(); ++i) {
            newLine = lines.get(i);
            for (int c = 0; c < 5; ++c) {
                int ch1 = wubrg.charAt(c);
                int ch2 = wubrg.charAt((c + 1) % 5);
                char ch3 = wubrg.charAt((c + 2) % 5);
                newLine = newLine.replaceAll("(^|\\W)(" + (char)ch2 + "|" + ch3 + ")( ?)(/?)" + (char)ch1 + "(\\W|$)", "$1" + (char)ch1 + "$3$4$2$5");
                newLine = newLine.replaceAll("(^|\\W)\\{(" + (char)ch2 + "|" + ch3 + ")\\}\\{" + (char)ch1 + "\\}(\\W|$)", "$1\\{" + (char)ch1 + "\\}\\{$2\\}$3");
            }
            if (newLine.equals(lines.get(i))) continue;
            updated = true;
            lines.set(i, newLine);
            --i;
        }
        for (i = 0; i < lines.size(); ++i) {
            newLine = lines.get(i).replaceAll("\\{([WUBRG2P])([WUBRG])\\}", "\\{$1/$2\\}").replaceAll("\\{([WUBRG])/2\\}", "\\{2/$1\\}").replaceAll("\\{([WUBRG])/P\\}", "\\{$1/P\\}");
            if (newLine.equals(lines.get(i))) continue;
            updated = true;
            lines.set(i, newLine);
        }
        if (updated) {
            rules = CardRules.fromScript(lines);
        }
        String oracleText = rules.getOracleText();
        for (String s2 : sentences = oracleText.replace(rules.getName(), "CARDNAME").split("\\.|\\\\n|\\\"|\\(|\\)")) {
            int idx = s2.indexOf(":");
            if (idx != -1) {
                s2 = s2.substring(idx + 1);
            }
            if (s2.isEmpty()) continue;
            try {
                pattern = s2.replaceAll("\\{([WUBRGSXYZ]|[0-9]+)\\}", "$1[ ]\\?").replaceAll("\\{([WUBRG2P])/([WUBRG])\\}", "$1$2[ ]\\?").replaceAll("\\{C\\}", "Chaos");
                if (pattern.length() == s2.length()) continue;
                pattern = "Description\\$(.*)" + pattern;
                s2 = "Description\\$$1" + s2;
                for (int i2 = 0; i2 < lines.size(); ++i2) {
                    String newLine2 = lines.get(i2).replaceAll(pattern, s2);
                    if (newLine2.length() == lines.get(i2).length()) continue;
                    updated = true;
                    lines.set(i2, newLine2);
                }
            }
            catch (Exception ex) {
                output.add("<Exception (" + rules.getName() + ") " + ex.getMessage() + ">");
                return;
            }
        }
        for (String phrase : phrases = new String[]{"Add * to your mana pool", "CostDesc\\$ * \\|"}) {
            pattern = ".*" + phrase.replace("* ", "((([WUBRGSXYZ]|[0-9]+) )+)") + ".*";
            Pattern p = Pattern.compile(pattern);
            for (int i3 = 0; i3 < lines.size(); ++i3) {
                String line = lines.get(i3);
                Matcher m4 = p.matcher(line);
                if (!m4.matches()) continue;
                StringBuilder newLineBuilder = new StringBuilder();
                newLineBuilder.append(line, 0, m4.start(1));
                for (String sym : m4.group(1).split(" ")) {
                    newLineBuilder.append("{").append(sym).append("}");
                }
                newLineBuilder.append(line.substring(m4.end(1) - 1));
                updated = true;
                lines.set(i3, newLineBuilder.toString());
            }
        }
        if (updated) {
            try (PrintWriter p = new PrintWriter(file);){
                for (int i4 = 0; i4 < lines.size(); ++i4) {
                    if (i4 < lines.size() - 1) {
                        p.println(lines.get(i4));
                        continue;
                    }
                    p.print(lines.get(i4));
                }
                output.add(rules.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

