/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.card;

import forge.item.IPaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.TextUtil;
import forge.util.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CardPreferences {
    private static Map<String, CardPreferences> allPrefs = new HashMap<String, CardPreferences>();
    private final String cardName;
    private int starCount;
    private String preferredArt;

    public static CardPreferences getPrefs(IPaperCard card) {
        String cardName = card.getName();
        CardPreferences prefs = allPrefs.computeIfAbsent(cardName, CardPreferences::new);
        return prefs;
    }

    public static void load() {
        allPrefs.clear();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(ForgeConstants.CARD_PREFS_FILE));
            NodeList cards = document.getElementsByTagName("card");
            for (int i = 0; i < cards.getLength(); ++i) {
                Element el = (Element)cards.item(i);
                CardPreferences prefs = new CardPreferences(el.getAttribute("name"));
                allPrefs.put(prefs.cardName, prefs);
                prefs.setStarCount(XmlUtil.getIntAttribute(el, "stars"));
                prefs.setPreferredArt(XmlUtil.getStringAttribute(el, "art"));
            }
        }
        catch (FileNotFoundException builder) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("preferences");
            root.setAttribute("type", "cards");
            document.appendChild(root);
            for (Map.Entry<String, CardPreferences> entry : allPrefs.entrySet()) {
                CardPreferences prefs = entry.getValue();
                if (prefs.starCount <= 0 && prefs.preferredArt == null) continue;
                Element card = document.createElement("card");
                card.setAttribute("name", entry.getKey());
                if (prefs.starCount > 0) {
                    card.setAttribute("stars", String.valueOf(prefs.starCount));
                }
                if (prefs.preferredArt != null) {
                    card.setAttribute("art", prefs.preferredArt);
                }
                root.appendChild(card);
            }
            XmlUtil.saveDocument(document, ForgeConstants.CARD_PREFS_FILE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CardPreferences(String cardName0) {
        this.cardName = cardName0;
    }

    public int getStarCount() {
        return this.starCount;
    }

    public void setStarCount(int starCount0) {
        this.starCount = starCount0;
    }

    public String getPreferredArt() {
        return this.preferredArt;
    }

    public void setPreferredArt(String preferredArt0) {
        if (preferredArt0 == null) {
            this.preferredArt = null;
            return;
        }
        if (preferredArt0.equals(this.preferredArt)) {
            return;
        }
        try {
            int infoArtIndex;
            String infoSetCode;
            String infoCardName;
            String[] prefArtInfos = TextUtil.split(preferredArt0, '|');
            if (prefArtInfos.length == 2) {
                infoCardName = this.cardName;
                infoSetCode = prefArtInfos[0];
                infoArtIndex = Integer.parseInt(prefArtInfos[1]);
            } else {
                infoCardName = prefArtInfos[0];
                infoSetCode = prefArtInfos[1];
                infoArtIndex = Integer.parseInt(prefArtInfos[2]);
            }
            if (!this.cardName.equals(infoCardName)) {
                return;
            }
            if (FModel.getMagicDb().getCommonCards().setPreferredArt(this.cardName, infoSetCode, infoArtIndex)) {
                this.preferredArt = preferredArt0;
            }
        }
        catch (NumberFormatException ex) {
            System.err.println("ERROR with Existing Preferred Card Entry: " + preferredArt0);
        }
    }

    public void setPreferredArt(String setCode, int artIndex) {
        this.setPreferredArt(setCode + '|' + artIndex);
    }
}

