/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament.system;

import com.google.common.collect.Lists;
import forge.gamemodes.tournament.system.AbstractTournament;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TournamentSwiss
extends AbstractTournament {
    public TournamentSwiss(int ttlRnds, int pairingAmount) {
        super(ttlRnds);
        this.playersInPairing = pairingAmount;
    }

    public TournamentSwiss(List<TournamentPlayer> allPlayers, int pairingAmount) {
        super((int)Math.ceil(Math.log(allPlayers.size()) / Math.log(2.0)), allPlayers);
        this.playersInPairing = pairingAmount;
    }

    @Override
    public void generateActivePairings() {
        int frontOfGroup = 0;
        boolean pairing = true;
        TournamentPlayer byePlayer = null;
        ++this.activeRound;
        Collections.shuffle(this.allPlayers);
        this.sortAllPlayers("swiss");
        if (this.allPlayers.size() % 2 == 1) {
            int i = this.allPlayers.size() - 1;
            while (byePlayer == null) {
                TournamentPlayer pl = (TournamentPlayer)this.allPlayers.get(i);
                if (pl.getByes() == 0) {
                    byePlayer = pl;
                }
                --i;
            }
        }
        List<Object> leftoverPlayers = new ArrayList();
        ArrayList groupPlayers = Lists.newArrayList(this.allPlayers);
        if (byePlayer != null) {
            groupPlayers.remove(byePlayer);
            TournamentPairing byePair = new TournamentPairing(this.activeRound, Lists.newArrayList(byePlayer));
            byePair.setBye(true);
            this.activePairings.add(byePair);
        }
        if (groupPlayers.isEmpty()) {
            return;
        }
        int score = ((TournamentPlayer)groupPlayers.get(frontOfGroup)).getScore();
        while (pairing) {
            int backOfGroup;
            for (backOfGroup = frontOfGroup + 1; backOfGroup < groupPlayers.size() && ((TournamentPlayer)this.allPlayers.get(backOfGroup)).getScore() >= score; ++backOfGroup) {
            }
            ArrayList<TournamentPlayer> plyrs = Lists.newArrayList();
            if (!groupPlayers.isEmpty()) {
                plyrs.addAll(groupPlayers.subList(frontOfGroup, backOfGroup));
            }
            plyrs.addAll(0, leftoverPlayers);
            groupPlayers.removeAll(plyrs);
            if (this.activeRound < 3) {
                leftoverPlayers = this.pairSwissGroup(plyrs);
            } else {
                int playersToPair = plyrs.size();
                if (playersToPair == (leftoverPlayers = this.pairComplexSwissGroup(plyrs)).size() && groupPlayers.isEmpty()) {
                    System.out.println("Only players left already played each other. Force pairing?");
                    leftoverPlayers = this.pairSwissGroup(leftoverPlayers);
                }
            }
            if (leftoverPlayers.isEmpty() && groupPlayers.isEmpty()) {
                pairing = false;
                continue;
            }
            if (!groupPlayers.isEmpty()) {
                score = ((TournamentPlayer)groupPlayers.get(frontOfGroup)).getSwissScore();
                continue;
            }
            score = ((TournamentPlayer)leftoverPlayers.get(frontOfGroup)).getSwissScore();
        }
    }

    private List<TournamentPlayer> pairComplexSwissGroup(List<TournamentPlayer> players) {
        HashMap availableOpponents = new HashMap();
        int oppClashes = 0;
        ArrayList<TournamentPlayer> unpairedPlayers = Lists.newArrayList();
        for (TournamentPlayer tp : players) {
            HashSet<TournamentPlayer> opponents = new HashSet<TournamentPlayer>();
            Iterator prevOpps = tp.getPreviousOpponents();
            for (TournamentPlayer opp : players) {
                if (!prevOpps.contains(opp.getIndex()) && !opp.equals(tp)) {
                    opponents.add(opp);
                    continue;
                }
                if (opp.equals(tp)) continue;
                ++oppClashes;
            }
            availableOpponents.put(tp, opponents);
        }
        if ((oppClashes /= 2) == 0) {
            return this.pairSwissGroup(players);
        }
        players.sort(Comparator.comparingInt(o -> ((HashSet)availableOpponents.get(o)).size()));
        while (players.size() > 1) {
            TournamentPlayer initialPlayer = players.get(0);
            players.remove(0);
            ArrayList<TournamentPlayer> pair = new ArrayList<TournamentPlayer>();
            HashSet opposing = (HashSet)availableOpponents.get(initialPlayer);
            for (TournamentPlayer opp : players) {
                if (!opposing.contains(opp)) continue;
                pair.add(opp);
                break;
            }
            for (TournamentPlayer opp : pair) {
                players.remove(opp);
            }
            if (pair.isEmpty()) {
                unpairedPlayers.add(initialPlayer);
                continue;
            }
            pair.add(initialPlayer);
            TournamentPairing pairing = new TournamentPairing(this.activeRound, pair);
            this.activePairings.add(pairing);
        }
        unpairedPlayers.addAll(players);
        return unpairedPlayers;
    }

    private List<TournamentPlayer> pairSwissGroup(List<TournamentPlayer> players) {
        ArrayList<TournamentPlayer> pair = new ArrayList<TournamentPlayer>();
        ArrayList<TournamentPlayer> unpairable = new ArrayList<TournamentPlayer>();
        for (TournamentPlayer player : players) {
            pair.add(player);
            if (pair.size() != this.playersInPairing) continue;
            TournamentPairing pairing = new TournamentPairing(this.activeRound, pair);
            this.activePairings.add(pairing);
            pair = new ArrayList();
        }
        if (!pair.isEmpty()) {
            unpairable.addAll(pair);
        }
        return unpairable;
    }

    @Override
    public boolean reportMatchCompletion(TournamentPairing pairing) {
        this.finishMatch(pairing);
        ArrayList<Integer> oppIndexes = new ArrayList<Integer>();
        for (TournamentPlayer tp : pairing.getPairedPlayers()) {
            if (pairing.isBye()) {
                tp.addBye();
                continue;
            }
            oppIndexes.add(tp.getIndex());
            if (!tp.equals(pairing.getWinner())) {
                tp.addLoss();
                continue;
            }
            tp.addWin();
        }
        for (TournamentPlayer tp : pairing.getPairedPlayers()) {
            for (Integer i : oppIndexes) {
                if (i == null || i.equals(tp.getIndex())) continue;
                tp.addOpponentIndex(i);
            }
        }
        if (this.activePairings.isEmpty()) {
            this.completeRound();
            return false;
        }
        return true;
    }

    @Override
    public void endTournament() {
        this.activePairings.clear();
    }
}

