/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament.system;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import forge.LobbyPlayer;
import forge.deck.DeckGroup;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import forge.player.GamePlayerUtil;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTournament
implements Serializable {
    protected int activeRound = 0;
    protected int totalRounds;
    protected int playersInPairing = 2;
    protected boolean initialized = false;
    protected boolean continualPairing = true;
    protected final List<TournamentPlayer> allPlayers = new ArrayList<TournamentPlayer>();
    protected final transient List<TournamentPlayer> remainingPlayers = new ArrayList<TournamentPlayer>();
    protected final List<TournamentPairing> completedPairings = new ArrayList<TournamentPairing>();
    protected final List<TournamentPairing> activePairings = new ArrayList<TournamentPairing>();

    public List<TournamentPairing> getCompletedPairings() {
        return this.completedPairings;
    }

    public List<TournamentPairing> getActivePairings() {
        return this.activePairings;
    }

    public AbstractTournament(int ttlRnds) {
        this.totalRounds = ttlRnds;
    }

    public AbstractTournament(int ttlRnds, List<TournamentPlayer> plrs) {
        this.totalRounds = ttlRnds;
        this.allPlayers.addAll(plrs);
        this.remainingPlayers.addAll(plrs);
    }

    public void initializeTournament() {
        Collections.shuffle(this.remainingPlayers, MyRandom.getRandom());
        this.generateActivePairings();
        this.initialized = true;
    }

    public TournamentPairing getNextPairing() {
        if (this.activePairings.isEmpty()) {
            return null;
        }
        return this.activePairings.get(0);
    }

    public int getActiveRound() {
        return this.activeRound;
    }

    public int getTotalRounds() {
        return this.totalRounds;
    }

    public boolean isContinualPairing() {
        return this.continualPairing;
    }

    public void setContinualPairing(boolean continualPairing) {
        this.continualPairing = continualPairing;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isPlayerRemaining(TournamentPlayer player) {
        return this.remainingPlayers.contains(player);
    }

    public boolean isPlayerRemaining(int index) {
        for (TournamentPlayer player : this.remainingPlayers) {
            if (player.getIndex() != index) continue;
            return true;
        }
        return false;
    }

    public abstract void generateActivePairings();

    public abstract boolean reportMatchCompletion(TournamentPairing var1);

    public boolean completeRound() {
        if (this.activeRound < this.totalRounds) {
            if (this.continualPairing) {
                this.generateActivePairings();
            }
            return true;
        }
        this.endTournament();
        return false;
    }

    public void finishMatch(TournamentPairing pairing) {
        this.activePairings.remove(pairing);
        this.completedPairings.add(pairing);
    }

    public abstract void endTournament();

    public boolean isTournamentOver() {
        return this.initialized && this.activeRound == this.totalRounds && this.activePairings.isEmpty();
    }

    public void sortAllPlayers(String sortType) {
        if (sortType.equals("score")) {
            this.allPlayers.sort((o1, o2) -> o2.getScore() - o1.getScore());
        } else if (sortType.equals("index")) {
            this.allPlayers.sort((o1, o2) -> o2.getIndex() - o1.getIndex());
        } else if (sortType.equals("swiss")) {
            this.allPlayers.sort((o1, o2) -> o2.getSwissScore() - o1.getSwissScore());
        }
    }

    public void outputTournamentResults() {
        this.sortAllPlayers("score");
        for (TournamentPlayer tp : this.allPlayers) {
            System.out.println(TextUtil.concatNoSpace(tp.getPlayer().getName(), "\t\t", String.valueOf(tp.getWins()), " Wins(", String.valueOf(tp.getByes()), " Byes)-", String.valueOf(tp.getLosses()), " Losses-", String.valueOf(tp.getTies()), " Ties\t=>\t", String.valueOf(tp.getScore()), " Points"));
        }
    }

    public List<TournamentPlayer> getAllPlayers() {
        return this.allPlayers;
    }

    public static List<RegisteredPlayer> registerTournamentPlayers(TournamentPairing pairing, DeckGroup decks) {
        ArrayList<RegisteredPlayer> registered = Lists.newArrayList();
        for (TournamentPlayer pl : pairing.getPairedPlayers()) {
            if (pl.getIndex() == -1) {
                registered.add(new RegisteredPlayer(decks.getHumanDeck()).setPlayer(pl.getPlayer()));
                continue;
            }
            registered.add(new RegisteredPlayer(decks.getAiDecks().get(pl.getIndex())).setPlayer(pl.getPlayer()));
        }
        return registered;
    }

    public void addTournamentPlayer(LobbyPlayer pl) {
        TournamentPlayer player = new TournamentPlayer(pl);
        this.allPlayers.add(player);
        this.remainingPlayers.add(player);
    }

    public void addTournamentPlayer(LobbyPlayer pl, int idx) {
        TournamentPlayer player = new TournamentPlayer(pl, idx);
        this.allPlayers.add(player);
        this.remainingPlayers.add(player);
    }

    public void createTournamentPlayersForDraft(String[] names, int[] icons) {
        int size = names.length;
        for (int i = 0; i < size; ++i) {
            TournamentPlayer player = new TournamentPlayer(GamePlayerUtil.createAiPlayer(names[i], icons[i]), i);
            this.allPlayers.add(player);
            this.remainingPlayers.add(player);
        }
    }

    public void exportToXML(HierarchicalStreamWriter writer) {
        writer.startNode("activeRound");
        writer.setValue(Integer.toString(this.activeRound));
        writer.endNode();
        writer.startNode("totalRounds");
        writer.setValue(Integer.toString(this.totalRounds));
        writer.endNode();
        writer.startNode("playersInPairing");
        writer.setValue(Integer.toString(this.playersInPairing));
        writer.endNode();
        writer.startNode("initialized");
        writer.setValue(Boolean.toString(this.initialized));
        writer.endNode();
        writer.startNode("allPlayers");
        for (TournamentPlayer player : this.allPlayers) {
            writer.startNode("tournamentPlayer");
            writer.setValue(player.toString());
            writer.endNode();
        }
        writer.endNode();
        writer.startNode("completedPairings");
        for (TournamentPairing pairing : this.completedPairings) {
            writer.startNode("tournamentPairing");
            pairing.exportToXML(writer);
            writer.endNode();
        }
        writer.endNode();
        writer.startNode("completedPairings");
        for (TournamentPairing pairing : this.activePairings) {
            writer.startNode("tournamentPairing");
            pairing.exportToXML(writer);
            writer.endNode();
        }
        writer.endNode();
    }
}

