/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament;

import com.google.common.collect.Lists;
import forge.LobbyPlayer;
import forge.deck.Deck;
import forge.game.GameView;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.tournament.TournamentData;
import forge.gamemodes.tournament.TournamentIO;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IWinLoseView;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.List;

public abstract class TournamentWinLoseController {
    private final Localizer localizer = Localizer.getInstance();
    private final IWinLoseView<? extends IButton> view;
    private final GameView lastGame;

    public TournamentWinLoseController(IWinLoseView<? extends IButton> view0, GameView game0) {
        this.view = view0;
        this.lastGame = game0;
    }

    public void showOutcome() {
        TournamentData gd = FModel.getTournamentData();
        if (gd.getEventNames() == null || gd.getEventRecords() == null) {
            gd.setEventNames(new ArrayList<String>());
            gd.setEventRecords(new ArrayList<String>());
            gd.reset();
        }
        List<String> lstEventNames = gd.getEventNames();
        List<Deck> lstDecks = gd.getDecks();
        List<String> lstEventRecords = gd.getEventRecords();
        int len = lstDecks.size();
        int num = gd.getCompleted();
        FSkinProp icon = null;
        String message1 = null;
        String message2 = null;
        this.view.getBtnRestart().setVisible(false);
        lstEventRecords.set(gd.getCompleted(), "Ongoing");
        LobbyPlayer questPlayer = GamePlayerUtil.getGuiPlayer();
        lstEventRecords.set(gd.getCompleted(), this.lastGame.getGamesWonBy(questPlayer) + " - " + (this.lastGame.getNumPlayedGamesInMatch() - this.lastGame.getGamesWonBy(questPlayer) + 1));
        boolean isMatchOver = this.lastGame.isMatchOver();
        if (isMatchOver) {
            gd.setCompleted(gd.getCompleted() + 1);
            if (this.lastGame.isMatchWonBy(questPlayer)) {
                if (gd.getCompleted() == lstDecks.size()) {
                    icon = FSkinProp.ICO_QUEST_COIN;
                    message1 = this.localizer.getMessage("lblCongratulations", new Object[0]);
                    message2 = this.localizer.getMessage("lblThroughTournament", new Object[0]);
                    this.view.getBtnContinue().setVisible(false);
                    this.view.getBtnQuit().setText(this.localizer.getMessage("lblOK", new Object[0]));
                    if (gd.getName().startsWith("Quick_")) {
                        TournamentIO.getTournamentFile(gd).delete();
                    } else {
                        gd.reset();
                    }
                } else {
                    gd.stamp();
                    TournamentIO.saveTournament(gd);
                    this.view.getBtnContinue().setText(this.localizer.getMessage("btnNextRound", new Object[0]) + " (" + (gd.getCompleted() + 1) + "/" + len + ")");
                    this.view.getBtnContinue().setVisible(true);
                    this.view.getBtnContinue().setEnabled(true);
                    this.view.getBtnQuit().setText(this.localizer.getMessage("btnSaveQuit", new Object[0]));
                }
            } else {
                icon = FSkinProp.ICO_QUEST_HEART;
                message1 = this.localizer.getMessage("lblDefeated", new Object[0]);
                message2 = this.localizer.getMessage("lblFailedTournament", new Object[0]);
                this.view.getBtnContinue().setVisible(false);
                if (gd.getName().startsWith("Quick_")) {
                    TournamentIO.getTournamentFile(gd).delete();
                } else {
                    gd.reset();
                }
            }
        }
        gd.setEventRecords(lstEventRecords);
        this.showOutcome(isMatchOver, message1, message2, icon, lstEventNames, lstEventRecords, len, num);
    }

    public final boolean actionOnContinue() {
        if (this.lastGame.isMatchOver()) {
            TournamentData gd = FModel.getTournamentData();
            RegisteredPlayer human = new RegisteredPlayer(gd.getUserDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
            Deck aiDeck = gd.getDecks().get(gd.getCompleted());
            ArrayList<RegisteredPlayer> players = Lists.newArrayList();
            players.add(human);
            players.add(new RegisteredPlayer(aiDeck).setPlayer(GamePlayerUtil.createAiPlayer()));
            this.view.hide();
            this.saveOptions();
            gd.nextRound(players, human);
            return true;
        }
        return false;
    }

    protected abstract void showOutcome(boolean var1, String var2, String var3, FSkinProp var4, List<String> var5, List<String> var6, int var7, int var8);

    protected abstract void saveOptions();
}

