/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.setrotation;

import forge.gamemodes.quest.setrotation.ISetRotation;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class QueueRandomRotation
implements ISetRotation {
    private int concurrentSets;
    private int rotateAfterWins;
    private int setsPerRotation;

    @Override
    public List<String> getCurrentSetCodes(List<String> allSets) {
        if (FModel.getQuest() == null) {
            return allSets;
        }
        int seed = FModel.getQuest().getName().hashCode();
        Random rnd = new Random(seed);
        ArrayList<String> shuffledSets = new ArrayList<String>(allSets);
        Collections.shuffle(shuffledSets, rnd);
        ArrayList<String> currentCodes = new ArrayList<String>();
        int outRotations = FModel.getQuest().getAchievements().getWin() / this.rotateAfterWins;
        int outRotated = outRotations * this.setsPerRotation;
        int setsToAdd = Integer.min(this.concurrentSets, shuffledSets.size());
        for (int i = 0; i < setsToAdd; ++i) {
            int setToAdd = (i + outRotated) % shuffledSets.size();
            currentCodes.add((String)shuffledSets.get(setToAdd));
        }
        return currentCodes;
    }

    public QueueRandomRotation(int concurrentSets, int rotateAfterWins, int setsPerRotation) {
        this.concurrentSets = concurrentSets;
        this.rotateAfterWins = rotateAfterWins;
        this.setsPerRotation = setsPerRotation;
    }
}

