/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.io;

import forge.card.MagicColor;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import forge.util.MyRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReadPriceList {
    private static final String COMMENT = "//";
    private Map<String, Integer> priceMap;

    public ReadPriceList() {
        this.setup();
    }

    private void setup() {
        this.priceMap = this.readFile(ForgeConstants.QUEST_CARD_PRICE_FILE);
        this.priceMap.putAll(this.readFile(ForgeConstants.PRICES_BOOSTER_FILE));
    }

    private Map<String, Integer> readFile(String file) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<String> lines = FileUtil.readFile(file);
        for (String line : lines) {
            String[] s2;
            if (line.trim().isEmpty() || line.startsWith(COMMENT) || (s2 = line.split("=")).length < 2) continue;
            String name = s2[0].trim();
            String price = s2[1].trim();
            try {
                int val = Integer.parseInt(price.trim());
                if (!(MagicColor.Constant.BASIC_LANDS.contains(name) || MagicColor.Constant.SNOW_LANDS.contains(name) || ForgeConstants.PRICES_BOOSTER_FILE.equals(file))) {
                    float ff = MyRandom.getRandom().nextInt(100) < 90 ? (float)MyRandom.getRandom().nextInt(10) * 0.01f : (float)MyRandom.getRandom().nextInt(50) * 0.01f;
                    val = MyRandom.getRandom().nextInt(100) < 50 ? (int)((float)val * (1.0f - ff)) : (int)((float)val * (1.0f + ff));
                }
                map.put(name, val);
            }
            catch (NumberFormatException nfe) {
                System.err.println("NumberFormatException: " + nfe.getMessage());
            }
        }
        return map;
    }

    public final Map<String, Integer> getPriceList() {
        return this.priceMap;
    }
}

