/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import forge.card.CardEdition;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.data.QuestAchievements;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gamemodes.quest.data.QuestData;
import forge.gamemodes.quest.data.QuestEventDraftContainer;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.item.BoosterBox;
import forge.item.BoosterPack;
import forge.item.FatPack;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.item.PreconDeck;
import forge.item.SealedProduct;
import forge.item.TournamentPack;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.FileUtil;
import forge.util.IgnoringXStream;
import forge.util.ItemPool;
import forge.util.XmlUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class QuestDataIO {
    protected static XStream getSerializer(boolean isIgnoring) {
        XStream xStream = isIgnoring ? new IgnoringXStream() : new XStream();
        xStream.addPermission(NoTypePermission.NONE);
        xStream.addPermission(NullPermission.NULL);
        xStream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xStream.allowTypeHierarchy(String.class);
        xStream.allowTypeHierarchy(QuestData.class);
        xStream.allowTypeHierarchy(HashMap.class);
        xStream.allowTypeHierarchy(Deck.class);
        xStream.allowTypeHierarchy(DeckGroup.class);
        xStream.allowTypeHierarchy(EnumMap.class);
        xStream.allowTypeHierarchy(QuestItemType.class);
        xStream.allowTypesByWildcard(new String[]{QuestDataIO.class.getPackage().getName() + ".*", "forge.gamemodes.quest.data.*"});
        xStream.registerConverter(new ItemPoolToXml());
        xStream.registerConverter(new DeckToXml());
        xStream.registerConverter(new DraftTournamentToXml());
        xStream.registerConverter(new GameFormatQuestToXml());
        xStream.registerConverter(new QuestModeToXml());
        xStream.autodetectAnnotations(true);
        xStream.alias("CardPool", ItemPool.class);
        xStream.alias("DeckSection", CardPool.class);
        xStream.aliasPackage("forge.quest", "forge.gamemodes.quest");
        xStream.alias("forge.quest.data.item.QuestItemType", QuestItemType.class);
        return xStream;
    }

    public static QuestData loadData(File xmlSaveFile) throws IOException {
        QuestData data;
        StringBuilder xml = new StringBuilder();
        try (GZIPInputStream zin = new GZIPInputStream(Files.newInputStream(xmlSaveFile.toPath(), new OpenOption[0]));
             InputStreamReader reader = new InputStreamReader(zin);){
            char[] buf = new char[1024];
            while (reader.ready()) {
                int len = reader.read(buf);
                if (len == -1) {
                    break;
                }
                xml.append(buf, 0, len);
            }
        }
        String bigXML = xml.toString();
        try {
            data = (QuestData)QuestDataIO.getSerializer(true).fromXML(bigXML);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (data.getVersionNumber() != 13) {
            try {
                QuestDataIO.updateSaveFile(data, bigXML, xmlSaveFile.getName().replace(".dat", ""));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return data;
    }

    private static <T> void setFinalField(Class<T> clasz, String fieldName, T instance, Object newValue) throws IllegalAccessException, NoSuchFieldException {
        Field field = clasz.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(instance, newValue);
    }

    private static void updateSaveFile(QuestData newData, String input, String filename) throws ParserConfigurationException, SAXException, IOException, IllegalAccessException, NoSuchFieldException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(input));
        Document document = builder.parse(is);
        int saveVersion = newData.getVersionNumber();
        if (saveVersion < 3) {
            QuestDataIO.setFinalField(QuestData.class, "assets", newData, new QuestAssets(null));
            int diffIdx = Integer.parseInt(document.getElementsByTagName("diffIndex").item(0).getTextContent());
            QuestDataIO.setFinalField(QuestData.class, "achievements", newData, new QuestAchievements(diffIdx));
        }
        if (saveVersion < 4) {
            QuestDataIO.setFinalField(QuestAssets.class, "inventoryItems", newData.getAssets(), new EnumMap(QuestItemType.class));
        }
        if (saveVersion < 5) {
            QuestDataIO.setFinalField(QuestAssets.class, "combatPets", newData.getAssets(), new HashMap());
        }
        if (saveVersion < 6) {
            QuestDataIO.setFinalField(QuestData.class, "petSlots", newData, new HashMap());
        }
        if (saveVersion < 8) {
            // empty if block
        }
        if (saveVersion < 10) {
            QuestDataIO.setFinalField(QuestData.class, "matchLength", newData, 3);
        }
        if (saveVersion < 11) {
            QuestDataIO.setFinalField(QuestData.class, "Ratings", newData, new HashSet());
            newData.Ratings.clear();
        }
        if (saveVersion < 12) {
            QuestDataIO.setFinalField(QuestData.class, "currentDeck", newData, FModel.getQuestPreferences().getPref(QuestPreferences.QPref.CURRENT_DECK));
        }
        if (saveVersion < 13) {
            QuestDataIO.setFinalField(QuestData.class, "deckConstructionRules", newData, (Object)DeckConstructionRules.Default);
        }
        if (saveVersion < 14) {
            // empty if block
        }
        QuestAssets qS = newData.getAssets();
        QuestAchievements qA = newData.getAchievements();
        switch (saveVersion) {
            case 0: {
                QuestDataIO.setFinalField(QuestAssets.class, "inventoryItems", newData.getAssets(), new EnumMap(QuestItemType.class));
                qS.setItemLevel(QuestItemType.ESTATES, Integer.parseInt(document.getElementsByTagName("estatesLevel").item(0).getTextContent()));
                qS.setItemLevel(QuestItemType.LUCKY_COIN, Integer.parseInt(document.getElementsByTagName("luckyCoinLevel").item(0).getTextContent()));
                qS.setItemLevel(QuestItemType.SLEIGHT, Integer.parseInt(document.getElementsByTagName("sleightOfHandLevel").item(0).getTextContent()));
                int gearLevel = Integer.parseInt(document.getElementsByTagName("gearLevel").item(0).getTextContent());
                if (gearLevel >= 1) {
                    newData.getAssets().setItemLevel(QuestItemType.MAP, 1);
                }
                if (gearLevel == 2) {
                    newData.getAssets().setItemLevel(QuestItemType.ZEPPELIN, 1);
                }
            }
            case 1: 
            case 2: {
                if (StringUtils.isBlank(newData.getName())) {
                    QuestDataIO.setFinalField(QuestData.class, "name", newData, filename);
                }
                QuestDataIO.setFinalField(QuestAchievements.class, "win", qA, Integer.parseInt(document.getElementsByTagName("win").item(0).getTextContent()));
                QuestDataIO.setFinalField(QuestAchievements.class, "lost", qA, Integer.parseInt(document.getElementsByTagName("lost").item(0).getTextContent()));
                Node nw = document.getElementsByTagName("winstreakBest").item(0);
                if (nw != null) {
                    QuestDataIO.setFinalField(QuestAchievements.class, "winstreakBest", qA, Integer.parseInt(nw.getTextContent()));
                }
                if ((nw = document.getElementsByTagName("winstreakCurrent").item(0)) != null) {
                    QuestDataIO.setFinalField(QuestAchievements.class, "winstreakCurrent", qA, Integer.parseInt(nw.getTextContent()));
                }
                QuestDataIO.setFinalField(QuestAchievements.class, "challengesPlayed", qA, Integer.parseInt(document.getElementsByTagName("challengesPlayed").item(0).getTextContent()));
                ArrayList<Integer> completedChallenges = new ArrayList<Integer>();
                QuestDataIO.setFinalField(QuestAchievements.class, "completedChallenges", qA, completedChallenges);
                nw = document.getElementsByTagName("completedChallenges").item(0);
                if (nw != null) {
                    NodeList ccs = nw.getChildNodes();
                    for (int iN = 0; iN < ccs.getLength(); ++iN) {
                        Node n0 = ccs.item(iN);
                        if (n0.getNodeType() != 1) continue;
                        completedChallenges.add(Integer.parseInt(n0.getTextContent()));
                    }
                }
                XStream xs = QuestDataIO.getSerializer(true);
                QuestDataIO.setFinalField(QuestAssets.class, "credits", qS, Integer.parseInt(document.getElementsByTagName("credits").item(0).getTextContent()));
                QuestDataIO.setFinalField(QuestAssets.class, "cardPool", qS, QuestDataIO.readAsset(xs, document, "cardPool", ItemPool.class));
                QuestDataIO.setFinalField(QuestAssets.class, "myDecks", qS, QuestDataIO.readAsset(xs, document, "myDecks", HashMap.class));
                QuestDataIO.setFinalField(QuestAssets.class, "shopList", qS, QuestDataIO.readAsset(xs, document, "shopList", ItemPool.class));
                QuestDataIO.setFinalField(QuestAssets.class, "newCardList", qS, QuestDataIO.readAsset(xs, document, "newCardList", ItemPool.class));
            }
            case 3: {
                String name;
                Node oldInventory;
                Node node = oldInventory = saveVersion > 0 ? document.getElementsByTagName("inventory").item(1) : null;
                if (null != oldInventory) {
                    for (int iN = 0; iN < oldInventory.getChildNodes().getLength(); ++iN) {
                        Node _n = oldInventory.getChildNodes().item(iN);
                        if (_n.getNodeType() != 1) continue;
                        Element n = (Element)_n;
                        name = n.getElementsByTagName("string").item(0).getTextContent();
                        QuestItemType qType = QuestItemType.valueFromSaveKey(name);
                        int level = 0;
                        for (int iX = 0; iX < n.getChildNodes().getLength(); ++iX) {
                            String sLevel;
                            Element x;
                            Node _x = n.getChildNodes().item(iX);
                            if (_x.getNodeType() != 1 || !(x = (Element)_x).getTagName().startsWith("forge.gamemodes.quest.data.") || !StringUtils.isNotBlank(sLevel = x.getElementsByTagName("level").item(0).getTextContent())) continue;
                            level = Integer.parseInt(sLevel);
                        }
                        qS.setItemLevel(qType, level);
                    }
                }
            }
            case 4: {
                String name;
                if (saveVersion > 0) {
                    NodeList pets = document.getElementsByTagName("pets").item(0).getChildNodes();
                    for (int i = 0; i < pets.getLength(); ++i) {
                        if (pets.item(i).getNodeType() != 1) continue;
                        Element entry = (Element)pets.item(i);
                        name = entry.getElementsByTagName("string").item(0).getTextContent();
                        String sLevel = entry.getElementsByTagName("level").item(0).getTextContent();
                        qS.setPetLevel(name, Integer.parseInt(sLevel));
                    }
                }
            }
            case 5: 
            case 6: {
                int i;
                for (i = qA.getLockedChallenges().size() - 1; i >= 0; --i) {
                    String lc = qA.getLockedChallenges().get(i);
                    if (lc == null) continue;
                    qA.getLockedChallenges().set(i, lc.toString());
                }
                for (i = qA.getCurrentChallenges().size() - 1; i >= 0; --i) {
                    String lc = qA.getCurrentChallenges().get(i);
                    if (lc == null) continue;
                    qA.getCurrentChallenges().set(i, lc.toString());
                }
            }
            case 7: 
            case 8: {
                QuestDataIO.setFinalField(QuestAssets.class, "draftDecks", qS, new HashMap());
            }
        }
        newData.setVersionNumber(13);
    }

    private static <T> T readAsset(XStream xs, Document doc, String tagName, Class<T> clasz) {
        NodeList nn = doc.getElementsByTagName(tagName);
        Node n = nn.item(0);
        Attr att = doc.createAttribute("resolves-to");
        att.setValue(clasz.getCanonicalName());
        n.getAttributes().setNamedItem(att);
        String xmlData = XmlUtil.nodeToString(n);
        return (T)xs.fromXML(xmlData);
    }

    public static synchronized void saveData(QuestData qd) {
        try {
            XStream xStream = QuestDataIO.getSerializer(false);
            File f = new File(ForgeConstants.QUEST_SAVE_DIR, qd.getName());
            FileUtil.copyFile(f + ".dat", f + ".dat.bak");
            QuestDataIO.savePacked(f + ".dat", xStream, qd);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void savePacked(String f, XStream xStream, QuestData qd) throws IOException {
        try (BufferedOutputStream bout = new BufferedOutputStream(Files.newOutputStream(Paths.get(f, new String[0]), new OpenOption[0]));
             GZIPOutputStream zout = new GZIPOutputStream(bout);){
            xStream.toXML((Object)qd, zout);
            zout.flush();
        }
    }

    private static void saveUnpacked(String f, XStream xStream, QuestData qd) throws IOException {
        try (BufferedOutputStream boutUnp = new BufferedOutputStream(Files.newOutputStream(Paths.get(f, new String[0]), new OpenOption[0]));){
            xStream.toXML((Object)qd, boutUnp);
            boutUnp.flush();
        }
    }

    static {
        FileUtil.ensureDirectoryExists(ForgeConstants.QUEST_SAVE_DIR);
    }

    public static class ItemPoolToXml
    implements Converter {
        @Override
        public boolean canConvert(Class clasz) {
            return clasz.equals(ItemPool.class);
        }

        protected void write(PaperCard cref, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("card");
            writer.addAttribute("c", cref.getName());
            writer.addAttribute("s", cref.getEdition());
            if (cref.isFoil()) {
                writer.addAttribute("foil", "1");
            }
            writer.addAttribute("i", Integer.toString(cref.getArtIndex()));
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        protected void write(BoosterPack booster, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("booster");
            if (booster.getEdition().equals("?")) {
                writer.addAttribute("s", booster.getName().substring(0, booster.getName().indexOf(booster.getItemType()) - 1));
            } else {
                writer.addAttribute("s", booster.getEdition());
            }
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        protected void write(FatPack fatpack, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("fpack");
            writer.addAttribute("s", fatpack.getEdition());
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        protected void write(BoosterBox boosterbox, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("bbox");
            writer.addAttribute("s", boosterbox.getEdition());
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        protected void write(TournamentPack booster, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("tpack");
            writer.addAttribute("s", booster.getEdition());
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        protected void write(PreconDeck deck, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("precon");
            writer.addAttribute("name", deck.getName());
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            ItemPool pool = (ItemPool)source;
            for (Map.Entry e : pool) {
                InventoryItem item = (InventoryItem)e.getKey();
                Integer count = e.getValue();
                if (item instanceof PaperCard) {
                    this.write((PaperCard)item, count, writer);
                    continue;
                }
                if (item instanceof BoosterPack) {
                    this.write((BoosterPack)item, count, writer);
                    continue;
                }
                if (item instanceof TournamentPack) {
                    this.write((TournamentPack)item, count, writer);
                    continue;
                }
                if (item instanceof FatPack) {
                    this.write((FatPack)item, count, writer);
                    continue;
                }
                if (item instanceof BoosterBox) {
                    this.write((BoosterBox)item, count, writer);
                    continue;
                }
                if (!(item instanceof PreconDeck)) continue;
                this.write((PreconDeck)item, count, writer);
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            ItemPool<InventoryItem> result = new ItemPool<InventoryItem>(InventoryItem.class);
            while (reader.hasMoreChildren()) {
                PreconDeck toAdd;
                reader.moveDown();
                String sCnt = reader.getAttribute("n");
                int cnt = StringUtils.isNumeric(sCnt) ? Integer.parseInt(sCnt) : 1;
                String nodename = reader.getNodeName();
                if ("string".equals(nodename)) {
                    result.add(FModel.getMagicDb().getCommonCards().getCard(reader.getValue()));
                } else if ("card".equals(nodename)) {
                    result.add(this.readCardPrinted(reader), cnt);
                } else if ("booster".equals(nodename)) {
                    result.add(this.readBooster(reader), cnt);
                } else if ("tpack".equals(nodename)) {
                    result.add(this.readTournamentPack(reader), cnt);
                } else if ("fpack".equals(nodename)) {
                    result.add(this.readFatPack(reader), cnt);
                } else if ("bbox".equals(nodename)) {
                    result.add(this.readBoosterBox(reader), cnt);
                } else if ("precon".equals(nodename) && null != (toAdd = this.readPreconDeck(reader))) {
                    result.add(toAdd, cnt);
                }
                reader.moveUp();
            }
            return result;
        }

        protected PreconDeck readPreconDeck(HierarchicalStreamReader reader) {
            String name = reader.getAttribute("name");
            if (name == null) {
                name = reader.getAttribute("s");
            }
            return QuestController.getPrecons().get(name);
        }

        protected BoosterPack readBooster(HierarchicalStreamReader reader) {
            String s2 = reader.getAttribute("s");
            if (SealedProduct.specialSets.contains(s2) || s2.equals("?")) {
                return BoosterPack.fromColor(s2);
            }
            CardEdition ed = FModel.getMagicDb().getEditions().get(s2);
            return BoosterPack.fromSet(ed);
        }

        protected TournamentPack readTournamentPack(HierarchicalStreamReader reader) {
            CardEdition ed = FModel.getMagicDb().getEditions().get(reader.getAttribute("s"));
            return TournamentPack.fromSet(ed);
        }

        protected FatPack readFatPack(HierarchicalStreamReader reader) {
            CardEdition ed = FModel.getMagicDb().getEditions().get(reader.getAttribute("s"));
            return FatPack.fromSet(ed);
        }

        protected BoosterBox readBoosterBox(HierarchicalStreamReader reader) {
            CardEdition ed = FModel.getMagicDb().getEditions().get(reader.getAttribute("s"));
            return BoosterBox.fromSet(ed);
        }

        protected PaperCard readCardPrinted(HierarchicalStreamReader reader) {
            String name = reader.getAttribute("c");
            String set = reader.getAttribute("s");
            String sIndex = reader.getAttribute("i");
            short index = StringUtils.isNumeric(sIndex) ? Short.parseShort(sIndex) : (short)0;
            boolean foil = "1".equals(reader.getAttribute("foil"));
            PaperCard card = FModel.getMagicDb().getOrLoadCommonCard(name, set, index, foil);
            if (null == card) {
                System.err.println("Warning: Unsupported card found in quest save: " + name + " from edition " + set + ". It will be removed from the quest save.");
            }
            return card;
        }
    }

    public static class DeckToXml
    extends ItemPoolToXml {
        @Override
        public boolean canConvert(Class type) {
            return type.equals(Deck.class);
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Deck d = (Deck)source;
            writer.startNode("name");
            writer.setValue(d.getName());
            writer.endNode();
            for (Map.Entry<DeckSection, CardPool> ds : d) {
                writer.startNode(ds.getKey().toString());
                for (Map.Entry e : ds.getValue()) {
                    this.write((PaperCard)e.getKey(), e.getValue(), writer);
                }
                writer.endNode();
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            reader.moveDown();
            String deckName = reader.getValue();
            reader.moveUp();
            Deck result = new Deck(deckName);
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                DeckSection section = DeckSection.smartValueOf(reader.getNodeName());
                if (null == section) {
                    throw new RuntimeException("Quest deck has unknown section: " + reader.getNodeName());
                }
                CardPool pool = result.getOrCreate(section);
                while (reader.hasMoreChildren()) {
                    PaperCard pc;
                    reader.moveDown();
                    String sCnt = reader.getAttribute("n");
                    int cnt = StringUtils.isNumeric(sCnt) ? Integer.parseInt(sCnt) : 1;
                    String nodename = reader.getNodeName();
                    if ("string".equals(nodename)) {
                        pool.add(FModel.getMagicDb().getCommonCards().getCard(reader.getValue()));
                    } else if ("card".equals(nodename) && (pc = this.readCardPrinted(reader)) != null) {
                        pool.add(pc, cnt);
                    }
                    reader.moveUp();
                }
                reader.moveUp();
            }
            return result;
        }
    }

    private static class DraftTournamentToXml
    implements Converter {
        private DraftTournamentToXml() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type.equals(QuestEventDraftContainer.class);
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            QuestEventDraftContainer drafts = (QuestEventDraftContainer)source;
            for (QuestEventDraft draft : drafts) {
                int i;
                writer.startNode("draft");
                writer.startNode("title");
                writer.setValue(draft.getTitle());
                writer.endNode();
                writer.startNode("packs");
                StringBuilder output = new StringBuilder();
                for (i = 0; i < draft.getBoosterConfiguration().length; ++i) {
                    output.append(draft.getBoosterConfiguration()[i]);
                    if (i == draft.getBoosterConfiguration().length - 1) continue;
                    output.append("/");
                }
                writer.setValue(output.toString());
                writer.endNode();
                writer.startNode("entryFee");
                writer.setValue(String.valueOf(draft.getEntryFee()));
                writer.endNode();
                writer.startNode("block");
                writer.setValue(draft.getBlock());
                writer.endNode();
                writer.startNode("standings");
                i = 0;
                for (String standing : draft.getStandings()) {
                    writer.startNode("s" + i++);
                    writer.setValue(standing);
                    writer.endNode();
                }
                writer.endNode();
                writer.startNode("aiNames");
                i = 0;
                for (String name : draft.getAINames()) {
                    writer.startNode("ain" + i++);
                    writer.setValue(name);
                    writer.endNode();
                }
                writer.endNode();
                writer.startNode("aiIcons");
                i = 0;
                for (int icon : draft.getAIIcons()) {
                    writer.startNode("aii" + i++);
                    writer.setValue(icon + "");
                    writer.endNode();
                }
                writer.endNode();
                writer.startNode("started");
                writer.setValue("" + draft.isStarted());
                writer.endNode();
                writer.startNode("age");
                writer.setValue("" + draft.getAge());
                writer.endNode();
                writer.endNode();
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            QuestEventDraftContainer output = new QuestEventDraftContainer();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String draftName = null;
                String boosterConfiguration = null;
                int entryFee = 1500;
                int age = 15;
                String block = null;
                String[] standings = null;
                String[] aiNames = new String[7];
                int[] aiIcons = new int[7];
                boolean started = false;
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    switch (reader.getNodeName()) {
                        case "title": {
                            draftName = reader.getValue();
                            break;
                        }
                        case "packs": {
                            boosterConfiguration = reader.getValue();
                            break;
                        }
                        case "entryFee": {
                            entryFee = Integer.parseInt(reader.getValue());
                            break;
                        }
                        case "block": {
                            block = reader.getValue();
                            break;
                        }
                        case "standings": {
                            standings = new String[15];
                            int i = 0;
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                standings[i++] = reader.getValue();
                                reader.moveUp();
                            }
                            break;
                        }
                        case "bracket": {
                            break;
                        }
                        case "aiNames": {
                            int ii = 0;
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                aiNames[ii++] = reader.getValue();
                                reader.moveUp();
                            }
                            break;
                        }
                        case "aiIcons": {
                            int iii = 0;
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                aiIcons[iii++] = Integer.parseInt(reader.getValue());
                                reader.moveUp();
                            }
                            break;
                        }
                        case "started": {
                            started = Boolean.parseBoolean(reader.getValue());
                            break;
                        }
                        case "age": {
                            age = Integer.parseInt(reader.getValue());
                        }
                    }
                    reader.moveUp();
                }
                QuestEventDraft draft = new QuestEventDraft(draftName);
                draft.setBoosterConfiguration(boosterConfiguration);
                draft.setEntryFee(entryFee);
                draft.setBlock(block);
                draft.setStandings(standings);
                if (standings != null) {
                    draft.setBracket(QuestEventDraft.createBracketFromStandings(standings, aiNames, aiIcons));
                }
                draft.setAINames(aiNames);
                draft.setAIIcons(aiIcons);
                draft.setStarted(started);
                draft.setAge(age);
                output.add(draft);
                reader.moveUp();
            }
            return output;
        }
    }

    private static class QuestModeToXml
    implements Converter {
        private QuestModeToXml() {
        }

        @Override
        public boolean canConvert(Class clasz) {
            return clasz.equals(QuestMode.class);
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            QuestMode mode = (QuestMode)((Object)source);
            String sMode = mode.toString();
            writer.setValue(sMode);
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String value = reader.getValue();
            return QuestMode.smartValueOf(value, QuestMode.Classic);
        }
    }

    private static class GameFormatQuestToXml
    implements Converter {
        private GameFormatQuestToXml() {
        }

        @Override
        public boolean canConvert(Class clasz) {
            return clasz.equals(GameFormatQuest.class);
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.startNode("format");
            GameFormatQuest format = (GameFormatQuest)source;
            writer.addAttribute("name", format.getName());
            writer.addAttribute("unlocksUsed", Integer.toString(format.getUnlocksUsed()));
            writer.addAttribute("canUnlock", format.canUnlockSets() ? "1" : "0");
            writer.endNode();
            for (String set : format.getAllowedSetCodes()) {
                writer.startNode("set");
                writer.addAttribute("s", set);
                writer.endNode();
            }
            for (String ban : format.getBannedCardNames()) {
                writer.startNode("ban");
                writer.addAttribute("s", ban);
                writer.endNode();
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            reader.moveDown();
            String name = reader.getAttribute("name");
            String unlocksUsed = reader.getAttribute("unlocksUsed");
            boolean canUnlock = !"0".equals(reader.getAttribute("canUnlock"));
            ArrayList<String> allowedSets = new ArrayList<String>();
            ArrayList<String> bannedCards = new ArrayList<String>();
            reader.moveUp();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String nodename = reader.getNodeName();
                if (nodename.equals("ban")) {
                    bannedCards.add(reader.getAttribute("s"));
                } else if (nodename.equals("set")) {
                    allowedSets.add(reader.getAttribute("s"));
                }
                reader.moveUp();
            }
            GameFormatQuest res = new GameFormatQuest(name, (List<String>)allowedSets, (List<String>)bannedCards);
            try {
                if (StringUtils.isNotEmpty(unlocksUsed)) {
                    QuestDataIO.setFinalField(GameFormatQuest.class, "unlocksUsed", res, Integer.parseInt(unlocksUsed));
                }
                QuestDataIO.setFinalField(GameFormatQuest.class, "allowUnlocks", res, canUnlock);
            }
            catch (IllegalAccessException | NoSuchFieldException | NumberFormatException e) {
                e.printStackTrace();
            }
            return res;
        }
    }
}

