/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.data;

import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.data.QuestEventDraftContainer;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class QuestAchievements {
    private int challengesPlayed = 0;
    private List<String> completedChallenges = new ArrayList<String>();
    private List<String> currentChallenges = new ArrayList<String>();
    private QuestEventDraftContainer drafts = new QuestEventDraftContainer();
    private int currentDraft = -1;
    private int draftsToGenerate = 1;
    private int draftTokens = 0;
    private int win;
    private int winstreakBest = 0;
    private int winstreakCurrent = 0;
    private int lost;
    private int firstPlaceDraftFinishes = 0;
    private int secondPlaceDraftFinishes = 0;
    private int thirdPlaceDraftFinishes = 0;
    private int fourthPlaceDraftFinishes = 0;
    private int difficulty;
    private transient QuestEventDraft.QuestDraftFormat nextDraftFormat;

    public QuestAchievements() {
    }

    public QuestAchievements(int diff) {
        this.difficulty = diff;
    }

    public void deleteDraft(QuestEventDraft draft) {
        if (this.currentDraft == this.drafts.indexOf(draft)) {
            this.currentDraft = -1;
        }
        this.drafts.remove(draft);
    }

    public void endCurrentTournament(int place) {
        this.drafts.remove(this.drafts.get(this.currentDraft));
        this.currentDraft = -1;
        this.addDraftFinish(place);
        FModel.getQuest().save();
    }

    public void addWin() {
        ++this.win;
        ++this.winstreakCurrent;
        if (this.drafts != null) {
            for (QuestEventDraft questEventDraft : this.drafts) {
                if (this.drafts.indexOf(questEventDraft) == this.currentDraft) continue;
                questEventDraft.addWin();
            }
        }
        if (this.win % FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.WINS_NEW_DRAFT) == 0) {
            ++this.draftsToGenerate;
        }
        if (this.winstreakCurrent > this.winstreakBest) {
            this.winstreakBest = this.winstreakCurrent;
        }
    }

    public int getChallengesPlayed() {
        return this.challengesPlayed;
    }

    public void addChallengesPlayed() {
        ++this.challengesPlayed;
    }

    public List<String> getLockedChallenges() {
        return this.completedChallenges;
    }

    public void addLockedChallenge(String i) {
        this.completedChallenges.add(i);
    }

    public List<String> getCurrentChallenges() {
        if (this.currentChallenges == null) {
            this.currentChallenges = new ArrayList<String>();
        }
        return this.currentChallenges;
    }

    public void setCurrentChallenges(List<String> lst0) {
        this.currentChallenges = lst0;
    }

    public void addLost() {
        ++this.lost;
        this.winstreakCurrent = 0;
    }

    public int getLevel() {
        int winsToLvlUp = FModel.getQuestPreferences().getPrefInt(QuestPreferences.DifficultyPrefs.WINS_RANKUP, this.difficulty);
        return this.win / winsToLvlUp;
    }

    public int getLost() {
        return this.lost;
    }

    public int getWin() {
        return this.win;
    }

    public int getWinStreakBest() {
        return this.winstreakBest;
    }

    public int getWinStreakCurrent() {
        return this.winstreakCurrent;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public QuestEventDraftContainer getDraftEvents() {
        return this.drafts;
    }

    public void generateDrafts() {
        if (this.drafts == null) {
            this.drafts = new QuestEventDraftContainer();
            this.draftsToGenerate = 1;
        }
        HashSet<QuestEventDraft> toRemove = new HashSet<QuestEventDraft>();
        for (QuestEventDraft draft : this.drafts) {
            if (draft.getAge() > 0 || this.currentDraft != -1 && this.drafts.get(this.currentDraft) == draft) continue;
            toRemove.add(draft);
            if (FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.DRAFT_ROTATION) == 0) break;
            ++this.draftsToGenerate;
            break;
        }
        if (!toRemove.isEmpty()) {
            this.drafts.removeAll(toRemove);
        }
        for (int i = 0; i < this.draftsToGenerate; ++i) {
            QuestEventDraft draft;
            if (this.nextDraftFormat != null) {
                draft = QuestEventDraft.getDraftOrNull(FModel.getQuest(), this.nextDraftFormat);
                this.nextDraftFormat = null;
            } else {
                draft = QuestEventDraft.getRandomDraftOrNull(FModel.getQuest());
            }
            if (draft == null) continue;
            this.drafts.add(draft);
            --this.draftsToGenerate;
        }
        FModel.getQuest().save();
    }

    public void addDraftToken() {
        ++this.draftTokens;
    }

    public void setCurrentDraft(QuestEventDraft draft) {
        this.currentDraft = this.drafts.indexOf(draft);
    }

    public QuestEventDraft getCurrentDraft() {
        if (this.drafts == null || this.drafts.isEmpty()) {
            return null;
        }
        if (this.currentDraft > this.drafts.size() - 1) {
            this.currentDraft = -1;
            FModel.getQuest().getDraftDecks().delete("Tournament Deck");
            return null;
        }
        try {
            return (QuestEventDraft)this.drafts.get(this.currentDraft);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getCurrentDraftIndex() {
        return this.currentDraft;
    }

    public int getWinsForPlace(int place) {
        switch (place) {
            case 1: {
                return this.firstPlaceDraftFinishes;
            }
            case 2: {
                return this.secondPlaceDraftFinishes;
            }
            case 3: {
                return this.thirdPlaceDraftFinishes;
            }
            case 4: {
                return this.fourthPlaceDraftFinishes;
            }
        }
        return 0;
    }

    private void addDraftFinish(int place) {
        switch (place) {
            case 1: {
                ++this.firstPlaceDraftFinishes;
                break;
            }
            case 2: {
                ++this.secondPlaceDraftFinishes;
                break;
            }
            case 3: {
                ++this.thirdPlaceDraftFinishes;
                break;
            }
            case 4: {
                ++this.fourthPlaceDraftFinishes;
            }
        }
    }

    public int getDraftTokens() {
        return this.draftTokens;
    }

    public void spendDraftToken(QuestEventDraft.QuestDraftFormat format) {
        if (this.draftTokens > 0) {
            --this.draftTokens;
            ++this.draftsToGenerate;
            this.nextDraftFormat = format;
            this.generateDrafts();
        }
    }
}

