/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.bazaar;

import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import forge.gamemodes.quest.bazaar.QuestPetController;
import forge.gamemodes.quest.data.QuestAssets;
import forge.util.IgnoringXStream;
import forge.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QuestPetStorage {
    private Map<Integer, List<QuestPetController>> petsBySlot = new HashMap<Integer, List<QuestPetController>>();
    private Map<String, QuestPetController> petsByName = new HashMap<String, QuestPetController>();

    public QuestPetStorage(File file) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(file);
            IgnoringXStream xs = new IgnoringXStream();
            xs.addPermission(NoTypePermission.NONE);
            xs.addPermission(NullPermission.NULL);
            xs.addPermission(PrimitiveTypePermission.PRIMITIVES);
            xs.allowTypeHierarchy(String.class);
            xs.allowTypesByWildcard(new String[]{QuestPetStorage.class.getPackage().getName() + ".*"});
            xs.autodetectAnnotations(true);
            NodeList xmlPets = document.getElementsByTagName("pets").item(0).getChildNodes();
            for (int iN = 0; iN < xmlPets.getLength(); ++iN) {
                Node n = xmlPets.item(iN);
                if (n.getNodeType() != 1) continue;
                Attr att = document.createAttribute("resolves-to");
                att.setValue(QuestPetController.class.getCanonicalName());
                n.getAttributes().setNamedItem(att);
                String sXml = XmlUtil.nodeToString(n);
                QuestPetController petCtrl = (QuestPetController)xs.fromXML(sXml);
                this.addToMap(petCtrl);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    private void addToMap(QuestPetController petCtrl) {
        int iSlot = petCtrl.getSlot();
        List list = this.petsBySlot.computeIfAbsent(iSlot, k -> new ArrayList());
        this.petsByName.put(petCtrl.getName(), petCtrl);
        list.add(petCtrl);
    }

    public QuestPetController getPet(String petName) {
        return this.petsByName.get(petName);
    }

    public List<QuestPetController> getAvaliablePets(int iSlot, QuestAssets qA) {
        ArrayList<QuestPetController> result = new ArrayList<QuestPetController>();
        List<QuestPetController> allPossible = this.petsBySlot.get(iSlot);
        if (null != allPossible) {
            for (QuestPetController c : allPossible) {
                if (qA.getPetLevel(c.getSaveFileKey()) <= 0) continue;
                result.add(c);
            }
        }
        return result;
    }

    public List<QuestPetController> getAllPets(int iSlot) {
        ArrayList<QuestPetController> result = new ArrayList<QuestPetController>();
        List<QuestPetController> allPossible = this.petsBySlot.get(iSlot);
        if (null != allPossible) {
            result.addAll(allPossible);
        }
        return result;
    }
}

