/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.gamemodes.quest.data.QuestAchievements;
import forge.util.FileSection;
import java.util.List;

public class SellRules {
    private int minWins = 0;
    private int cost = 250;
    private int minDifficulty = 0;
    private int maxDifficulty = 5;

    public SellRules(List<String> questShop) {
        if (null == questShop || questShop.isEmpty()) {
            return;
        }
        FileSection section = FileSection.parse(questShop, FileSection.EQUALS_KV_SEPARATOR);
        this.minWins = section.getInt("WinsToUnlock");
        this.cost = section.getInt("Credits", 250);
        this.maxDifficulty = section.getInt("MaxDifficulty", 5);
        this.minDifficulty = section.getInt("MinDifficulty", 0);
    }

    public boolean meetsRequiremnts(QuestAchievements quest) {
        if (quest.getWin() < this.minWins) {
            return false;
        }
        return quest.getDifficulty() >= this.minDifficulty && quest.getDifficulty() <= this.maxDifficulty;
    }

    public final int getCost() {
        return this.cost;
    }

    public final int getMinWins() {
        return this.minWins;
    }
}

