/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.LobbyPlayer;
import forge.card.CardEdition;
import forge.game.GameEndReason;
import forge.game.GameFormat;
import forge.game.GameOutcome;
import forge.game.GameView;
import forge.game.player.GameLossReason;
import forge.game.player.PlayerOutcome;
import forge.game.player.PlayerStatistics;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.quest.BoosterUtils;
import forge.gamemodes.quest.IQuestRewardCard;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventChallenge;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.GuiBase;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IWinLoseView;
import forge.gui.util.SGuiChoose;
import forge.item.BoosterPack;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.item.SealedProduct;
import forge.item.SealedTemplate;
import forge.item.TournamentPack;
import forge.item.generation.UnOpenedProduct;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class QuestWinLoseController {
    private final GameView lastGame;
    private final IWinLoseView<? extends IButton> view;
    private final transient boolean wonMatch;
    private final transient boolean isAnte;
    private final transient QuestController qData;
    private final transient QuestEvent qEvent;

    public QuestWinLoseController(GameView game0, IWinLoseView<? extends IButton> view0) {
        this.lastGame = game0;
        this.view = view0;
        this.qData = FModel.getQuest();
        this.qEvent = this.qData.getCurrentEvent();
        this.wonMatch = this.lastGame.isMatchWonBy(GamePlayerUtil.getQuestPlayer());
        this.isAnte = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ANTE);
    }

    public void showRewards() {
        boolean matchIsNotOver;
        this.view.getBtnRestart().setVisible(false);
        QuestController qc = FModel.getQuest();
        if (this.lastGame.getNumPlayedGamesInMatch() == 0) {
            try {
                qc.getCards().clearShopList();
                qc.getCards().getShopList();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        LobbyPlayer questLobbyPlayer = GamePlayerUtil.getQuestPlayer();
        PlayerView player = null;
        for (PlayerView p : this.lastGame.getPlayers()) {
            if (!p.isLobbyPlayer(questLobbyPlayer)) continue;
            player = p;
        }
        PlayerView questPlayer = player;
        boolean bl = matchIsNotOver = !this.lastGame.isMatchOver();
        if (matchIsNotOver) {
            this.view.getBtnQuit().setText(Localizer.getInstance().getMessage("lblQuitByPayCredits", new Object[0]));
        } else {
            this.view.getBtnContinue().setVisible(false);
            if (this.wonMatch) {
                this.view.getBtnQuit().setText(Localizer.getInstance().getMessage("lblGreat", new Object[0]) + "!");
            } else {
                this.view.getBtnQuit().setText(Localizer.getInstance().getMessage("lblOK", new Object[0]));
            }
        }
        this.view.showRewards(() -> {
            GameOutcome.AnteResult anteResult;
            if (this.isAnte && (anteResult = this.lastGame.getAnteResult(questPlayer)) != null) {
                if (anteResult.wonCards != null) {
                    qc.getCards().addAllCards(anteResult.wonCards);
                }
                if (anteResult.lostCards != null) {
                    qc.getCards().loseCards(anteResult.lostCards);
                }
                this.anteReport(anteResult.wonCards, anteResult.lostCards);
            }
            if (matchIsNotOver) {
                return;
            }
            int difficulty = this.qData.getAchievements().getDifficulty();
            int wins = this.qData.getAchievements().getWin();
            if (this.wonMatch) {
                this.awardEventCredits();
                if (this.qEvent instanceof QuestEventChallenge) {
                    this.awardChallengeWin();
                } else {
                    this.awardSpecialReward("Special bonus reward");
                    if (this.qEvent.getDifficulty() == QuestEventDifficulty.EXPERT) {
                        this.awardRandomRare("You've won a random rare for winning against a very hard deck.");
                    }
                }
                this.awardWinStreakBonus();
                if (this.getLuckyCoinResult()) {
                    this.awardRandomRare("You've won a random rare.");
                }
                if (wins > 0 && (wins + 1) % 80 == 0) {
                    this.awardJackpot();
                }
            } else {
                this.penalizeLoss();
            }
            if (this.wonMatch || difficulty == 0) {
                int outcome = this.wonMatch ? wins : this.qData.getAchievements().getLost();
                int winsPerBooster = FModel.getQuestPreferences().getPrefInt(QuestPreferences.DifficultyPrefs.WINS_BOOSTER, this.qData.getAchievements().getDifficulty());
                if (winsPerBooster > 0 && (outcome + 1) % winsPerBooster == 0) {
                    this.awardBooster();
                }
            }
        });
    }

    private void anteReport(List<PaperCard> cardsWon, List<PaperCard> cardsLost) {
        if (cardsWon != null && !cardsWon.isEmpty()) {
            this.view.showCards(Localizer.getInstance().getMessage("lblSpoilsWonAnteCard", new Object[0]), cardsWon);
        }
        if (cardsLost != null && !cardsLost.isEmpty()) {
            this.view.showCards(Localizer.getInstance().getMessage("lblLootedLostAnteCard", new Object[0]), cardsLost);
        }
    }

    public void actionOnQuit() {
        int x = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.PENALTY_LOSS);
        if (this.wonMatch) {
            this.qData.getAchievements().addWin();
        } else {
            this.qData.getAchievements().addLost();
            this.qData.getAssets().subtractCredits(x);
        }
        if (this.qData.getAssets().hasItem(QuestItemType.ZEPPELIN)) {
            this.qData.getAssets().setItemLevel(QuestItemType.ZEPPELIN, 1);
        }
        if (this.qEvent instanceof QuestEventChallenge && (this.wonMatch || !((QuestEventChallenge)this.qEvent).isPersistent())) {
            String id = ((QuestEventChallenge)this.qEvent).getId();
            this.qData.getAchievements().getCurrentChallenges().remove(id);
            this.qData.getAchievements().addLockedChallenge(id);
            this.qData.getAchievements().addChallengesPlayed();
        }
        this.qData.setCurrentEvent(null);
        this.qData.save();
        FModel.getQuestPreferences().save();
    }

    private void awardEventCredits() {
        StringBuilder sb = new StringBuilder();
        int credGameplay = 0;
        int credUndefeated = 0;
        int base = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_BASE);
        double multiplier = this.qEvent.getDifficulty().getMultiplier();
        int credBase = (int)((double)base * multiplier);
        sb.append(StringUtils.capitalize(this.qEvent.getDifficulty().getTitle()));
        sb.append(" opponent: ").append(credBase).append(" credits.\n");
        if (this.qEvent.getIsRandomMatch()) {
            sb.append("Random Opponent Bonus: ").append(credBase).append(" credit").append(credBase > 1 ? "s." : ".").append("\n");
            credBase += credBase;
        }
        int winMultiplier = Math.min(this.qData.getAchievements().getWin(), FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_WINS_MULTIPLIER_MAX));
        int creditsForPreviousWins = (int)(Double.parseDouble(FModel.getQuestPreferences().getPref(QuestPreferences.QPref.REWARDS_WINS_MULTIPLIER)) * (double)winMultiplier);
        credBase += creditsForPreviousWins;
        sb.append("Bonus for previous wins: ").append(creditsForPreviousWins).append(creditsForPreviousWins != 1 ? " credits.\n" : " credit.\n");
        boolean hasNeverLost = true;
        int lifeDifferenceCredits = 0;
        LobbyPlayer localHuman = GamePlayerUtil.getQuestPlayer();
        for (GameOutcome game : this.lastGame.getOutcomesOfMatch()) {
            if (!game.isWinner(localHuman)) {
                hasNeverLost = false;
                continue;
            }
            PlayerStatistics humanRating = null;
            for (Map.Entry<RegisteredPlayer, PlayerStatistics> kvRating : game) {
                if (kvRating.getKey().getPlayer().equals(localHuman)) {
                    humanRating = kvRating.getValue();
                    continue;
                }
                PlayerOutcome outcome = kvRating.getValue().getOutcome();
                GameLossReason whyAiLost = outcome.lossState;
                int altReward = QuestWinLoseController.getCreditsRewardForAltWin(whyAiLost);
                String winConditionName = "Unknown (bug)";
                if (game.getWinCondition() == GameEndReason.WinsGameSpellEffect) {
                    winConditionName = game.getWinSpellEffect();
                    altReward = QuestWinLoseController.getCreditsRewardForAltWin(null);
                } else {
                    switch (whyAiLost) {
                        case Poisoned: {
                            winConditionName = "Poison";
                            break;
                        }
                        case Milled: {
                            winConditionName = "Milled";
                            break;
                        }
                        case SpellEffect: {
                            winConditionName = outcome.loseConditionSpell;
                            break;
                        }
                    }
                }
                if (altReward <= 0) continue;
                credGameplay += altReward;
                sb.append(GuiBase.getInterface().isLibgdxPort() ? TextUtil.concatNoSpace("Alternate win condition: ", winConditionName, "! Bonus: ", String.valueOf(altReward), " credits.\n") : TextUtil.concatNoSpace("Alternate win condition: <u>", winConditionName, "</u>! Bonus: ", String.valueOf(altReward), " credits.\n"));
            }
            int cntCardsHumanStartedWith = humanRating.getOpeningHandSize();
            int mulliganReward = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_MULLIGAN0);
            if (0 == cntCardsHumanStartedWith) {
                credGameplay += mulliganReward;
                sb.append(TextUtil.concatNoSpace("Mulliganed to zero and still won! Bonus: ", String.valueOf(mulliganReward), " credits.\n"));
            }
            int winTurn = game.getLastTurnNumber();
            int turnCredits = QuestWinLoseController.getCreditsRewardForWinByTurn(winTurn);
            if (winTurn == 0) {
                sb.append("Won on turn zero!");
            } else if (winTurn == 1) {
                sb.append("Won in one turn!");
            } else if (winTurn <= 5) {
                sb.append("Won by turn 5!");
            } else if (winTurn <= 10) {
                sb.append("Won by turn 10!");
            } else if (winTurn <= 15) {
                sb.append("Won by turn 15!");
            }
            if (turnCredits > 0) {
                credGameplay += turnCredits;
                sb.append(TextUtil.concatNoSpace(" Bonus: ", String.valueOf(turnCredits), " credits.\n"));
            }
            if (game.getLifeDelta() < 50) continue;
            lifeDifferenceCredits += Math.max(Math.min((game.getLifeDelta() - 46) / 4, FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_HEALTH_DIFF_MAX)), 0);
        }
        if (lifeDifferenceCredits > 0) {
            sb.append(TextUtil.concatNoSpace("Life total difference: ", String.valueOf(lifeDifferenceCredits), " credits.\n"));
        }
        if (hasNeverLost) {
            credUndefeated += FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_UNDEFEATED);
            int reward = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_UNDEFEATED);
            sb.append(TextUtil.concatNoSpace("You have not lost once! Bonus: ", String.valueOf(reward), " credits.\n"));
        }
        int credTotal = credBase + credGameplay + credUndefeated + lifeDifferenceCredits;
        double estateValue = 0.0;
        switch (this.qData.getAssets().getItemLevel(QuestItemType.ESTATES)) {
            case 1: {
                estateValue = 0.1;
                break;
            }
            case 2: {
                estateValue = 0.15;
                break;
            }
            case 3: {
                estateValue = 0.2;
                break;
            }
        }
        if (estateValue > 0.0) {
            int credEstates = (int)(estateValue * (double)credTotal);
            sb.append("Estates bonus (").append((int)(100.0 * estateValue)).append("%): ").append(credEstates).append(" credits.\n");
            credTotal += credEstates;
        }
        sb.append("\n");
        if (credTotal < 100) {
            sb.append("You've earned ");
        } else if (credTotal < 250) {
            sb.append("Could be worse: ");
        } else if (credTotal < 500) {
            sb.append("A respectable ");
        } else if (credTotal < 750) {
            sb.append("An impressive ");
        } else {
            sb.append("Spectacular match! ");
        }
        sb.append(TextUtil.concatWithSpace(String.valueOf(credTotal), "credits in total."));
        this.qData.getAssets().addCredits(credTotal);
        this.view.showMessage(sb.toString(), Localizer.getInstance().getMessage("lblGameplayResults", new Object[0]), FSkinProp.ICO_QUEST_GOLD);
    }

    private void awardRandomRare(String message) {
        PaperCard c = this.qData.getCards().addRandomRare();
        ArrayList<PaperCard> cardsWon = new ArrayList<PaperCard>();
        cardsWon.add(c);
        this.view.showCards(message, cardsWon);
    }

    private void awardWinStreakBonus() {
        String typeWon;
        int currentStreak = (this.qData.getAchievements().getWinStreakCurrent() + 1) % 50;
        ArrayList<PaperCard> cardsWon = new ArrayList<PaperCard>();
        boolean addDraftToken = false;
        switch (currentStreak) {
            case 3: {
                cardsWon.addAll(this.qData.getCards().addRandomCommon(1));
                typeWon = "common";
                break;
            }
            case 5: {
                cardsWon.addAll(this.qData.getCards().addRandomUncommon(1));
                typeWon = "uncommon";
                break;
            }
            case 7: {
                cardsWon.addAll(this.qData.getCards().addRandomRareNotMythic(1));
                typeWon = "rare";
                break;
            }
            case 10: {
                List<PaperCard> cardsToAdd = this.qData.getCards().addRandomMythicRare(1);
                if (cardsToAdd != null) {
                    cardsWon.addAll(cardsToAdd);
                    typeWon = "mythic rare";
                    break;
                }
                cardsWon.addAll(this.qData.getCards().addRandomRareNotMythic(3));
                typeWon = "rare";
                break;
            }
            case 25: {
                List<PaperCard> cardsToAdd = this.qData.getCards().addRandomMythicRare(5);
                if (cardsToAdd != null) {
                    cardsWon.addAll(cardsToAdd);
                    typeWon = "mythic rare";
                } else {
                    cardsWon.addAll(this.qData.getCards().addRandomRareNotMythic(15));
                    typeWon = "rare";
                }
                addDraftToken = true;
                break;
            }
            case 0: {
                List<PaperCard> cardsToAdd = this.qData.getCards().addRandomMythicRare(10);
                if (cardsToAdd != null) {
                    cardsWon.addAll(cardsToAdd);
                    typeWon = "mythic rare";
                } else {
                    cardsWon.addAll(this.qData.getCards().addRandomRareNotMythic(30));
                    typeWon = "rare";
                }
                addDraftToken = true;
                break;
            }
            default: {
                return;
            }
        }
        if (addDraftToken) {
            this.view.showMessage(Localizer.getInstance().getMessage("lblAchieving25WinStreakAwarded", new Object[0]), Localizer.getInstance().getMessage("lblBonusDraftTokenReward", new Object[0]), FSkinProp.ICO_QUEST_COIN);
            this.qData.getAchievements().addDraftToken();
        }
        if (!cardsWon.isEmpty()) {
            this.view.showCards(Localizer.getInstance().getMessage("lblAchievedNWinStreakWinMTypeCards", currentStreak == 0 ? "50" : String.valueOf(currentStreak), String.valueOf(cardsWon.size()), typeWon), cardsWon);
        }
    }

    private void awardJackpot() {
        List<PaperCard> cardsWon = this.qData.getCards().addRandomRare(10);
        this.view.showCards(Localizer.getInstance().getMessage("lblJustWonTenRandomRares", new Object[0]), cardsWon);
    }

    private void awardBooster() {
        String title;
        Object cardsWon;
        if (this.qData.getFormat() == null) {
            ArrayList<GameFormat> formats = new ArrayList<GameFormat>();
            String preferredFormat = FModel.getQuestPreferences().getPref(QuestPreferences.QPref.BOOSTER_FORMAT);
            GameFormat pref = null;
            for (GameFormat f : FModel.getFormats().getSanctionedList()) {
                formats.add(f);
                if (!f.toString().equals(preferredFormat)) continue;
                pref = f;
            }
            Collections.sort(formats);
            GameFormat selected = SGuiChoose.getChoices(Localizer.getInstance().getMessage("lblChooseBonusBoosterFormat", new Object[0]), 1, 1, formats, pref, null).get(0);
            FModel.getQuestPreferences().setPref(QuestPreferences.QPref.BOOSTER_FORMAT, selected.toString());
            cardsWon = this.qData.getCards().generateQuestBooster(selected.getFilterPrinted());
            this.qData.getCards().addAllCards((Iterable<PaperCard>)cardsWon);
            title = Localizer.getInstance().getMessage("lblBonusFormatBoosterPack", selected.getName());
        } else {
            ArrayList<String> sets = new ArrayList<String>();
            for (SealedTemplate bd : FModel.getMagicDb().getBoosters()) {
                if (bd == null || !this.qData.getFormat().isSetLegal(bd.getEdition())) continue;
                sets.add(bd.getEdition());
            }
            boolean customBooster = false;
            if (sets.isEmpty()) {
                customBooster = true;
                CardEdition.Collection editions = FModel.getMagicDb().getEditions();
                for (CardEdition edition : editions) {
                    if (!this.qData.getFormat().isSetLegal(edition.getCode())) continue;
                    sets.add(edition.getCode());
                }
            }
            int maxChoices = 1;
            if (this.wonMatch) {
                ++maxChoices;
                int wins = this.qData.getAchievements().getWin();
                if ((wins + 1) % 5 == 0) {
                    ++maxChoices;
                }
                if ((wins + 1) % 20 == 0) {
                    ++maxChoices;
                }
                if ((wins + 1) % 50 == 0) {
                    ++maxChoices;
                }
                maxChoices += this.qData.getAssets().getItemLevel(QuestItemType.MEMBERSHIP_TOKEN);
            }
            ArrayList<CardEdition> options = new ArrayList<CardEdition>();
            while (!sets.isEmpty() && maxChoices > 0) {
                int ix = MyRandom.getRandom().nextInt(sets.size());
                String set = (String)sets.get(ix);
                sets.remove(ix);
                options.add(FModel.getMagicDb().getEditions().get(set));
                --maxChoices;
            }
            CardEdition chooseEd = (CardEdition)SGuiChoose.one(Localizer.getInstance().getMessage("lblChooseBonusBoosterSet", new Object[0]), options);
            if (customBooster) {
                Collection cards = FModel.getMagicDb().getCommonCards().getAllCards((Predicate)IPaperCard.Predicates.printedInSet(chooseEd.getCode()));
                UnOpenedProduct product = new UnOpenedProduct(this.getBoosterTemplate(), cards);
                cardsWon = product.get();
            } else {
                ArrayList<String> boosterTypes = Lists.newArrayList(chooseEd.getAvailableBoosterTypes());
                String setAffix = "";
                String type = SGuiChoose.one("Which booster type do you choose?", boosterTypes);
                if (!type.equals("Draft")) {
                    setAffix = type;
                }
                UnOpenedProduct product = new UnOpenedProduct(FModel.getMagicDb().getBoosters().get(chooseEd.getCode() + setAffix));
                cardsWon = product.get();
            }
            this.qData.getCards().addAllCards((Iterable<PaperCard>)cardsWon);
            title = Localizer.getInstance().getMessage("lblBonusSetBoosterPack", chooseEd.getName());
        }
        if (cardsWon != null) {
            BoosterUtils.sort((List<PaperCard>)cardsWon);
            this.view.showCards(title, (List<PaperCard>)cardsWon);
        }
    }

    private SealedTemplate getBoosterTemplate() {
        return new SealedTemplate(ImmutableList.of(Pair.of("Common", FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.BOOSTER_COMMONS)), Pair.of("Uncommon", FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.BOOSTER_UNCOMMONS)), Pair.of("RareMythic", FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.BOOSTER_RARES))));
    }

    private void awardChallengeWin() {
        long questRewardCredits = ((QuestEventChallenge)this.qEvent).getCreditsReward();
        String winMessage = ((QuestEventChallenge)this.qEvent).getWinMessage();
        if (!winMessage.isEmpty()) {
            this.view.showMessage(winMessage.replace("\\n", "\n"), Localizer.getInstance().getMessage("lblCongratulations", new Object[0]), FSkinProp.ICO_QUEST_NOTES);
        }
        this.qData.getAssets().addCredits(questRewardCredits);
        this.view.showMessage(Localizer.getInstance().getMessage("lblChallengeCompletedBountyIS", String.valueOf(questRewardCredits)), Localizer.getInstance().getMessage("lblChallengeRewardsForEvent", this.qEvent.getTitle()), FSkinProp.ICO_QUEST_BOX);
        this.awardSpecialReward(null);
    }

    private void awardSpecialReward(String message) {
        List<InventoryItem> itemsWon = this.qEvent.getCardRewardList();
        if (itemsWon == null || itemsWon.isEmpty()) {
            return;
        }
        ArrayList<PaperCard> cardsWon = new ArrayList<PaperCard>();
        for (InventoryItem ii : itemsWon) {
            List<PaperCard> cardChoices;
            PaperCard chosenCard;
            if (ii instanceof PaperCard) {
                cardsWon.add((PaperCard)ii);
                continue;
            }
            if (ii instanceof TournamentPack || ii instanceof BoosterPack) {
                SealedProduct booster;
                ArrayList<PaperCard> boosterCards = new ArrayList<PaperCard>();
                if (ii instanceof BoosterPack) {
                    booster = (BoosterPack)((BoosterPack)ii).clone();
                    boosterCards.addAll(booster.getCards());
                } else {
                    booster = (TournamentPack)((TournamentPack)ii).clone();
                    boosterCards.addAll(booster.getCards());
                }
                if (boosterCards.isEmpty()) continue;
                this.qData.getCards().addAllCards(boosterCards);
                this.view.showCards("Extra " + ii.getName() + "!", boosterCards);
                continue;
            }
            if (!(ii instanceof IQuestRewardCard) || null == (chosenCard = null == (cardChoices = ((IQuestRewardCard)ii).getChoices()) ? null : SGuiChoose.one("Choose " + ii.getName(), cardChoices))) continue;
            cardsWon.add(chosenCard);
        }
        if (!cardsWon.isEmpty()) {
            if (message == null) {
                message = "Cards Won";
            }
            this.view.showCards(message, cardsWon);
            this.qData.getCards().addAllCards(cardsWon);
        }
    }

    private void penalizeLoss() {
        int x = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.PENALTY_LOSS);
        this.view.showMessage(Localizer.getInstance().getMessage("lblYouHaveLostNCredits", String.valueOf(x)), Localizer.getInstance().getMessage("lblGameplayResults", new Object[0]), FSkinProp.ICO_QUEST_HEART);
    }

    private boolean getLuckyCoinResult() {
        boolean hasCoin = this.qData.getAssets().getItemLevel(QuestItemType.LUCKY_COIN) >= 1;
        return MyRandom.getRandom().nextFloat() <= (hasCoin ? 0.65f : 0.5f);
    }

    private static int getCreditsRewardForAltWin(GameLossReason whyAiLost) {
        QuestPreferences qp = FModel.getQuestPreferences();
        if (null == whyAiLost) {
            return qp.getPrefInt(QuestPreferences.QPref.REWARDS_ALTERNATIVE);
        }
        switch (whyAiLost) {
            case LifeReachedZero: {
                return 0;
            }
            case Milled: {
                return qp.getPrefInt(QuestPreferences.QPref.REWARDS_MILLED);
            }
            case Poisoned: {
                return qp.getPrefInt(QuestPreferences.QPref.REWARDS_POISON);
            }
            case SpellEffect: {
                return qp.getPrefInt(QuestPreferences.QPref.REWARDS_ALTERNATIVE);
            }
        }
        return 0;
    }

    private static int getCreditsRewardForWinByTurn(int iTurn) {
        int credits = iTurn <= 1 ? FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_TURN1) : (iTurn <= 5 ? FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_TURN5) : (iTurn <= 10 ? FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_TURN10) : (iTurn <= 15 ? FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.REWARDS_TURN15) : 0)));
        return credits;
    }
}

