/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.gamemodes.quest.QuestRewardCard;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.ItemPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QuestRewardCardChooser
extends QuestRewardCard {
    private poolType type;
    private final String description;
    private final Predicate<PaperCard> predicates;

    public QuestRewardCardChooser(poolType setType, String[] creationParameters) {
        this.type = setType;
        if (this.type == poolType.playerCards) {
            this.description = "a duplicate card";
            this.predicates = null;
        } else {
            this.description = this.buildDescription(creationParameters);
            this.predicates = this.buildPredicates(creationParameters);
        }
    }

    @Override
    public String getName() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public String getItemType() {
        switch (this.type) {
            case playerCards: {
                return "duplicate card";
            }
        }
        return "chosen card";
    }

    public poolType getType() {
        return this.type;
    }

    @Override
    public final List<PaperCard> getChoices() {
        if (this.type == poolType.playerCards) {
            ItemPool<PaperCard> playerCards = FModel.getQuest().getAssets().getCardPool();
            if (!playerCards.isEmpty()) {
                ArrayList<PaperCard> cardChoices = new ArrayList<PaperCard>();
                for (Map.Entry<PaperCard, Integer> entry : playerCards) {
                    cardChoices.add(entry.getKey());
                }
                Collections.sort(cardChoices);
                return Collections.unmodifiableList(cardChoices);
            }
        } else {
            if (this.type == poolType.predicateFilter) {
                ArrayList<PaperCard> cardChoices = new ArrayList<PaperCard>();
                for (PaperCard card : Iterables.filter(FModel.getMagicDb().getCommonCards().getAllCards(), this.predicates)) {
                    cardChoices.add(card);
                }
                Collections.sort(cardChoices);
                return Collections.unmodifiableList(cardChoices);
            }
            throw new RuntimeException("Unknown QuestRewardCardType: " + (Object)((Object)this.type));
        }
        return null;
    }

    public static enum poolType {
        playerCards,
        predicateFilter;

    }
}

