/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.LimitedPoolType;
import forge.gamemodes.quest.IQuestEvent;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestDraftUtils;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.ReadPriceList;
import forge.gamemodes.tournament.system.TournamentBracket;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import forge.gui.GuiBase;
import forge.item.BoosterPack;
import forge.item.PaperCard;
import forge.model.CardBlock;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.MyRandom;
import forge.util.NameGenerator;
import forge.util.TextUtil;
import forge.util.storage.IStorage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuestEventDraft
implements IQuestEvent {
    public static final String UNDETERMINED = "quest_draft_undetermined_place";
    public static final String HUMAN = "quest_draft_human_place";
    public static final String DECK_NAME = "Tournament Deck";
    public static final int TOTAL_ROUNDS = 3;
    public static final int PLAYERS_IN_PAIRING = 2;
    private static final transient ReadPriceList PRICE_LIST_READER = new ReadPriceList();
    private static final transient Map<String, Integer> MAP_PRICES = PRICE_LIST_READER.getPriceList();
    private String title = "Mystery Draft";
    private String boosterConfiguration = "";
    private String block = "";
    private int entryFee = 0;
    private String[] standings = new String[15];
    private TournamentBracket bracket;
    private String[] aiNames = new String[7];
    private int[] aiIcons = new int[7];
    private boolean started = false;
    private int age = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.WINS_ROTATE_DRAFT);

    public QuestEventDraft(String title) {
        this.title = title;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String[] getBoosterConfiguration() {
        return this.boosterConfiguration.split("/");
    }

    public final void setBoosterConfiguration(String boosterConfiguration) {
        this.boosterConfiguration = boosterConfiguration;
    }

    public final void setEntryFee(int entryFee) {
        this.entryFee = entryFee;
    }

    public final int getEntryFee() {
        return this.entryFee;
    }

    public final void setBlock(String block) {
        this.block = block;
    }

    public final String getBlock() {
        return this.block;
    }

    public void setTitle(String title0) {
        this.title = title0;
    }

    public void setStandings(String[] standings) {
        this.standings = standings;
    }

    public String[] getStandings() {
        return this.standings;
    }

    public String[] getAINames() {
        return this.aiNames;
    }

    public void setAINames(String[] names) {
        this.aiNames = names;
    }

    public int[] getAIIcons() {
        return this.aiIcons;
    }

    public void setAIIcons(int[] icons) {
        this.aiIcons = icons;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void addWin() {
        --this.age;
    }

    public TournamentBracket getBracket() {
        return this.bracket;
    }

    public void setBracket(TournamentBracket brckt) {
        this.bracket = brckt;
    }

    public void saveToRegularDraft() {
        String tournamentName = FModel.getQuest().getName() + " Tournament Deck " + new SimpleDateFormat("EEE d MMM yyyy HH-mm-ss").format(new Date());
        DeckGroup original = FModel.getQuest().getDraftDecks().get(DECK_NAME);
        DeckGroup output = new DeckGroup(tournamentName);
        for (Deck aiDeck : original.getAiDecks()) {
            output.addAiDeck(QuestEventDraft.copyDeck(aiDeck));
        }
        output.setHumanDeck(QuestEventDraft.copyDeck(original.getHumanDeck(), tournamentName));
        FModel.getDecks().getDraft().add(output);
    }

    public void addToQuestDecks() {
        String deckName = "Tournament Deck " + new SimpleDateFormat("EEE d MMM yyyy HH-mm-ss").format(new Date());
        Deck tournamentDeck = FModel.getQuest().getDraftDecks().get(DECK_NAME).getHumanDeck();
        Deck deck = new Deck(deckName);
        List cards = tournamentDeck.getAllCardsInASinglePool().toFlatList();
        for (PaperCard c : cards) {
            if (c.isVeryBasicLand() && !c.isFoil()) continue;
            FModel.getQuest().getCards().addSingleCard(c, 1);
        }
        if (tournamentDeck.get(DeckSection.Main).countAll() > 0) {
            deck.getOrCreate(DeckSection.Main).addAll(tournamentDeck.get(DeckSection.Main));
            FModel.getQuest().getMyDecks().add(deck);
        }
        FModel.getQuest().getDraftDecks().delete(DECK_NAME);
        FModel.getQuest().getAchievements().endCurrentTournament(FModel.getQuest().getAchievements().getCurrentDraft().getPlayerPlacement());
        FModel.getQuest().save();
    }

    private static Deck copyDeck(Deck deck) {
        return new Deck(deck);
    }

    private static Deck copyDeck(Deck deck, String deckName) {
        return new Deck(deck, deckName);
    }

    public void setWinner(String playerName) {
        if (QuestDraftUtils.TOURNAMENT_TOGGLE) {
            TournamentPairing pairing = this.bracket.getNextPairing();
            for (TournamentPlayer player : pairing.getPairedPlayers()) {
                if (!player.getPlayer().getName().equals(playerName)) continue;
                pairing.setWinner(player);
                this.bracket.reportMatchCompletion(pairing);
                break;
            }
        }
        boolean isHumanPlayer = true;
        for (String name : this.aiNames) {
            if (!playerName.equals(name)) continue;
            isHumanPlayer = false;
            break;
        }
        int playerIndex = -1;
        if (isHumanPlayer) {
            for (int i = this.standings.length - 1; i >= 0; --i) {
                if (!this.standings[i].equals(HUMAN)) continue;
                playerIndex = i;
                break;
            }
        } else {
            int i;
            String aiIndex = "";
            for (i = this.aiNames.length - 1; i >= 0; --i) {
                if (!this.aiNames[i].equals(playerName)) continue;
                aiIndex = "" + (i + 1);
                break;
            }
            for (i = this.standings.length - 1; i >= 0; --i) {
                if (!this.standings[i].equals(aiIndex)) continue;
                playerIndex = i;
                break;
            }
        }
        this.standings[playerIndex / 2 + 8] = this.standings[playerIndex];
    }

    public QuestDraftPrizes collectPrizes() {
        int place = this.getPlayerPlacement();
        int prizePool = this.entryFee * 9;
        int boosterPrices = 0;
        for (String boosterSet : this.boosterConfiguration.split("/")) {
            String boosterName = FModel.getMagicDb().getEditions().get(boosterSet).getName() + " Booster Pack";
            int value = MAP_PRICES.getOrDefault(boosterName, 395);
            boosterPrices += value;
        }
        prizePool -= boosterPrices * 8;
        QuestDraftPrizes prizes = null;
        switch (place) {
            case 1: {
                prizes = this.generateFirstPlacePrizes(prizePool);
                break;
            }
            case 2: {
                prizes = this.generateSecondPlacePrizes(prizePool);
                break;
            }
            case 3: {
                prizes = this.generateThirdPlacePrizes();
                break;
            }
            case 4: {
                prizes = this.generateFourthPlacePrizes();
            }
        }
        if (prizes != null) {
            if (prizes.hasCredits()) {
                FModel.getQuest().getAssets().addCredits(prizes.credits);
            }
            if (prizes.hasBoosterPacks()) {
                for (BoosterPack boosterPack : prizes.boosterPacks) {
                    FModel.getQuest().getCards().addAllCards(boosterPack.getCards());
                }
            }
            if (prizes.hasIndividualCards()) {
                FModel.getQuest().getCards().addAllCards(prizes.individualCards);
            }
            return prizes;
        }
        return null;
    }

    private QuestDraftPrizes generateFirstPlacePrizes(int prizePool) {
        int credits = 2 * (prizePool / 3);
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        ArrayList<BoosterPack> boosters = new ArrayList<BoosterPack>();
        cards.add(this.getPromoCard());
        int creditsLeftAfterPacks = this.generateBoosters(credits / 2, boosters);
        credits = credits / 2 + creditsLeftAfterPacks;
        QuestDraftPrizes prizes = new QuestDraftPrizes();
        prizes.credits = credits;
        prizes.boosterPacks = boosters;
        prizes.individualCards = cards;
        this.awardSelectedRare(prizes);
        return prizes;
    }

    private QuestDraftPrizes generateSecondPlacePrizes(int prizePool) {
        int credits = prizePool / 3;
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        ArrayList<BoosterPack> boosters = new ArrayList<BoosterPack>();
        cards.add(this.getPromoCard());
        int creditsLeftAfterPacks = this.generateBoosters(credits / 4 * 3, boosters);
        credits = credits / 4 + creditsLeftAfterPacks;
        QuestDraftPrizes prizes = new QuestDraftPrizes();
        prizes.credits = credits;
        prizes.boosterPacks = boosters;
        prizes.individualCards = cards;
        this.awardSelectedRare(prizes);
        return prizes;
    }

    private QuestDraftPrizes generateThirdPlacePrizes() {
        boolean credits = false;
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        cards.add(this.getPromoCard());
        ArrayList<BoosterPack> boosters = new ArrayList<BoosterPack>();
        boosters.add(this.getBoosterPack());
        QuestDraftPrizes prizes = new QuestDraftPrizes();
        prizes.credits = 0;
        prizes.boosterPacks = boosters;
        prizes.individualCards = cards;
        return prizes;
    }

    private QuestDraftPrizes generateFourthPlacePrizes() {
        boolean credits = false;
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        cards.add(this.getPromoCard());
        QuestDraftPrizes prizes = new QuestDraftPrizes();
        prizes.credits = 0;
        prizes.individualCards = cards;
        return prizes;
    }

    private int generateBoosters(int creditsForPacks, List<BoosterPack> boosters) {
        BoosterPack pack;
        int price;
        int creditsAfterPacks = creditsForPacks;
        while (!((float)(price = QuestEventDraft.getBoosterPrice(pack = this.getBoosterPack())) > (float)creditsAfterPacks * 1.1f)) {
            creditsAfterPacks -= price;
            boosters.add(pack);
        }
        return creditsAfterPacks;
    }

    private void awardSelectedRare(QuestDraftPrizes prizes) {
        ArrayList<PaperCard> possibleCards = new ArrayList<PaperCard>();
        ArrayList<String> cardNames = new ArrayList<String>();
        for (CardEdition edition : this.getAllEditions()) {
            for (CardEdition.CardInSet card : edition.getAllCardsInSet()) {
                PaperCard cardToAdd;
                if (card.rarity != CardRarity.Rare && card.rarity != CardRarity.MythicRare || (cardToAdd = FModel.getMagicDb().getCommonCards().getCard(card.name, edition.getCode())) == null || cardNames.contains(cardToAdd.getName())) continue;
                possibleCards.add(cardToAdd);
                cardNames.add(cardToAdd.getName());
            }
        }
        prizes.selectRareCards = possibleCards;
    }

    private BoosterPack getBoosterPack() {
        CardEdition edition = this.getRandomEdition();
        return BoosterPack.fromSet(edition);
    }

    private PaperCard getPromoCard() {
        CardEdition randomEdition = this.getRandomEdition();
        ArrayList<CardEdition.CardInSet> cardsInEdition = new ArrayList<CardEdition.CardInSet>();
        ArrayList<String> cardNames = new ArrayList<String>();
        for (CardEdition.CardInSet card : randomEdition.getAllCardsInSet()) {
            if (card.rarity != CardRarity.Rare && card.rarity != CardRarity.MythicRare || cardNames.contains(card.name)) continue;
            cardsInEdition.add(card);
            cardNames.add(card.name);
        }
        PaperCard promo = null;
        int attempts = 25;
        while (promo == null && attempts-- > 0) {
            CardEdition.CardInSet randomCard = (CardEdition.CardInSet)cardsInEdition.get((int)(MyRandom.getRandom().nextDouble() * (double)cardsInEdition.size()));
            promo = FModel.getMagicDb().getCommonCards().getCard(randomCard.name, randomEdition.getCode());
        }
        if (promo == null) {
            return FModel.getQuest().getCards().addRandomRare();
        }
        return promo;
    }

    private CardEdition getRandomEdition() {
        ArrayList<CardEdition> editions = new ArrayList<CardEdition>();
        for (String booster : this.boosterConfiguration.split("/")) {
            editions.add(FModel.getMagicDb().getEditions().get(booster));
        }
        return (CardEdition)editions.get((int)(MyRandom.getRandom().nextDouble() * (double)editions.size()));
    }

    private Set<CardEdition> getAllEditions() {
        HashSet<CardEdition> editions = new HashSet<CardEdition>();
        for (String booster : this.boosterConfiguration.split("/")) {
            editions.add(FModel.getMagicDb().getEditions().get(booster));
        }
        return editions;
    }

    private static int getBoosterPrice(BoosterPack booster) {
        String boosterName = booster.getName();
        int value = MAP_PRICES.getOrDefault(boosterName, 395);
        return value;
    }

    public boolean playerHasMatchesLeft() {
        int nextMatchIndex;
        if (QuestDraftUtils.TOURNAMENT_TOGGLE) {
            return !this.bracket.isTournamentOver() && this.bracket.isPlayerRemaining(-1);
        }
        int playerIndex = -1;
        for (int i = this.standings.length - 1; i >= 0; --i) {
            if (!this.standings[i].equals(HUMAN)) continue;
            playerIndex = i;
            break;
        }
        switch (playerIndex) {
            case 0: 
            case 1: {
                nextMatchIndex = 8;
                break;
            }
            case 2: 
            case 3: {
                nextMatchIndex = 9;
                break;
            }
            case 4: 
            case 5: {
                nextMatchIndex = 10;
                break;
            }
            case 6: 
            case 7: {
                nextMatchIndex = 11;
                break;
            }
            case 8: 
            case 9: {
                nextMatchIndex = 12;
                break;
            }
            case 10: 
            case 11: {
                nextMatchIndex = 13;
                break;
            }
            case 12: 
            case 13: {
                nextMatchIndex = 14;
                break;
            }
            default: {
                nextMatchIndex = -1;
            }
        }
        return nextMatchIndex != -1 && this.standings[nextMatchIndex].equals(UNDETERMINED);
    }

    public int getPlayerPlacement() {
        if (QuestDraftUtils.TOURNAMENT_TOGGLE) {
            return 5 - this.bracket.getFurthestRound(-1);
        }
        int playerIndex = -1;
        for (int i = this.standings.length - 1; i >= 0; --i) {
            if (!this.standings[i].equals(HUMAN)) continue;
            playerIndex = i;
            break;
        }
        if (playerIndex <= 7) {
            return 4;
        }
        if (playerIndex <= 11) {
            return 3;
        }
        if (playerIndex <= 13) {
            return 2;
        }
        if (playerIndex == 14) {
            return 1;
        }
        return -1;
    }

    public String getPlacementString() {
        String output;
        int place = this.getPlayerPlacement();
        switch (place) {
            case 1: {
                output = "first";
                break;
            }
            case 2: {
                output = "second";
                break;
            }
            case 3: {
                output = "third";
                break;
            }
            case 4: {
                output = "fourth";
                break;
            }
            default: {
                output = "ERROR";
            }
        }
        return output;
    }

    public boolean canEnter() {
        long creditsAvailable = FModel.getQuest().getAssets().getCredits();
        return creditsAvailable < (long)this.getEntryFee();
    }

    public BoosterDraft enter() {
        FModel.getQuest().getAchievements().setCurrentDraft(this);
        FModel.getQuest().getAssets().subtractCredits(this.getEntryFee());
        return BoosterDraft.createDraft(LimitedPoolType.Block, FModel.getBlocks().get(this.getBlock()), this.getBoosterConfiguration());
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
        FModel.getQuest().save();
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public String toString() {
        return this.title;
    }

    private static List<CardEdition> getAllowedSets(QuestController quest) {
        ArrayList<CardEdition> allowedQuestSets;
        block4: {
            allowedQuestSets = new ArrayList<CardEdition>();
            if (quest.getFormat() == null) break block4;
            List<String> allowedSetCodes = quest.getFormat().getAllowedSetCodes();
            if (!allowedSetCodes.isEmpty()) {
                for (String setCode : allowedSetCodes) {
                    allowedQuestSets.add(FModel.getMagicDb().getEditions().get(setCode));
                }
            } else {
                for (CardEdition ce : FModel.getMagicDb().getEditions()) {
                    allowedQuestSets.add(ce);
                }
            }
        }
        return allowedQuestSets;
    }

    private static List<CardBlock> getBlocks() {
        ArrayList<CardBlock> blocks = new ArrayList<CardBlock>();
        IStorage<CardBlock> storage = FModel.getBlocks();
        for (CardBlock b : storage) {
            if (b.getCntBoostersDraft() <= 0) continue;
            blocks.add(b);
        }
        return blocks;
    }

    public static List<QuestDraftFormat> getAvailableFormats(QuestController quest) {
        List<CardEdition> allowedQuestSets = QuestEventDraft.getAllowedSets(quest);
        ArrayList<QuestDraftFormat> possibleFormats = new ArrayList<QuestDraftFormat>();
        List<CardBlock> blocks = QuestEventDraft.getBlocks();
        ArrayList singleSets = new ArrayList();
        if (!allowedQuestSets.isEmpty()) {
            for (CardBlock block : blocks) {
                boolean blockAllowed = true;
                for (CardEdition set : block.getSets()) {
                    if (allowedQuestSets.contains(set)) continue;
                    blockAllowed = false;
                    break;
                }
                if (!blockAllowed) continue;
                possibleFormats.add(new QuestDraftFormat(block));
            }
            for (CardEdition allowedQuestSet : allowedQuestSets) {
                if (!allowedQuestSet.isLargeSet() || singleSets.contains(allowedQuestSet.getCode()) || !allowedQuestSet.hasBoosterTemplate() || allowedQuestSet.getType() == CardEdition.Type.OTHER) continue;
                possibleFormats.add(new QuestDraftFormat(allowedQuestSet));
            }
        } else {
            for (CardBlock block : blocks) {
                possibleFormats.add(new QuestDraftFormat(block));
                if (block.getSets().size() <= 1) continue;
                for (CardEdition edition : block.getSets()) {
                    if (!edition.isLargeSet()) continue;
                    possibleFormats.add(new QuestDraftFormat(edition));
                }
            }
        }
        Collections.sort(possibleFormats);
        return possibleFormats;
    }

    public static QuestEventDraft getRandomDraftOrNull(QuestController quest) {
        List<QuestDraftFormat> possibleFormats = QuestEventDraft.getAvailableFormats(quest);
        if (possibleFormats.isEmpty()) {
            return null;
        }
        Collections.shuffle(possibleFormats);
        return QuestEventDraft.getDraftOrNull(quest, possibleFormats.get(0));
    }

    public static QuestEventDraft getDraftOrNull(QuestController quest, QuestDraftFormat format) {
        int i;
        int i2;
        QuestEventDraft event = new QuestEventDraft(format.getName());
        if (format.isSet()) {
            CardEdition edition = format.edition;
            String boosterConfiguration = "";
            for (i2 = 0; i2 < 3; ++i2) {
                boosterConfiguration = boosterConfiguration + edition.getCode();
                if (i2 != 2) {
                    boosterConfiguration = boosterConfiguration + "/";
                }
                event.boosterConfiguration = boosterConfiguration;
            }
        } else {
            ArrayList<String> possibleSetCombinations = new ArrayList<String>(QuestEventDraft.getSetCombos(quest, format.block));
            if (possibleSetCombinations.isEmpty()) {
                System.err.println("Warning: no valid set combinations were detected when trying to generate a draft tournament for the format: " + format);
                return null;
            }
            Collections.shuffle(possibleSetCombinations);
            event.boosterConfiguration = (String)possibleSetCombinations.get(0);
        }
        event.block = format.getName();
        event.entryFee = QuestEventDraft.calculateEntryFee(event.boosterConfiguration.split("/"));
        ArrayList<String> players = new ArrayList<String>();
        players.add(HUMAN);
        players.add("1");
        players.add("2");
        players.add("3");
        players.add("4");
        players.add("5");
        players.add("6");
        players.add("7");
        Collections.shuffle(players);
        for (i = 0; i < players.size(); ++i) {
            event.standings[i] = (String)players.get(i);
        }
        for (i = 8; i < event.standings.length; ++i) {
            event.standings[i] = UNDETERMINED;
        }
        ArrayList<String> usedNames = new ArrayList<String>();
        usedNames.add(GamePlayerUtil.getGuiPlayer().getName());
        for (i2 = 0; i2 < 7; ++i2) {
            event.aiNames[i2] = NameGenerator.getRandomName("Any", "Any", usedNames);
            usedNames.add(event.aiNames[i2]);
        }
        int numberOfIcons = GuiBase.getInterface().getAvatarCount();
        ArrayList<Integer> usedIcons = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 7; ++i3) {
            int icon;
            int attempts = 50;
            while (((icon = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)numberOfIcons)) < 0 || usedIcons.contains(icon)) && attempts-- > 0) {
            }
            event.aiIcons[i3] = icon;
            usedNames.add(event.aiNames[i3]);
            usedIcons.add(icon);
        }
        event.bracket = QuestEventDraft.createBracketFromStandings(event.standings, event.aiNames, event.aiIcons);
        return event;
    }

    private static int calculateEntryFee(String[] boosters) {
        int entryFee = 0;
        for (String boosterSet : boosters) {
            String boosterName = FModel.getMagicDb().getEditions().get(boosterSet).getName() + " Booster Pack";
            int value = MAP_PRICES.getOrDefault(boosterName, 395);
            entryFee += value;
        }
        return (int)((double)entryFee * 1.5);
    }

    private static Set<String> getSetCombos(QuestController quest, CardBlock block) {
        List<CardEdition> allowedSets;
        LinkedHashSet<String> possibleCombinations = new LinkedHashSet<String>();
        List<CardEdition> sets = block.getSets();
        String s0c = sets.get(0).getCode();
        if (sets.size() == 1) {
            int numBoosters = block.getCntBoostersDraft();
            StringBuilder combination = new StringBuilder();
            for (int i = 0; i < numBoosters; ++i) {
                combination.append(s0c);
                if (i >= numBoosters - 1) continue;
                combination.append("/");
            }
            possibleCombinations.add(combination.toString());
            return possibleCombinations;
        }
        if (quest.getFormat() == null) {
            allowedSets = new ArrayList<CardEdition>(sets);
        } else {
            allowedSets = QuestEventDraft.getAllowedSets(quest);
            allowedSets.retainAll(sets);
        }
        boolean oldSetsFirst = sets.get(0).getDate().before(FModel.getMagicDb().getEditions().get("SOM").getDate());
        allowedSets.sort((edition1, edition2) -> {
            if (edition1.getDate().before(edition2.getDate())) {
                return oldSetsFirst ? -1 : 1;
            }
            if (edition1.getDate().after(edition2.getDate())) {
                return oldSetsFirst ? 1 : -1;
            }
            return 0;
        });
        boolean largeSetFound = false;
        for (CardEdition allowedSet : allowedSets) {
            if (!allowedSet.isLargeSet()) continue;
            largeSetFound = true;
            break;
        }
        if (!largeSetFound) {
            throw new IllegalStateException(allowedSets + " does not contain a large set for quest draft generation.");
        }
        if (allowedSets.containsAll(sets) || !quest.getWorld().getName().toLowerCase().equals("main world")) {
            CardEdition set0 = allowedSets.get(0);
            CardEdition set1 = allowedSets.get(1);
            if (allowedSets.size() == 2) {
                boolean draftOrder2016;
                boolean bl = draftOrder2016 = set0.getDate().after(FModel.getMagicDb().getEditions().get("BFZ").getDate()) || set1.getDate().after(FModel.getMagicDb().getEditions().get("BFZ").getDate());
                if (draftOrder2016) {
                    if (set0.isLargeSet()) {
                        possibleCombinations.add(TextUtil.concatNoSpace(set1.getCode(), "/", set1.getCode(), "/", set0.getCode()));
                    } else {
                        possibleCombinations.add(TextUtil.concatNoSpace(set0.getCode(), "/", set0.getCode(), "/", set1.getCode()));
                    }
                } else if (set0.isLargeSet()) {
                    possibleCombinations.add(TextUtil.concatNoSpace(set0.getCode(), "/", set0.getCode(), "/", set1.getCode()));
                } else {
                    possibleCombinations.add(TextUtil.concatNoSpace(set0.getCode(), "/", set1.getCode(), "/", set1.getCode()));
                }
            }
            if (allowedSets.size() == 3) {
                CardEdition set2 = allowedSets.get(2);
                possibleCombinations.add(TextUtil.concatNoSpace(set0.getCode(), "/", set1.getCode(), "/", set2.getCode()));
            }
        }
        return possibleCombinations;
    }

    public static TournamentBracket createBracketFromStandings(String[] standings, String[] aiNames, int[] aiIcons) {
        int i;
        TournamentBracket bracket = new TournamentBracket(3, 2);
        bracket.setContinualPairing(false);
        int roundParticipants = (int)Math.pow(2.0, 3.0);
        for (i = 0; i < roundParticipants; ++i) {
            if (standings[i].equals(HUMAN)) {
                bracket.addTournamentPlayer(GamePlayerUtil.getGuiPlayer());
                continue;
            }
            int idx = Integer.parseInt(standings[i]) - 1;
            bracket.addTournamentPlayer(GamePlayerUtil.createAiPlayer(aiNames[idx], aiIcons[idx]), idx);
        }
        bracket.setInitialized(true);
        bracket.generateActivePairings();
        while (i < 14) {
            TournamentPairing pairing = bracket.getNextPairing();
            if (pairing == null) {
                bracket.generateActivePairings();
                pairing = bracket.getNextPairing();
            }
            if (standings[i].equals(UNDETERMINED)) break;
            int idx = standings[i].equals(HUMAN) ? -1 : Integer.parseInt(standings[i]) - 1;
            pairing.setWinnerByIndex(idx);
            bracket.reportMatchCompletion(pairing);
            ++i;
        }
        if (i == 14) {
            System.out.println("Tournament done...");
        }
        return bracket;
    }

    @Override
    public final String getFullTitle() {
        return this.title;
    }

    public String getBoosterList() {
        StringBuilder boosterList = new StringBuilder();
        String[] boosterArray = this.boosterConfiguration.split("/");
        for (int i = 0; i < boosterArray.length; ++i) {
            boosterList.append(FModel.getMagicDb().getEditions().get(boosterArray[i]).getName());
            if (i == boosterArray.length - 1) continue;
            boosterList.append(" | ");
        }
        return boosterList.toString();
    }

    @Override
    public String getDescription() {
        return this.getBoosterList() + "\n" + QuestUtil.formatCredits(this.entryFee) + " Credit Entry Fee";
    }

    @Override
    public void select() {
        QuestUtil.setDraftEvent(this);
    }

    @Override
    public String getIconImageKey() {
        return null;
    }

    @Override
    public void setIconImageKey(String iconImageKey) {
    }

    @Override
    public boolean hasImage() {
        return false;
    }

    public static class QuestDraftFormat
    implements Comparable<QuestDraftFormat> {
        private CardEdition edition;
        private CardBlock block;

        public QuestDraftFormat(CardEdition edition) {
            this.edition = edition;
        }

        public QuestDraftFormat(CardBlock block) {
            this.block = block;
        }

        private boolean isSet() {
            return this.edition != null;
        }

        public String toString() {
            if (this.edition != null) {
                return this.edition.getName() + " (" + this.edition.getCode() + ")";
            }
            StringBuilder blockString = new StringBuilder(this.block.getName() + " (");
            List<CardEdition> sets = this.block.getSets();
            for (int i = 0; i < sets.size(); ++i) {
                CardEdition cardEdition = sets.get(i);
                blockString.append(cardEdition.getCode());
                if (i >= sets.size() - 1) continue;
                blockString.append(", ");
            }
            blockString.append(")");
            return blockString.toString();
        }

        public String getName() {
            if (this.edition != null) {
                if (this.block == null) {
                    String blockName = "";
                    for (CardBlock cb : FModel.getBlocks()) {
                        if (!cb.getSets().contains(this.edition)) continue;
                        blockName = cb.getName();
                        break;
                    }
                    if (!blockName.isEmpty() && blockName != this.edition.getName()) {
                        return blockName;
                    }
                }
                return this.edition.getName();
            }
            return this.block.getName();
        }

        @Override
        public int compareTo(QuestDraftFormat other) {
            return this.toString().compareToIgnoreCase(other.toString());
        }
    }

    public static class QuestDraftPrizes {
        public int credits;
        public List<BoosterPack> boosterPacks;
        public List<PaperCard> individualCards;
        public List<PaperCard> selectRareCards;

        public boolean hasCredits() {
            return this.credits > 0;
        }

        public boolean hasBoosterPacks() {
            return this.boosterPacks != null && !this.boosterPacks.isEmpty();
        }

        public boolean hasIndividualCards() {
            return this.individualCards != null && !this.individualCards.isEmpty();
        }

        public boolean selectRareFromSets() {
            return this.selectRareCards != null && !this.selectRareCards.isEmpty();
        }

        public void addSelectedCard(PaperCard card) {
            FModel.getQuest().getCards().addSingleCard(card, 1);
        }
    }
}

