/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.deck.CardPool;
import forge.deck.CommanderDeckGenerator;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckProxy;
import forge.gamemodes.quest.QuestEventCommanderDuel;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.gamemodes.quest.QuestEventDuel;
import forge.gamemodes.quest.QuestEventDuelManagerInterface;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QuestEventCommanderDuelManager
implements QuestEventDuelManagerInterface {
    private ArrayList<QuestEventDuel> commanderDuels = new ArrayList();
    private List<DeckProxy> expertCommanderDecks;

    public QuestEventCommanderDuelManager() {
        this.assembleDuels();
    }

    private void assembleDuels() {
        this.expertCommanderDecks = CommanderDeckGenerator.getCommanderDecks(DeckFormat.Commander, true, true);
        List<DeckProxy> generatedDuels = CommanderDeckGenerator.getCommanderDecks(DeckFormat.Commander, true, false);
        for (DeckProxy dp : generatedDuels) {
            QuestEventCommanderDuel duel = new QuestEventCommanderDuel();
            duel.setDescription("Randomly generated " + dp.getName() + " commander deck.");
            duel.setName(dp.getName());
            duel.setTitle(dp.getName());
            duel.setOpponentName(dp.getName());
            duel.setDifficulty(QuestEventDifficulty.EASY);
            duel.setDeckProxy(dp);
            duel.setEventDeck(new Deck());
            this.commanderDuels.add(duel);
        }
    }

    @Override
    public Iterable<QuestEventDuel> getAllDuels() {
        return this.commanderDuels;
    }

    @Override
    public Iterable<QuestEventDuel> getDuels(QuestEventDifficulty difficulty) {
        return this.commanderDuels;
    }

    @Override
    public List<QuestEventDuel> generateDuels() {
        QuestEventCommanderDuel duel;
        ArrayList<QuestEventDuel> duelOpponents = new ArrayList<QuestEventDuel>();
        while (duelOpponents.size() < 4) {
            duel = (QuestEventCommanderDuel)this.commanderDuels.get((int)((double)this.commanderDuels.size() * MyRandom.getRandom().nextDouble()));
            if (duelOpponents.contains(duel)) continue;
            duelOpponents.add(duel);
            duel.setEventDeck(duel.getDeckProxy().getDeck());
            this.modifyDuelForDifficulty(duel);
        }
        duel = (QuestEventCommanderDuel)duelOpponents.get(duelOpponents.size() - 1);
        QuestEventCommanderDuel randomDuel = new QuestEventCommanderDuel();
        randomDuel.setName(duel.getName());
        randomDuel.setOpponentName(duel.getName());
        randomDuel.setDeckProxy(duel.getDeckProxy());
        randomDuel.setTitle("Random Opponent");
        randomDuel.setShowDifficulty(false);
        randomDuel.setDescription("Fight a random generated commander opponent.");
        randomDuel.setIsRandomMatch(true);
        randomDuel.setEventDeck(duel.getEventDeck());
        duelOpponents.set(duelOpponents.size() - 1, randomDuel);
        return duelOpponents;
    }

    private Deck getExpertGenDeck(DeckProxy dp) {
        for (QuestEventDuel qed : this.commanderDuels) {
            QuestEventCommanderDuel cmdQED = (QuestEventCommanderDuel)qed;
            if (!cmdQED.getDeckProxy().getName().equals(dp.getName())) continue;
            return cmdQED.getDeckProxy().getDeck();
        }
        return null;
    }

    private void modifyDuelForDifficulty(QuestEventCommanderDuel duel) {
        QuestPreferences questPreferences = FModel.getQuestPreferences();
        int index = FModel.getQuest().getAchievements().getDifficulty();
        int numberOfWins = FModel.getQuest().getAchievements().getWin();
        Deck expertDeck = this.getExpertGenDeck(duel.getDeckProxy());
        int difficultyReplacementPercent = 0;
        if (numberOfWins >= questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_EXPERTAI, index)) {
            duel.setEventDeck(expertDeck);
            duel.setDifficulty(QuestEventDifficulty.EXPERT);
            return;
        }
        if (numberOfWins >= questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_MEDIUMAI, index)) {
            difficultyReplacementPercent += 30;
        } else {
            return;
        }
        duel.setDifficulty(QuestEventDifficulty.MEDIUM);
        if (numberOfWins >= questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
            difficultyReplacementPercent += 30;
            duel.setDifficulty(QuestEventDifficulty.HARD);
        }
        CardPool easyMain = duel.getEventDeck().getMain();
        CardPool expertMain = expertDeck.getMain();
        List easyList = easyMain.toFlatList();
        List expertList = expertMain.toFlatList();
        for (int i = 0; i < difficultyReplacementPercent; ++i) {
            if (!easyMain.contains((PaperCard)expertList.get(i))) {
                easyMain.remove((PaperCard)easyList.get(i));
                easyMain.add((PaperCard)expertList.get(i));
                continue;
            }
            expertList.remove(expertList.get(i));
            --i;
            if (expertList.size() == 0) break;
        }
    }

    @Override
    public void randomizeOpponents() {
        Collections.shuffle(this.commanderDuels);
    }
}

