/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import forge.card.CardEdition;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.game.GameFormat;
import forge.game.event.GameEvent;
import forge.game.event.GameEventMulligan;
import forge.gamemodes.quest.MainWorldEventDuelManager;
import forge.gamemodes.quest.QuestChallengeGenerator;
import forge.gamemodes.quest.QuestDeckGroupMap;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventChallenge;
import forge.gamemodes.quest.QuestEventCommanderDuelManager;
import forge.gamemodes.quest.QuestEventDuelManager;
import forge.gamemodes.quest.QuestEventDuelManagerInterface;
import forge.gamemodes.quest.QuestEventLDADuelManager;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.QuestUtilCards;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.SellRules;
import forge.gamemodes.quest.StartingPoolPreferences;
import forge.gamemodes.quest.bazaar.QuestBazaarManager;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.bazaar.QuestPetStorage;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.data.QuestAchievements;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gamemodes.quest.data.QuestData;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.data.StarRating;
import forge.gamemodes.quest.io.QuestChallengeReader;
import forge.item.PreconDeck;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.storage.IStorage;
import forge.util.storage.StorageBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class QuestController {
    private QuestData model;
    private QuestUtilCards myCards;
    private GameFormatQuest questFormat;
    private QuestEvent currentEvent;
    private transient IStorage<Deck> decks;
    private QuestEventDuelManagerInterface duelManager = null;
    private IStorage<QuestEventChallenge> allChallenges = null;
    private QuestBazaarManager bazaar = null;
    private QuestPetStorage pets = null;
    private static transient IStorage<PreconDeck> preconManager = null;
    private transient IStorage<DeckGroup> draftDecks;
    public static final String[] RANK_TITLES = new String[]{"Level 0 - Confused Wizard", "Level 1 - Mana Mage", "Level 2 - Death by Megrim", "Level 3 - Shattered the Competition", "Level 4 - Black Knighted", "Level 5 - Shockingly Good", "Level 6 - Regressed into Timmy", "Level 7 - Loves Blue Control", "Level 8 - Immobilized by Fear", "Level 9 - Lands = Friends", "Level 10 - Forging new paths", "Level 11 - Infect-o-tron", "Level 12 - Great Balls of Fire", "Level 13 - Artifact Schmartifact", "Level 14 - Mike Mulligan's The Name", "Level 15 - Fresh Air: Good For The Health", "Level 16 - In It For The Love", "Level 17 - Sticks, Stones, Bones", "Level 18 - Credits For Breakfast", "Level 19 - Millasaurus", "Level 20 - One-turn Wonder", "Teaching Gandalf a Lesson", "What Do You Do With The Other Hand?", "Freelance Sorcerer, Works Weekends", "Should We Hire Commentators?", "Saltblasted For Your Talent", "Serra Angel Is Your Girlfriend"};
    public static final int MAX_PET_SLOTS = 2;
    private static final Map<String, SellRules> preconDeals = new TreeMap<String, SellRules>();

    public void selectPet(Integer slot, String name) {
        if (this.model != null) {
            this.model.getPetSlots().put(slot, name);
        }
    }

    public void setMatchLength(String len) {
        if (this.model != null) {
            this.model.setMatchLength(Integer.parseInt(len));
        }
    }

    public int getMatchLength() {
        return this.model == null ? 3 : this.model.getMatchLength();
    }

    public String getSelectedPet(Integer slot) {
        return this.model == null ? null : this.model.getPetSlots().get(slot);
    }

    public QuestUtilCards getCards() {
        return this.myCards;
    }

    public void SetRating(String name, String edition, int n) {
        StarRating r = new StarRating();
        r.Name = name;
        r.Edition = edition;
        int i = 0;
        while (i < 6) {
            r.rating = i++;
            this.model.Ratings.remove(r);
        }
        r.rating = n;
        if (n != 0) {
            this.model.Ratings.add(r);
        }
    }

    public IStorage<Deck> getMyDecks() {
        return this.decks;
    }

    public IStorage<DeckGroup> getDraftDecks() {
        QuestAchievements achievements;
        if (this.draftDecks == null) {
            this.draftDecks = new QuestDeckGroupMap(new HashMap<String, DeckGroup>());
        }
        if ((achievements = this.getAchievements()) != null && (achievements.getCurrentDraftIndex() == -1 || achievements.getCurrentDraft() == null)) {
            this.draftDecks.delete("Tournament Deck");
        }
        return this.draftDecks;
    }

    public GameFormatQuest getFormat() {
        return this.getWorldFormat() == null ? this.questFormat : this.getWorldFormat();
    }

    public GameFormatQuest getMainFormat() {
        return this.questFormat;
    }

    public QuestEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(QuestEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    public static IStorage<PreconDeck> getPrecons() {
        if (null == preconManager) {
            preconManager = new StorageBase<PreconDeck>("Quest shop decks", new PreconDeck.Reader(new File(ForgeConstants.QUEST_PRECON_DIR)){

                @Override
                protected PreconDeck getPreconDeckFromSections(Map<String, List<String>> sections) {
                    PreconDeck result = super.getPreconDeckFromSections(sections);
                    preconDeals.put(result.getName(), new SellRules(sections.get("shop")));
                    return result;
                }
            });
        }
        return preconManager;
    }

    public static SellRules getPreconDeals(PreconDeck deck) {
        return preconDeals.get(deck.getName());
    }

    public void load(QuestData selectedQuest) {
        this.model = selectedQuest;
        this.decks = this.model == null ? null : this.model.getAssets().getDeckStorage();
        this.myCards = this.model == null ? null : new QuestUtilCards(this);
        this.questFormat = this.model == null ? null : this.model.getFormat();
        this.currentEvent = null;
        this.draftDecks = this.model == null ? null : this.model.getAssets().getDraftDeckStorage();
        this.resetDuelsManager();
        this.resetChallengesManager();
        this.getDuelsManager().randomizeOpponents();
    }

    public void save() {
        if (this.model != null) {
            this.model.saveData();
        }
    }

    public void newGame(String name, int difficulty, QuestMode mode, GameFormat formatPrizes, boolean allowSetUnlocks, Deck startingCards, GameFormat formatStartingPool, String startingWorld, StartingPoolPreferences userPrefs, DeckConstructionRules dcr) {
        this.load(new QuestData(name, difficulty, mode, formatPrizes, allowSetUnlocks, startingWorld, dcr));
        if (startingCards != null) {
            this.myCards.addDeck(startingCards);
        } else {
            this.myCards.setupNewGameCardPool(formatStartingPool, difficulty, userPrefs);
        }
        this.getAssets().setCredits(FModel.getQuestPreferences().getPrefInt(QuestPreferences.DifficultyPrefs.STARTING_CREDITS, difficulty));
        this.myCards.resetNewList();
    }

    public String getRank() {
        return this.getRank(this.getLevel());
    }

    public String getRank(int level) {
        if (level >= RANK_TITLES.length) {
            level = RANK_TITLES.length - 1;
        }
        return RANK_TITLES[level];
    }

    public int getLevel() {
        return this.model.getAchievements().getLevel();
    }

    public QuestAssets getAssets() {
        return this.model == null ? null : this.model.getAssets();
    }

    public QuestWorld getWorld() {
        return this.model == null || this.model.getWorldId() == null ? null : FModel.getWorlds().get(this.model.getWorldId());
    }

    public void setWorld(QuestWorld newWorld) {
        if (this.model == null) {
            return;
        }
        this.model.setWorldId(newWorld == null ? null : newWorld.getName());
    }

    public GameFormatQuest getWorldFormat() {
        if (this.model == null || this.model.getWorldId() == null) {
            return null;
        }
        QuestWorld curQw = FModel.getWorlds().get(this.model.getWorldId());
        if (curQw == null) {
            return null;
        }
        return curQw.getFormat();
    }

    public String getName() {
        return this.model == null ? null : this.model.getName();
    }

    public QuestAchievements getAchievements() {
        return this.model == null ? null : this.model.getAchievements();
    }

    public QuestMode getMode() {
        return this.model.getMode();
    }

    public final QuestBazaarManager getBazaar() {
        if (null == this.bazaar) {
            this.bazaar = new QuestBazaarManager(new File(ForgeConstants.BAZAAR_INDEX_FILE));
        }
        return this.bazaar;
    }

    public QuestEventDuelManagerInterface getDuelsManager() {
        if (this.duelManager == null) {
            this.resetDuelsManager();
        }
        return this.duelManager;
    }

    public IStorage<QuestEventChallenge> getChallenges() {
        if (this.allChallenges == null) {
            this.resetChallengesManager();
        }
        return this.allChallenges;
    }

    public void resetDuelsManager() {
        QuestWorld world = this.getWorld();
        String path = ForgeConstants.DEFAULT_CHALLENGES_DIR;
        if (FModel.getQuest() != null && FModel.getQuest().getDeckConstructionRules() != null) {
            switch (FModel.getQuest().getDeckConstructionRules()) {
                case Default: {
                    break;
                }
                case Commander: {
                    this.duelManager = new QuestEventCommanderDuelManager();
                    return;
                }
            }
        }
        if (world != null) {
            if (world.getName().equals("Random Standard")) {
                this.duelManager = new QuestEventLDADuelManager(FModel.getFormats().getStandard());
                return;
            }
            if (world.getName().equals("Random Pioneer")) {
                this.duelManager = new QuestEventLDADuelManager(FModel.getFormats().getPioneer());
                return;
            }
            if (world.getName().equals("Random Modern")) {
                this.duelManager = new QuestEventLDADuelManager(FModel.getFormats().getModern());
                return;
            }
            if (world.isCustom()) {
                path = world.getDuelsDir() == null ? ForgeConstants.DEFAULT_DUELS_DIR : ForgeConstants.USER_QUEST_WORLD_DIR + world.getDuelsDir();
                this.duelManager = new QuestEventDuelManager(new File(path));
            } else {
                String string = path = world.getDuelsDir() == null ? ForgeConstants.DEFAULT_DUELS_DIR : ForgeConstants.QUEST_WORLD_DIR + world.getDuelsDir();
                this.duelManager = "Main world".equals(world.getName()) ? new MainWorldEventDuelManager(new File(path)) : new QuestEventDuelManager(new File(path));
            }
        } else {
            this.duelManager = new QuestEventDuelManager(new File(path));
        }
    }

    public HashSet<StarRating> GetRating() {
        if (this.model == null) {
            return null;
        }
        return this.model.Ratings;
    }

    public void resetChallengesManager() {
        QuestWorld world = this.getWorld();
        String path = ForgeConstants.DEFAULT_CHALLENGES_DIR;
        if (world != null) {
            if (world.getName().equals("Random Standard")) {
                QuestChallengeGenerator gen = new QuestChallengeGenerator(FModel.getFormats().getStandard());
                this.allChallenges = gen.generateChallenges();
                return;
            }
            if (world.getName().equals("Random Standard")) {
                QuestChallengeGenerator gen = new QuestChallengeGenerator(FModel.getFormats().getModern());
                this.allChallenges = gen.generateChallenges();
                return;
            }
            path = world.isCustom() ? (world.getChallengesDir() == null ? ForgeConstants.DEFAULT_CHALLENGES_DIR : ForgeConstants.USER_QUEST_WORLD_DIR + world.getChallengesDir()) : (world.getChallengesDir() == null ? ForgeConstants.DEFAULT_CHALLENGES_DIR : ForgeConstants.QUEST_WORLD_DIR + world.getChallengesDir());
        }
        this.allChallenges = new StorageBase<QuestEventChallenge>("Quest Challenges", new QuestChallengeReader(new File(path)));
    }

    public QuestPetStorage getPetsStorage() {
        if (this.pets == null) {
            this.pets = new QuestPetStorage(new File(ForgeConstants.BAZAAR_INDEX_FILE));
        }
        return this.pets;
    }

    public int getUnlocksTokens() {
        int unlocksSpent;
        if (this.questFormat == null || !this.questFormat.canUnlockSets()) {
            return 0;
        }
        int wins = this.model.getAchievements().getWin();
        int cntLocked = this.questFormat.getLockedSets().size();
        int unlocksAvaliable = wins / FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.WINS_UNLOCK_SET);
        return unlocksAvaliable > (unlocksSpent = this.questFormat.getUnlocksUsed()) ? Math.min(unlocksAvaliable - unlocksSpent, cntLocked) : 0;
    }

    @Subscribe
    public void receiveGameEvent(GameEvent ev) {
        if (ev instanceof GameEventMulligan) {
            GameEventMulligan mev = (GameEventMulligan)ev;
            if (mev.player.getLobbyPlayer() == GamePlayerUtil.getGuiPlayer() && this.getAssets().hasItem(QuestItemType.SLEIGHT) && mev.player.getStats().getMulliganCount() < 7) {
                mev.player.drawCard();
            }
        }
    }

    public int getTurnsToUnlockChallenge() {
        int turns = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.WINS_NEW_CHALLENGE);
        if (FModel.getQuest().getAssets().hasItem(QuestItemType.ZEPPELIN)) {
            turns -= 2;
        } else if (FModel.getQuest().getAssets().hasItem(QuestItemType.MAP)) {
            --turns;
        }
        return Math.max(turns, 1);
    }

    /*
     * WARNING - void declaration
     */
    public final void regenerateChallenges() {
        QuestAchievements achievements = this.model.getAchievements();
        ArrayList<String> unlockedChallengeIds = new ArrayList<String>();
        List<String> availableChallengeIds = achievements.getCurrentChallenges();
        ArrayList<String> nonExistentIds = new ArrayList<String>();
        for (String string : availableChallengeIds) {
            if (this.getChallenges().get(string) != null) continue;
            System.out.println("Warning: removing a challenge that does not exist in the current quest world: " + string);
            nonExistentIds.add(string);
        }
        availableChallengeIds.removeAll(nonExistentIds);
        int maxChallenges = achievements.getWin() / this.getTurnsToUnlockChallenge() - achievements.getChallengesPlayed();
        if (maxChallenges > 5) {
            maxChallenges = 5;
        }
        if (achievements.getCurrentChallenges().size() < maxChallenges) {
            void var6_10;
            for (QuestEventChallenge qc : this.allChallenges) {
                if (qc.getWinsReqd() > achievements.getWin() || !qc.isRepeatable() && achievements.getLockedChallenges().contains(qc.getId()) || availableChallengeIds.contains(qc.getId())) continue;
                unlockedChallengeIds.add(qc.getId());
            }
            Collections.shuffle(unlockedChallengeIds);
            maxChallenges = Math.min(maxChallenges, unlockedChallengeIds.size());
            int n = availableChallengeIds.size();
            while (var6_10 < maxChallenges) {
                availableChallengeIds.add((String)unlockedChallengeIds.get((int)var6_10));
                ++var6_10;
            }
        }
        achievements.setCurrentChallenges(availableChallengeIds);
        this.save();
    }

    public CardEdition getDefaultLandSet() {
        List<String> availableEditionCodes = this.questFormat != null ? this.questFormat.getAllowedSetCodes() : Lists.newArrayList(FModel.getMagicDb().getEditions().getItemNames());
        ArrayList<CardEdition> availableEditions = new ArrayList<CardEdition>();
        for (String s2 : availableEditionCodes) {
            availableEditions.add(FModel.getMagicDb().getEditions().get(s2));
        }
        CardEdition randomLandSet = CardEdition.Predicates.getRandomSetWithAllBasicLands(availableEditions);
        return randomLandSet == null ? FModel.getMagicDb().getEditions().get("ZEN") : randomLandSet;
    }

    public String getCurrentDeck() {
        return this.model.currentDeck;
    }

    public void setCurrentDeck(String s2) {
        this.model.currentDeck = s2;
    }

    public DeckConstructionRules getDeckConstructionRules() {
        if (this.model == null) {
            return null;
        }
        return this.model.deckConstructionRules;
    }
}

