/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.mana.ManaCostShard;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.deck.generation.DeckGenerator2Color;
import forge.deck.generation.DeckGenerator3Color;
import forge.deck.generation.DeckGenerator5Color;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.DeckGeneratorMonoColor;
import forge.deck.generation.IDeckGenPool;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.util.SOptionPane;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.IHasSkinProp;
import forge.model.FModel;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;

public class ConquestUtil {
    public static final AEtherFilter[] COLOR_FILTERS = new AEtherFilter[]{AEtherFilter.C, AEtherFilter.W, AEtherFilter.U, AEtherFilter.B, AEtherFilter.R, AEtherFilter.G, AEtherFilter.WU, AEtherFilter.WB, AEtherFilter.UB, AEtherFilter.UR, AEtherFilter.BR, AEtherFilter.BG, AEtherFilter.RG, AEtherFilter.RW, AEtherFilter.GW, AEtherFilter.GU, AEtherFilter.WUB, AEtherFilter.WBG, AEtherFilter.UBR, AEtherFilter.URW, AEtherFilter.BRG, AEtherFilter.BGU, AEtherFilter.RGW, AEtherFilter.RWB, AEtherFilter.GWU, AEtherFilter.GUR, AEtherFilter.WUBR, AEtherFilter.WUBG, AEtherFilter.WURG, AEtherFilter.WBRG, AEtherFilter.UBRG, AEtherFilter.WUBRG};
    public static final AEtherFilter[] TYPE_FILTERS = new AEtherFilter[]{AEtherFilter.CREATURE, AEtherFilter.NONCREATURE_PERMANENT, AEtherFilter.INSTANT_SORCERY};
    public static final AEtherFilter[] RARITY_FILTERS = new AEtherFilter[]{AEtherFilter.COMMON, AEtherFilter.UNCOMMON, AEtherFilter.RARE, AEtherFilter.MYTHIC};
    public static final AEtherFilter[] CMC_FILTERS = new AEtherFilter[]{AEtherFilter.CMC_LOW, AEtherFilter.CMC_LOW_MID, AEtherFilter.CMC_MID_HIGH, AEtherFilter.CMC_HIGH};

    private ConquestUtil() {
    }

    public static Deck generateDeck(PaperCard commander, IDeckGenPool pool, boolean forAi) {
        DeckGeneratorBase gen;
        ColorSet colorID = commander.getRules().getColorIdentity();
        ArrayList<String> colors = Lists.newArrayList();
        if (colorID.hasWhite()) {
            colors.add("White");
        }
        if (colorID.hasBlue()) {
            colors.add("Blue");
        }
        if (colorID.hasBlack()) {
            colors.add("Black");
        }
        if (colorID.hasRed()) {
            colors.add("Red");
        }
        if (colorID.hasGreen()) {
            colors.add("Green");
        }
        block0 : switch (colors.size()) {
            case 0: {
                gen = new DeckGeneratorMonoColor(pool, DeckFormat.PlanarConquest, "");
                break;
            }
            case 1: {
                gen = new DeckGeneratorMonoColor(pool, DeckFormat.PlanarConquest, (String)colors.get(0));
                break;
            }
            case 2: {
                gen = new DeckGenerator2Color(pool, DeckFormat.PlanarConquest, (String)colors.get(0), (String)colors.get(1));
                break;
            }
            case 3: {
                gen = new DeckGenerator3Color(pool, DeckFormat.PlanarConquest, (String)colors.get(0), (String)colors.get(1), (String)colors.get(2));
                break;
            }
            case 4: {
                int colorSubset = MyRandom.getRandom().nextInt(4);
                switch (colorSubset) {
                    case 0: {
                        gen = new DeckGenerator3Color(pool, DeckFormat.PlanarConquest, (String)colors.get(0), (String)colors.get(1), (String)colors.get(2));
                        break block0;
                    }
                    case 1: {
                        gen = new DeckGenerator3Color(pool, DeckFormat.PlanarConquest, (String)colors.get(0), (String)colors.get(1), (String)colors.get(3));
                        break block0;
                    }
                    case 2: {
                        gen = new DeckGenerator3Color(pool, DeckFormat.PlanarConquest, (String)colors.get(0), (String)colors.get(2), (String)colors.get(3));
                        break block0;
                    }
                    case 3: {
                        gen = new DeckGenerator3Color(pool, DeckFormat.PlanarConquest, (String)colors.get(1), (String)colors.get(2), (String)colors.get(3));
                        break block0;
                    }
                }
                gen = new DeckGenerator3Color(pool, DeckFormat.PlanarConquest, (String)colors.get(0), (String)colors.get(1), (String)colors.get(2));
                break;
            }
            case 5: {
                gen = new DeckGenerator5Color(pool, DeckFormat.PlanarConquest);
                break;
            }
            default: {
                return null;
            }
        }
        gen.setSingleton(true);
        CardPool cards = ((DeckGeneratorBase)gen).getDeck(40, forAi);
        Deck deck = new Deck(commander.getName());
        deck.setDirectory("generated/conquest");
        deck.getMain().addAll(cards);
        deck.getOrCreate(DeckSection.Commander).add(commander);
        return deck;
    }

    public static String promptForName() {
        String name;
        while (true) {
            if ((name = SOptionPane.showInputDialog(Localizer.getInstance().getMessage("lblHistoriiansWillRecallYourConquestAs", new Object[0]), Localizer.getInstance().getMessage("lblConquestName", new Object[0]))) == null) {
                return null;
            }
            if ((name = QuestUtil.cleanString(name)).isEmpty()) {
                SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblPleaseSpecifyConquestName", new Object[0]));
                continue;
            }
            if (!FileUtil.doesFileExist(ForgeConstants.CONQUEST_SAVE_DIR + name + ".dat")) break;
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblConquestNameExistsPleasePickAnotherName", new Object[0]));
        }
        return name;
    }

    public static CardPool getAvailablePool(Deck deck) {
        HashSet<PaperCard> availableCards = Sets.newHashSet();
        ConquestData model = FModel.getConquest().getModel();
        for (PaperCard pc : model.getUnlockedCards()) {
            availableCards.add(pc);
        }
        for (PaperCard pc : model.getExiledCards()) {
            availableCards.remove(pc);
        }
        for (Object e : deck.getMain()) {
            availableCards.remove(e.getKey());
        }
        int colorIdentity = 0;
        for (PaperCard commander : deck.getCommanders()) {
            colorIdentity = (byte)(colorIdentity | commander.getRules().getColorIdentity().getColor());
            availableCards.remove(commander);
        }
        if (colorIdentity != 31) {
            Predicate<PaperCard> pred = DeckFormat.Commander.isLegalCardForCommanderPredicate(deck.getCommanders());
            availableCards.retainAll(Lists.newArrayList(Iterables.filter(availableCards, pred)));
        }
        CardPool pool = new CardPool();
        pool.addAllFlat(availableCards);
        return pool;
    }

    public static ConquestPlane getPlaneByName(String planeName) {
        for (ConquestPlane plane : FModel.getPlanes()) {
            if (!plane.getName().equals(planeName)) continue;
            return plane;
        }
        return null;
    }

    public static void setPlaneTemporarilyAccessible(String planeName, boolean accessible) {
        ConquestPlane plane = ConquestUtil.getPlaneByName(planeName);
        if (plane != null && accessible != !plane.isUnreachable()) {
            plane.setTemporarilyReachable(accessible);
        } else {
            System.err.println("Could not find plane to set the accessibility flag: " + planeName);
        }
    }

    public static Iterable<PaperCard> getStartingPlaneswalkerOptions(PaperCard startingCommander) {
        byte colorIdentity = startingCommander.getRules().getColorIdentity().getColor();
        ArrayList selected = Lists.newArrayList();
        return Iterables.filter(FModel.getMagicDb().getCommonCards().getAllNonPromosNonReprintsNoAlt(), card -> {
            boolean allowed;
            if (selected.contains(card.getName())) {
                return false;
            }
            CardRules rules = card.getRules();
            boolean bl = allowed = rules.getType().isPlaneswalker() && !card.getName().equals(startingCommander.getName()) && rules.getColorIdentity().hasNoColorsExcept(colorIdentity);
            if (allowed) {
                selected.add(card.getName());
                return true;
            }
            return false;
        });
    }

    public static int getShardValue(PaperCard card, ConquestPreferences.CQPref baseValuePref) {
        return ConquestUtil.getShardValue(card.getRarity(), baseValuePref);
    }

    public static int getShardValue(CardRarity rarity, ConquestPreferences.CQPref baseValuePref) {
        ConquestPreferences prefs = FModel.getConquestPreferences();
        int baseValue = prefs.getPrefInt(baseValuePref);
        switch (rarity) {
            case Common: {
                return baseValue;
            }
            case Uncommon: {
                return Math.round((float)baseValue * (float)prefs.getPrefInt(ConquestPreferences.CQPref.AETHER_UNCOMMON_MULTIPLIER));
            }
            case Rare: 
            case Special: {
                return Math.round((float)baseValue * (float)prefs.getPrefInt(ConquestPreferences.CQPref.AETHER_RARE_MULTIPLIER));
            }
            case MythicRare: {
                return Math.round((float)baseValue * (float)prefs.getPrefInt(ConquestPreferences.CQPref.AETHER_MYTHIC_MULTIPLIER));
            }
        }
        return 0;
    }

    public static AEtherFilter getColorFilter(ColorSet color) {
        StringBuilder name = new StringBuilder();
        for (ManaCostShard s2 : color.getOrderedShards()) {
            name.append(s2.toString());
        }
        name = new StringBuilder(name.toString().replaceAll("[{}]", ""));
        try {
            return AEtherFilter.valueOf(name.toString());
        }
        catch (Exception e) {
            System.err.println("No color filter with name " + name);
            return AEtherFilter.WUBRG;
        }
    }

    public static void updateRarityFilterOdds() {
        ConquestPreferences prefs = FModel.getConquestPreferences();
        EnumMap<CardRarity, Double> odds = Maps.newEnumMap(CardRarity.class);
        if (prefs.getPrefBoolean(ConquestPreferences.CQPref.AETHER_USE_DEFAULT_RARITY_ODDS)) {
            odds.put(CardRarity.Common, 1.0);
            odds.put(CardRarity.Uncommon, 0.17);
            odds.put(CardRarity.Rare, 0.03);
            odds.put(CardRarity.MythicRare, 0.005);
        } else {
            double commonsPerBooster = prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTER_COMMONS);
            double uncommonPerBooster = prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTER_UNCOMMONS);
            double raresPerBooster = prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTER_RARES);
            double mythicsPerBooster = raresPerBooster / (double)prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTERS_PER_MYTHIC);
            odds.put(CardRarity.Common, 1.0);
            odds.put(CardRarity.Uncommon, uncommonPerBooster / commonsPerBooster);
            odds.put(CardRarity.Rare, raresPerBooster / commonsPerBooster);
            odds.put(CardRarity.MythicRare, mythicsPerBooster / commonsPerBooster);
        }
        for (AEtherFilter filter : RARITY_FILTERS) {
            filter.caption = ((RarityFilter)filter.predicate).updateOdds(odds);
        }
    }

    private static class CMCFilter
    implements Predicate<PaperCard> {
        private final int cmcMin;
        private final int cmcMax;

        private CMCFilter(int cmcMin0, int cmcMax0) {
            this.cmcMin = cmcMin0;
            this.cmcMax = cmcMax0;
        }

        @Override
        public boolean apply(PaperCard card) {
            int cardCmc = card.getRules().getManaCost().getCMC();
            if (cardCmc < this.cmcMin) {
                return false;
            }
            return this.cmcMax == -1 || cardCmc <= this.cmcMax;
        }
    }

    private static class RarityFilter
    implements Predicate<PaperCard> {
        private final Map<CardRarity, Double> rarityOdds = Maps.newEnumMap(CardRarity.class);

        private RarityFilter(Iterable<CardRarity> rarities0) {
            for (CardRarity rarity : rarities0) {
                this.rarityOdds.put(rarity, 0.0);
            }
        }

        private String updateOdds(Map<CardRarity, Double> oddsLookup) {
            double baseOdds = 0.0;
            double remainingOdds = 1.0;
            CardRarity baseRarity = null;
            StringBuilder caption = new StringBuilder();
            for (CardRarity rarity : this.rarityOdds.keySet()) {
                Double odds = oddsLookup.get((Object)rarity);
                if (odds == null) continue;
                if (baseRarity == null) {
                    baseRarity = rarity;
                    baseOdds = odds;
                    continue;
                }
                odds = odds / baseOdds;
                remainingOdds -= odds.doubleValue();
                double rounded = (double)Math.round(1000.0 * odds) / 10.0;
                String display = rounded < 1.0 ? Double.toString(rounded) : Long.toString(Math.round(rounded));
                caption.append(", ").append(rarity.getLongName()).append(" (").append(display).append("%)");
                this.rarityOdds.put(rarity, odds);
            }
            caption.insert(0, baseRarity.getLongName() + " (" + Math.round(1000.0 * remainingOdds) / 10L + "%)");
            this.rarityOdds.put(baseRarity, remainingOdds);
            return caption.toString();
        }

        @Override
        public boolean apply(PaperCard card) {
            return this.rarityOdds.containsKey((Object)card.getRarity());
        }
    }

    private static class TypeFilter
    implements Predicate<PaperCard> {
        private final Iterable<CardType.CoreType> types;
        private final Iterable<CardType.CoreType> nonTypes;

        private TypeFilter(Iterable<CardType.CoreType> types0) {
            this.types = types0;
            this.nonTypes = null;
        }

        private TypeFilter(Iterable<CardType.CoreType> types0, Iterable<CardType.CoreType> nonTypes0) {
            this.types = types0;
            this.nonTypes = nonTypes0;
        }

        @Override
        public boolean apply(PaperCard card) {
            CardType cardType = card.getRules().getType();
            if (this.nonTypes != null) {
                for (CardType.CoreType nonType : this.nonTypes) {
                    if (!cardType.hasType(nonType)) continue;
                    return false;
                }
            }
            for (CardType.CoreType type : this.types) {
                if (!cardType.hasType(type)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ColorFilter
    implements Predicate<PaperCard> {
        private final ColorSet color;

        private ColorFilter(int colorMask0) {
            this.color = ColorSet.fromMask(colorMask0);
        }

        @Override
        public boolean apply(PaperCard card) {
            return card.getRules().getColorIdentity().hasNoColorsExcept(this.color);
        }
    }

    public static enum AEtherFilter implements IHasSkinProp
    {
        C(null, new ColorFilter(0), "Playable in {C}"),
        W(null, new ColorFilter(1), "Playable in {W}"),
        U(null, new ColorFilter(2), "Playable in {U}"),
        B(null, new ColorFilter(4), "Playable in {B}"),
        R(null, new ColorFilter(8), "Playable in {R}"),
        G(null, new ColorFilter(16), "Playable in {G}"),
        WU(null, new ColorFilter(3), "Playable in {W}{U}"),
        WB(null, new ColorFilter(5), "Playable in {W}{B}"),
        UB(null, new ColorFilter(6), "Playable in {U}{B}"),
        UR(null, new ColorFilter(10), "Playable in {U}{R}"),
        BR(null, new ColorFilter(12), "Playable in {B}{R}"),
        BG(null, new ColorFilter(20), "Playable in {B}{G}"),
        RG(null, new ColorFilter(24), "Playable in {R}{G}"),
        RW(null, new ColorFilter(9), "Playable in {R}{W}"),
        GW(null, new ColorFilter(17), "Playable in {G}{W}"),
        GU(null, new ColorFilter(18), "Playable in {G}{U}"),
        WUB(null, new ColorFilter(7), "Playable in {W}{U}{B}"),
        WBG(null, new ColorFilter(21), "Playable in {W}{B}{G}"),
        UBR(null, new ColorFilter(14), "Playable in {U}{B}{R}"),
        URW(null, new ColorFilter(11), "Playable in {U}{R}{W}"),
        BRG(null, new ColorFilter(28), "Playable in {B}{R}{G}"),
        BGU(null, new ColorFilter(22), "Playable in {B}{G}{U}"),
        RGW(null, new ColorFilter(25), "Playable in {R}{G}{W}"),
        RWB(null, new ColorFilter(13), "Playable in {R}{W}{B}"),
        GWU(null, new ColorFilter(19), "Playable in {G}{W}{U}"),
        GUR(null, new ColorFilter(26), "Playable in {G}{U}{R}"),
        WUBR(null, new ColorFilter(15), "Playable in {W}{U}{B}{R}"),
        WUBG(null, new ColorFilter(23), "Playable in {W}{U}{B}{G}"),
        WURG(null, new ColorFilter(27), "Playable in {W}{U}{R}{G}"),
        WBRG(null, new ColorFilter(29), "Playable in {W}{B}{R}{G}"),
        UBRG(null, new ColorFilter(30), "Playable in {U}{B}{R}{G}"),
        WUBRG(null, new ColorFilter(31), "Playable in {W}{U}{B}{R}{G}"),
        CREATURE(FSkinProp.IMG_CREATURE, new TypeFilter(EnumSet.of(CardType.CoreType.Creature)), "Creature"),
        NONCREATURE_PERMANENT(FSkinProp.IMG_ENCHANTMENT, new TypeFilter(EnumSet.of(CardType.CoreType.Artifact, CardType.CoreType.Enchantment, CardType.CoreType.Planeswalker, CardType.CoreType.Land), EnumSet.of(CardType.CoreType.Creature)), "Noncreature Permanent"),
        INSTANT_SORCERY(FSkinProp.IMG_SORCERY, new TypeFilter(EnumSet.of(CardType.CoreType.Instant, CardType.CoreType.Sorcery)), "Instant or Sorcery"),
        COMMON(FSkinProp.IMG_PW_BADGE_COMMON, new RarityFilter(EnumSet.of(CardRarity.Common, CardRarity.Uncommon, CardRarity.Rare, CardRarity.Special, CardRarity.MythicRare)), "Common"),
        UNCOMMON(FSkinProp.IMG_PW_BADGE_UNCOMMON, new RarityFilter(EnumSet.of(CardRarity.Uncommon, CardRarity.Rare, CardRarity.Special, CardRarity.MythicRare)), "Uncommon"),
        RARE(FSkinProp.IMG_PW_BADGE_RARE, new RarityFilter(EnumSet.of(CardRarity.Rare, CardRarity.Special, CardRarity.MythicRare)), "Rare"),
        MYTHIC(FSkinProp.IMG_PW_BADGE_MYTHIC, new RarityFilter(EnumSet.of(CardRarity.MythicRare)), "Mythic Rare (100%)"),
        CMC_LOW(FSkinProp.IMG_CMC_LOW, new CMCFilter(0, 3), "Mana Value 0-3"),
        CMC_LOW_MID(FSkinProp.IMG_CMC_LOW_MID, new CMCFilter(2, 5), "Mana Value 2-5"),
        CMC_MID_HIGH(FSkinProp.IMG_CMC_MID_HIGH, new CMCFilter(4, 7), "Mana Value 4-7"),
        CMC_HIGH(FSkinProp.IMG_CMC_HIGH, new CMCFilter(6, -1), "Mana Value 6+");

        private final FSkinProp skinProp;
        private final Predicate<PaperCard> predicate;
        private String caption;

        private AEtherFilter(FSkinProp skinProp0, Predicate<PaperCard> predicate0, String caption0) {
            this.skinProp = skinProp0;
            this.predicate = predicate0;
            this.caption = caption0;
        }

        @Override
        public FSkinProp getSkinProp() {
            return this.skinProp;
        }

        public Predicate<PaperCard> getPredicate() {
            return this.predicate;
        }

        public ColorSet getColor() {
            if (this.predicate instanceof ColorFilter) {
                return ((ColorFilter)this.predicate).color;
            }
            return null;
        }

        public CardRarity getRarity() {
            return this.getRarity(0.0);
        }

        public CardRarity getRarity(double random) {
            if (this.predicate instanceof RarityFilter) {
                double total = 0.0;
                CardRarity rarity = null;
                Map rarityOdds = ((RarityFilter)this.predicate).rarityOdds;
                for (Map.Entry entry : rarityOdds.entrySet()) {
                    rarity = (CardRarity)((Object)entry.getKey());
                    if (!(random < (total += ((Double)entry.getValue()).doubleValue()))) continue;
                    return rarity;
                }
                return rarity;
            }
            return null;
        }

        public String toString() {
            return this.caption;
        }
    }
}

