/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.gamemodes.planarconquest.ConquestUtil;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.PreferencesStore;
import java.io.Serializable;

public class ConquestPreferences
extends PreferencesStore<CQPref>
implements Serializable {
    public ConquestPreferences() {
        super(ForgeConstants.CONQUEST_PREFS_FILE, CQPref.class);
    }

    @Override
    public void save() {
        super.save();
        ConquestUtil.updateRarityFilterOdds();
    }

    protected CQPref[] getEnumValues() {
        return CQPref.values();
    }

    @Override
    protected CQPref valueOf(String name) {
        try {
            return CQPref.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected String getPrefDefault(CQPref key) {
        return key.getDefault();
    }

    public String validatePreference(CQPref qpref, int val) {
        switch (qpref) {
            case BOOSTER_COMMONS: {
                if (val + this.getPrefInt(CQPref.BOOSTER_UNCOMMONS) + this.getPrefInt(CQPref.BOOSTER_RARES) <= 15) break;
                return "Booster packs must have maximum 15 cards.";
            }
            case BOOSTER_UNCOMMONS: {
                if (val + this.getPrefInt(CQPref.BOOSTER_COMMONS) + this.getPrefInt(CQPref.BOOSTER_RARES) <= 15) break;
                return "Booster packs must have maximum 15 cards.";
            }
            case BOOSTER_RARES: {
                if (val + this.getPrefInt(CQPref.BOOSTER_COMMONS) + this.getPrefInt(CQPref.BOOSTER_UNCOMMONS) <= 15) break;
                return "Booster packs must have maximum 15 cards.";
            }
            case BOOSTERS_PER_MYTHIC: {
                if (val + this.getPrefInt(CQPref.BOOSTER_COMMONS) + this.getPrefInt(CQPref.BOOSTER_UNCOMMONS) <= 15) break;
                return "Booster packs must have maximum 15 cards.";
            }
        }
        return null;
    }

    public static enum CQPref {
        CURRENT_CONQUEST("DEFAULT"),
        AETHER_BASE_DUPLICATE_VALUE("100"),
        AETHER_BASE_EXILE_VALUE("75"),
        AETHER_BASE_RETRIEVE_COST("150"),
        AETHER_BASE_PULL_COST("200"),
        AETHER_UNCOMMON_MULTIPLIER("3"),
        AETHER_RARE_MULTIPLIER("10"),
        AETHER_MYTHIC_MULTIPLIER("25"),
        AETHER_START_SHARDS("3000"),
        AETHER_WHEEL_SHARDS("1000"),
        AETHER_USE_DEFAULT_RARITY_ODDS("true"),
        BOOSTER_COMMONS("11"),
        BOOSTER_UNCOMMONS("3"),
        BOOSTER_RARES("1"),
        BOOSTERS_PER_MYTHIC("8"),
        PLANESWALK_CONQUER_EMBLEMS("1"),
        PLANESWALK_WHEEL_EMBLEMS("5"),
        PLANESWALK_FIRST_UNLOCK("5"),
        PLANESWALK_UNLOCK_INCREASE("5"),
        CHAOS_BATTLE_WINS_MEDIUMAI("2"),
        CHAOS_BATTLE_WINS_HARDAI("5"),
        CHAOS_BATTLE_WINS_EXPERTAI("10");

        private final String strDefaultVal;

        private CQPref(String s0) {
            this.strDefaultVal = s0;
        }

        public String getDefault() {
            return this.strDefaultVal;
        }
    }
}

