/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.gamemodes.planarconquest.ConquestBattle;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestEvent;
import forge.gamemodes.planarconquest.ConquestLocation;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.XmlReader;
import forge.util.XmlWriter;

public class ConquestPlaneData
implements XmlWriter.IXmlWritable {
    private final ConquestEvent.ConquestEventRecord[] eventResults;
    private ConquestLocation location;

    public ConquestPlaneData(ConquestPlane plane0) {
        this.location = new ConquestLocation(plane0, 0, 0, 0);
        this.eventResults = new ConquestEvent.ConquestEventRecord[plane0.getEventCount()];
    }

    public ConquestPlaneData(XmlReader xml) {
        this.location = xml.read("location", ConquestLocation.class);
        this.eventResults = new ConquestEvent.ConquestEventRecord[this.location.getPlane().getEventCount()];
        xml.read("eventResults", this.eventResults, ConquestEvent.ConquestEventRecord.class);
    }

    @Override
    public void saveToXml(XmlWriter xml) {
        xml.write("location", this.location);
        xml.write("eventResults", this.eventResults);
    }

    public boolean hasConquered(ConquestLocation loc) {
        return this.hasConquered(loc.getEventIndex());
    }

    public boolean hasConquered(int regionIndex, int row, int col) {
        return this.hasConquered(this.location.getPlane().getEventIndex(regionIndex, row, col));
    }

    private boolean hasConquered(int eventIndex) {
        ConquestEvent.ConquestEventRecord result = this.eventResults[eventIndex];
        return result != null && result.hasConquered();
    }

    public ConquestEvent.ConquestEventRecord getEventRecord(ConquestLocation loc) {
        return this.eventResults[loc.getEventIndex()];
    }

    public ConquestEvent.ConquestEventRecord getEventRecord(int regionIndex, int row, int col) {
        return this.eventResults[this.location.getPlane().getEventIndex(regionIndex, row, col)];
    }

    private ConquestEvent.ConquestEventRecord getOrCreateResult(ConquestBattle event) {
        int eventIndex = event.getLocation().getEventIndex();
        ConquestEvent.ConquestEventRecord result = this.eventResults[eventIndex];
        if (result == null) {
            this.eventResults[eventIndex] = result = new ConquestEvent.ConquestEventRecord();
        }
        return result;
    }

    public ConquestLocation getLocation() {
        return this.location;
    }

    public void setLocation(ConquestLocation location0) {
        this.location = location0;
    }

    public void addWin(ConquestBattle event) {
        this.getOrCreateResult(event).addWin(event.getTier());
    }

    public void addLoss(ConquestBattle event) {
        this.getOrCreateResult(event).addLoss(event.getTier());
    }

    public int getConqueredCount() {
        int conquered = 0;
        for (int i = 0; i < this.eventResults.length; ++i) {
            if (!this.hasConquered(i)) continue;
            ++conquered;
        }
        return conquered;
    }

    public int getTotalWins() {
        int wins = 0;
        for (ConquestEvent.ConquestEventRecord result : this.eventResults) {
            if (result == null) continue;
            wins += result.getTotalWins();
        }
        return wins;
    }

    public int getTotalLosses() {
        int losses = 0;
        for (ConquestEvent.ConquestEventRecord result : this.eventResults) {
            if (result == null) continue;
            losses += result.getTotalLosses();
        }
        return losses;
    }

    public int getUnlockedCardCount() {
        int count = 0;
        ConquestData model = FModel.getConquest().getModel();
        for (PaperCard pc : this.location.getPlane().getCardPool().getAllCards()) {
            if (!model.hasUnlockedCard(pc)) continue;
            ++count;
        }
        return count;
    }
}

