/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.card.CardDb;
import forge.card.CardEdition;
import forge.deck.generation.DeckGenPool;
import forge.game.GameType;
import forge.gamemodes.planarconquest.ConquestAwardPool;
import forge.gamemodes.planarconquest.ConquestEvent;
import forge.gamemodes.planarconquest.ConquestLocation;
import forge.gamemodes.planarconquest.ConquestRegion;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.FileUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import forge.util.storage.StorageReaderFile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConquestPlane {
    private final String name;
    private final String directory;
    private final String description;
    private boolean unreachable;
    private final int rowsPerRegion;
    private final int cols;
    private FCollection<ConquestRegion> regions;
    private DeckGenPool cardPool;
    private FCollection<PaperCard> planeCards;
    private FCollection<PaperCard> commanders;
    private ConquestAwardPool awardPool;
    private ConquestEvent[] events;

    private ConquestPlane(String name0, String description0, int regionSize0, boolean unreachable0) {
        this.name = name0;
        this.directory = ForgeConstants.CONQUEST_PLANES_DIR + this.name + ForgeConstants.PATH_SEPARATOR;
        this.description = description0;
        this.unreachable = unreachable0;
        switch (regionSize0) {
            case 9: {
                this.rowsPerRegion = 3;
                this.cols = 3;
                break;
            }
            case 6: {
                this.rowsPerRegion = 2;
                this.cols = 3;
                break;
            }
            default: {
                System.out.println(regionSize0 + " is not a valid region size");
                this.rowsPerRegion = 3;
                this.cols = 3;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUnreachable() {
        return this.unreachable;
    }

    public void setTemporarilyReachable(boolean reachable) {
        this.unreachable = !reachable;
    }

    public FCollectionView<ConquestRegion> getRegions() {
        this.ensureRegionsLoaded();
        return this.regions;
    }

    public ConquestEvent getEvent(ConquestLocation loc) {
        this.ensureRegionsLoaded();
        return this.events[loc.getEventIndex()];
    }

    public int getEventCount() {
        this.ensureRegionsLoaded();
        return this.regions.size() * this.rowsPerRegion * this.cols;
    }

    public int getRowsPerRegion() {
        return this.rowsPerRegion;
    }

    public int getCols() {
        return this.cols;
    }

    public int getEventIndex(int regionIndex, int row, int col) {
        return regionIndex * this.rowsPerRegion * this.cols + col * this.rowsPerRegion + row;
    }

    public DeckGenPool getCardPool() {
        this.ensureRegionsLoaded();
        return this.cardPool;
    }

    public FCollectionView<PaperCard> getCommanders() {
        this.ensureRegionsLoaded();
        return this.commanders;
    }

    public FCollectionView<PaperCard> getPlaneCards() {
        if (this.planeCards == null) {
            this.planeCards = new FCollection();
            CardDb variantCards = FModel.getMagicDb().getVariantCards();
            List<String> planeCardNames = FileUtil.readFile(this.directory + "plane_cards.txt");
            for (String name : planeCardNames) {
                PaperCard pc = variantCards.getCard(name);
                if (pc == null && (pc = FModel.getMagicDb().getCommonCards().getCard(name)) == null) {
                    System.out.println("\"" + name + "\" does not correspond to a valid Plane card or standard Magic card!");
                    continue;
                }
                this.planeCards.add(pc);
            }
        }
        return this.planeCards;
    }

    private void ensureRegionsLoaded() {
        int eventsPerRegion;
        if (this.regions != null) {
            return;
        }
        this.regions = new FCollection<ConquestRegion>(new ConquestRegion.Reader(this));
        int eventIndex = 0;
        int regionEndIndex = eventsPerRegion = this.rowsPerRegion * this.cols;
        this.events = new ConquestEvent[this.regions.size() * eventsPerRegion];
        for (ConquestRegion region : this.regions) {
            FCollection<ConquestEvent> regionEvents = new FCollection<ConquestEvent>(new ConquestEvent.Reader(region));
            for (ConquestEvent conquestEvent : regionEvents) {
                this.events[eventIndex++] = conquestEvent;
                if (eventIndex != regionEndIndex) continue;
                break;
            }
            while (eventIndex < regionEndIndex) {
                this.events[eventIndex++] = new ConquestEvent(region, region.getName() + " - Random " + (eventIndex % eventsPerRegion + 1), null, null, EnumSet.noneOf(GameType.class), null, null);
            }
            regionEndIndex += eventsPerRegion;
        }
        this.cardPool = new DeckGenPool();
        this.commanders = new FCollection();
        CardDb commonCards = FModel.getMagicDb().getCommonCards();
        List<String> bannedCards = FileUtil.readFile(this.directory + "banned_cards.txt");
        HashSet<String> bannedCardSet = bannedCards.isEmpty() ? null : new HashSet<String>(bannedCards);
        List<String> setCodes = FileUtil.readFile(this.directory + "sets.txt");
        for (String setCode : setCodes) {
            CardEdition edition = FModel.getMagicDb().getEditions().get(setCode);
            if (edition == null) continue;
            for (CardEdition.CardInSet card : edition.getAllCardsInSet()) {
                if (bannedCardSet != null && bannedCardSet.contains(card.name)) continue;
                this.addCard(commonCards.getCard(card.name, setCode));
            }
        }
        List<String> list = FileUtil.readFile(this.directory + "cards.txt");
        for (String cardName : list) {
            this.addCard(commonCards.getCard(cardName));
        }
        Collections.sort(this.commanders);
    }

    private void addCard(PaperCard pc) {
        if (pc == null) {
            return;
        }
        this.cardPool.add(pc);
        if (pc.getRules().canBeCommander()) {
            this.commanders.add(pc);
        }
        ConquestRegion.addCard(pc, this.regions);
    }

    public String toString() {
        return this.name;
    }

    public ConquestAwardPool getAwardPool() {
        if (this.awardPool == null) {
            this.awardPool = new ConquestAwardPool(this.cardPool.getAllCards());
        }
        return this.awardPool;
    }

    public static Set<ConquestPlane> getAllPlanesOfCard(PaperCard card) {
        HashSet<ConquestPlane> planes = new HashSet<ConquestPlane>();
        for (ConquestPlane plane : FModel.getPlanes()) {
            if (!plane.cardPool.contains(card)) continue;
            planes.add(plane);
        }
        return planes;
    }

    public static class Reader
    extends StorageReaderFile<ConquestPlane> {
        public Reader(String file0) {
            super(file0, ConquestPlane::getName);
        }

        @Override
        protected ConquestPlane read(String line, int i) {
            String[] pieces;
            String name = null;
            int regionSize = 0;
            String description = null;
            boolean unreachable = false;
            block14: for (String piece : pieces = line.split("\\|")) {
                String value;
                String key;
                int idx = piece.indexOf(58);
                if (idx != -1) {
                    key = piece.substring(0, idx).trim().toLowerCase();
                    value = piece.substring(idx + 1).trim();
                } else {
                    this.alertInvalidLine(line, "Invalid plane definition.");
                    key = piece.trim().toLowerCase();
                    value = "";
                }
                switch (key) {
                    case "name": {
                        name = value;
                        continue block14;
                    }
                    case "regionsize": {
                        try {
                            regionSize = Integer.parseInt(value);
                        }
                        catch (Exception ex) {
                            System.out.println(value + " is not a valid region size");
                        }
                        continue block14;
                    }
                    case "unreachable": {
                        unreachable = true;
                        continue block14;
                    }
                    case "desc": {
                        description = value;
                        continue block14;
                    }
                    default: {
                        this.alertInvalidLine(line, "Invalid plane definition.");
                    }
                }
            }
            return new ConquestPlane(name, description, regionSize, unreachable);
        }
    }
}

