/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.gamemodes.planarconquest.ConquestEvent;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestRegion;
import forge.model.FModel;
import forge.util.XmlReader;
import forge.util.XmlWriter;
import java.util.ArrayList;
import java.util.List;

public class ConquestLocation
implements XmlWriter.IXmlWritable {
    private final ConquestPlane plane;
    private final int regionIndex;
    private final int row;
    private final int col;
    private List<ConquestLocation> neighbors;

    public ConquestLocation(ConquestPlane plane0, int regionIndex0, int row0, int col0) {
        this.plane = plane0;
        this.regionIndex = regionIndex0;
        this.row = row0;
        this.col = col0;
    }

    public ConquestLocation(XmlReader xml) {
        this.plane = FModel.getPlanes().get(xml.read("plane", "Alara"));
        this.regionIndex = xml.read("regionIndex", 0);
        this.row = xml.read("row", 0);
        this.col = xml.read("col", 0);
    }

    @Override
    public void saveToXml(XmlWriter xml) {
        xml.write("plane", this.plane.getName());
        xml.write("regionIndex", this.regionIndex);
        xml.write("row", this.row);
        xml.write("col", this.col);
    }

    public ConquestPlane getPlane() {
        return this.plane;
    }

    public ConquestRegion getRegion() {
        if (this.regionIndex == -1 || this.regionIndex == this.plane.getRegions().size()) {
            return null;
        }
        return this.plane.getRegions().get((ConquestRegion)this.regionIndex);
    }

    public int getRegionIndex() {
        return this.regionIndex;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public ConquestEvent getEvent() {
        return this.plane.getEvent(this);
    }

    public int getEventIndex() {
        return this.plane.getEventIndex(this.regionIndex, this.row, this.col);
    }

    public boolean isAt(int regionIndex0, int row0, int col0) {
        return this.regionIndex == regionIndex0 && this.row == row0 && this.col == col0;
    }

    public List<ConquestLocation> getNeighbors() {
        if (this.neighbors == null) {
            this.neighbors = ConquestLocation.getNeighbors(this.plane, this.regionIndex, this.row, this.col);
        }
        return this.neighbors;
    }

    public static List<ConquestLocation> getNeighbors(ConquestPlane plane0, int regionIndex0, int row0, int col0) {
        int regionCount = plane0.getRegions().size();
        ArrayList<ConquestLocation> locations = new ArrayList<ConquestLocation>();
        if (row0 < plane0.getRowsPerRegion() - 1) {
            locations.add(new ConquestLocation(plane0, regionIndex0, row0 + 1, col0));
        } else if (regionIndex0 < regionCount - 1) {
            locations.add(new ConquestLocation(plane0, regionIndex0 + 1, 0, col0));
        }
        if (row0 > 0) {
            locations.add(new ConquestLocation(plane0, regionIndex0, row0 - 1, col0));
        } else if (regionIndex0 > 0) {
            locations.add(new ConquestLocation(plane0, regionIndex0 - 1, plane0.getRowsPerRegion() - 1, col0));
        }
        if (col0 > 0) {
            locations.add(new ConquestLocation(plane0, regionIndex0, row0, col0 - 1));
        }
        if (col0 < plane0.getCols() - 1) {
            locations.add(new ConquestLocation(plane0, regionIndex0, row0, col0 + 1));
        }
        return locations;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            ConquestLocation loc = (ConquestLocation)obj;
            return loc.plane == this.plane && loc.regionIndex == this.regionIndex && loc.row == this.row && loc.col == this.col;
        }
        catch (Exception e) {
            return false;
        }
    }
}

