/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.LobbyPlayer;
import forge.deck.Deck;
import forge.deck.io.DeckSerializer;
import forge.game.GameType;
import forge.gamemodes.planarconquest.ConquestBattle;
import forge.gamemodes.planarconquest.ConquestLocation;
import forge.gamemodes.planarconquest.ConquestRecord;
import forge.gamemodes.planarconquest.ConquestRegion;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gui.interfaces.IGuiGame;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.XmlReader;
import forge.util.XmlWriter;
import forge.util.collect.FCollectionReader;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;

public class ConquestEvent {
    private final ConquestRegion region;
    private final String name;
    private final String description;
    private final String deckPath;
    private final Set<GameType> variants;
    private final String avatar;
    private final String tempUnlock;
    private PaperCard avatarCard;
    private Deck deck;

    public ConquestEvent(ConquestRegion region0, String name0, String description0, String deckPath0, Set<GameType> variants0, String avatar0, String tempUnlock0) {
        this.region = region0;
        this.name = name0;
        this.description = description0;
        this.deckPath = deckPath0;
        this.variants = variants0;
        this.avatar = avatar0;
        this.tempUnlock = tempUnlock0;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Deck getDeck() {
        if (this.deck == null) {
            File deckFile;
            if (this.deckPath != null && (deckFile = new File(this.deckPath)).exists()) {
                this.deck = DeckSerializer.fromFile(deckFile);
            }
            if (this.deck == null || this.deck.isEmpty()) {
                PaperCard commander = this.getAvatarCard();
                if (commander == null) {
                    commander = Aggregates.random(this.region.getCommanders());
                }
                this.deck = ConquestUtil.generateDeck(commander, this.region.getCardPool(), true);
            }
        }
        return this.deck;
    }

    public Set<GameType> getVariants() {
        return this.variants;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getTemporaryUnlock() {
        return this.tempUnlock;
    }

    public PaperCard getAvatarCard() {
        if (this.avatarCard == null && this.avatar != null) {
            this.avatarCard = this.region.getPlane().getCardPool().getCard(this.avatar);
            if (this.avatarCard == null) {
                this.avatarCard = FModel.getMagicDb().getCommonCards().getCard(this.avatar);
                if (this.avatarCard == null) {
                    this.avatarCard = FModel.getMagicDb().getVariantCards().getCard(this.avatar);
                }
            }
        }
        return this.avatarCard;
    }

    public String getOpponentName() {
        if (this.avatar == null) {
            return this.name;
        }
        String name = this.avatar;
        int idx = name.indexOf(44);
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        return name;
    }

    public ConquestBattle createBattle(ConquestLocation location0, int tier0) {
        return new ConquestEventBattle(location0, tier0);
    }

    public static enum ChaosWheelOutcome {
        BOOSTER,
        DOUBLE_BOOSTER,
        SHARDS,
        DOUBLE_SHARDS,
        PLANESWALK,
        CHAOS;

        private static final ChaosWheelOutcome[] wheelSpots;
        private static final float ANGLE_PER_SPOT;

        public static ChaosWheelOutcome getWheelOutcome(float wheelRotation) {
            if (wheelRotation < 0.0f) {
                wheelRotation += 360.0f;
            }
            int spot = (int)(wheelRotation / ANGLE_PER_SPOT);
            return wheelSpots[spot];
        }

        static {
            wheelSpots = new ChaosWheelOutcome[]{CHAOS, BOOSTER, SHARDS, DOUBLE_BOOSTER, PLANESWALK, BOOSTER, DOUBLE_SHARDS, BOOSTER};
            ANGLE_PER_SPOT = 360.0f / (float)wheelSpots.length;
        }
    }

    public static class ConquestEventRecord
    implements XmlWriter.IXmlWritable {
        private final ConquestRecord[] tiers = new ConquestRecord[4];

        public ConquestEventRecord() {
        }

        public ConquestEventRecord(XmlReader xml) {
            xml.read("tiers", this.tiers, ConquestRecord.class);
        }

        @Override
        public void saveToXml(XmlWriter xml) {
            xml.write("tiers", this.tiers);
        }

        public boolean hasConquered() {
            ConquestRecord record = this.tiers[0];
            return record != null && record.getWins() > 0;
        }

        public int getTotalWins() {
            int wins = 0;
            for (ConquestRecord record : this.tiers) {
                if (record == null) continue;
                wins += record.getWins();
            }
            return wins;
        }

        public int getTotalLosses() {
            int losses = 0;
            for (ConquestRecord record : this.tiers) {
                if (record == null) continue;
                losses += record.getLosses();
            }
            return losses;
        }

        public int getWins(int tier) {
            ConquestRecord record = this.tiers[tier];
            return record != null ? record.getWins() : 0;
        }

        public int getLosses(int tier) {
            ConquestRecord record = this.tiers[tier];
            return record != null ? record.getLosses() : 0;
        }

        private ConquestRecord getOrCreateRecord(int tier) {
            ConquestRecord record = this.tiers[tier];
            if (record == null) {
                this.tiers[tier] = record = new ConquestRecord();
            }
            return record;
        }

        public void addWin(int tier) {
            this.getOrCreateRecord(tier).addWin();
        }

        public void addLoss(int tier) {
            this.getOrCreateRecord(tier).addLoss();
        }

        public int getHighestConqueredTier() {
            for (int i = this.tiers.length - 1; i >= 0; --i) {
                ConquestRecord record = this.tiers[i];
                if (record == null || record.getWins() <= 0) continue;
                return i;
            }
            return -1;
        }
    }

    public class ConquestEventBattle
    extends ConquestBattle {
        private ConquestEventBattle(ConquestLocation location0, int tier0) {
            super(location0, tier0);
        }

        @Override
        protected Deck buildOpponentDeck() {
            return ConquestEvent.this.getDeck();
        }

        @Override
        public String getEventName() {
            return ConquestEvent.this.getName();
        }

        @Override
        public String getOpponentName() {
            return ConquestEvent.this.getOpponentName();
        }

        @Override
        public PaperCard getPlaneswalker() {
            PaperCard avatarCard = ConquestEvent.this.getAvatarCard();
            if (avatarCard != null && avatarCard.getRules().getType().isPlaneswalker()) {
                return avatarCard;
            }
            return null;
        }

        @Override
        public void setOpponentAvatar(LobbyPlayer aiPlayer, IGuiGame gui) {
            PaperCard avatarCard = ConquestEvent.this.getAvatarCard();
            if (avatarCard != null) {
                aiPlayer.setAvatarCardImageKey(avatarCard.getImageKey(false));
            }
        }

        @Override
        public Set<GameType> getVariants() {
            return ConquestEvent.this.getVariants();
        }

        @Override
        public int gamesPerMatch() {
            return 1;
        }
    }

    public static class Reader
    extends FCollectionReader<ConquestEvent> {
        private final ConquestRegion region;

        public Reader(ConquestRegion region0) {
            super(region0.getPlane().getDirectory() + region0.getName() + ForgeConstants.PATH_SEPARATOR + "_events.txt");
            this.region = region0;
        }

        @Override
        protected ConquestEvent read(String line) {
            String[] pieces;
            String name = null;
            String deck = null;
            EnumSet<GameType> variants = EnumSet.noneOf(GameType.class);
            String avatar = null;
            String description = null;
            String tempUnlock = null;
            block18: for (String piece : pieces = line.split("\\|")) {
                String value;
                String key;
                int idx = piece.indexOf(58);
                if (idx != -1) {
                    key = piece.substring(0, idx).trim().toLowerCase();
                    value = piece.substring(idx + 1).trim();
                } else {
                    this.alertInvalidLine(line, "Invalid event definition.");
                    key = piece.trim().toLowerCase();
                    value = "";
                }
                switch (key) {
                    case "name": {
                        name = value;
                        continue block18;
                    }
                    case "deck": {
                        deck = value;
                        continue block18;
                    }
                    case "variant": {
                        if (value.equalsIgnoreCase("none")) continue block18;
                        for (String variantName : value.split(",")) {
                            try {
                                variants.add(GameType.valueOf(variantName));
                            }
                            catch (Exception ex) {
                                System.out.println(variantName + " is not a valid variant");
                            }
                        }
                        continue block18;
                    }
                    case "avatar": {
                        avatar = value;
                        continue block18;
                    }
                    case "desc": {
                        description = value;
                        continue block18;
                    }
                    case "temporaryunlock": {
                        tempUnlock = value;
                        continue block18;
                    }
                    default: {
                        this.alertInvalidLine(line, "Invalid event definition.");
                    }
                }
            }
            if (deck == null) {
                deck = name + ".dck";
            }
            deck = this.file.getParent() + ForgeConstants.PATH_SEPARATOR + deck;
            return new ConquestEvent(this.region, name, description, deck, variants, avatar, tempUnlock);
        }
    }
}

