/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.LobbyPlayer;
import forge.card.CardType;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.io.DeckStorage;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.GameView;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.planarconquest.ConquestAwardPool;
import forge.gamemodes.planarconquest.ConquestBattle;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.planarconquest.ConquestReward;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gamemodes.quest.BoosterUtils;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IGuiGame;
import forge.gui.interfaces.IWinLoseView;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.player.LobbyPlayerHuman;
import forge.util.Aggregates;
import forge.util.FileUtil;
import forge.util.storage.IStorage;
import forge.util.storage.StorageImmediatelySerialized;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ConquestController {
    private ConquestData model;
    private IStorage<Deck> decks;
    private ConquestBattle activeBattle;
    private LobbyPlayerHuman humanPlayer;

    public ConquestData getModel() {
        return this.model;
    }

    public void setModel(ConquestData model0) {
        this.model = model0;
        if (this.model == null) {
            this.decks = null;
            return;
        }
        File decksDir = new File(this.model.getDirectory(), "decks");
        FileUtil.ensureDirectoryExists(decksDir);
        DeckStorage storage = new DeckStorage(decksDir, ForgeConstants.CONQUEST_SAVE_DIR);
        this.decks = new StorageImmediatelySerialized<Deck>(this.model.getName() + " decks", storage);
    }

    public IStorage<Deck> getDecks() {
        return this.decks;
    }

    public void startBattle(ConquestBattle battle) {
        String aiPlayerName;
        String humanPlayerName;
        if (this.activeBattle != null) {
            return;
        }
        Set<GameType> variants = battle.getVariants();
        ConquestCommander commander = this.model.getSelectedCommander();
        RegisteredPlayer humanStart = new RegisteredPlayer(commander.getDeck());
        RegisteredPlayer aiStart = new RegisteredPlayer(battle.getOpponentDeck());
        if (variants.contains((Object)GameType.Commander)) {
            humanStart.setStartingLife(humanStart.getStartingLife() + 10);
            aiStart.setStartingLife(aiStart.getStartingLife() + 10);
            humanStart.assignCommander();
            aiStart.assignCommander();
        } else {
            CardPool main = humanStart.getDeck().getOrCreate(DeckSection.Main);
            main.add((Iterable<PaperCard>)humanStart.getDeck().getOrCreate(DeckSection.Commander).toFlatList());
        }
        if (variants.contains((Object)GameType.Vanguard)) {
            CardPool avatarPool = humanStart.getDeck().getOrCreate(DeckSection.Avatar);
            avatarPool.clear();
            avatarPool.add(aiStart.getDeck().getOrCreate(DeckSection.Avatar).get(0));
            humanStart.assignVanguardAvatar();
            aiStart.assignVanguardAvatar();
        }
        if (variants.contains((Object)GameType.Planeswalker)) {
            humanStart.setPlaneswalker(this.model.getPlaneswalker());
            aiStart.setPlaneswalker(battle.getPlaneswalker());
        }
        if (variants.contains((Object)GameType.Planechase)) {
            List<PaperCard> planes = this.generatePlanarPool();
            humanStart.setPlanes(planes);
            aiStart.setPlanes(planes);
        }
        if ((humanPlayerName = GamePlayerUtil.getGuiPlayer().getName()).equals(aiPlayerName = battle.getOpponentName())) {
            aiPlayerName = aiPlayerName + " (AI)";
        }
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        this.humanPlayer = new LobbyPlayerHuman(humanPlayerName);
        this.humanPlayer.setAvatarCardImageKey(commander.getCard().getImageKey(false));
        starter.add(humanStart.setPlayer(this.humanPlayer));
        IGuiGame gui = GuiBase.getInterface().getNewGuiGame();
        LobbyPlayer aiPlayer = GamePlayerUtil.createAiPlayer(aiPlayerName, -1, -1);
        battle.setOpponentAvatar(aiPlayer, gui);
        starter.add(aiStart.setPlayer(aiPlayer));
        boolean useRandomFoil = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_RANDOM_FOIL);
        for (RegisteredPlayer rp : starter) {
            rp.setRandomFoil(useRandomFoil);
        }
        GameRules rules = new GameRules(GameType.PlanarConquest);
        rules.setGamesPerMatch(battle.gamesPerMatch());
        rules.setManaBurn(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MANABURN));
        HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
        FThreads.invokeInEdtNowOrLater(() -> hostedMatch.startMatch(rules, variants, (List<RegisteredPlayer>)starter, humanStart, gui));
        this.activeBattle = battle;
    }

    private List<PaperCard> generatePlanarPool() {
        String planeName = this.model.getCurrentPlane().getName();
        ArrayList<PaperCard> pool = new ArrayList<PaperCard>();
        ArrayList<PaperCard> otherPlanes = new ArrayList<PaperCard>();
        ArrayList<PaperCard> phenomenons = new ArrayList<PaperCard>();
        for (PaperCard c : FModel.getMagicDb().getVariantCards().getAllCards()) {
            CardType type = c.getRules().getType();
            if (type.isPlane()) {
                if (type.hasSubtype(planeName)) {
                    pool.add(c);
                    continue;
                }
                otherPlanes.add(c);
                continue;
            }
            if (!type.isPhenomenon()) continue;
            phenomenons.add(c);
        }
        int numPhenomenons = Aggregates.randomInt(0, 2);
        for (int i = 0; i < numPhenomenons; ++i) {
            pool.add((PaperCard)Aggregates.removeRandom(phenomenons));
        }
        while (pool.size() < 10) {
            pool.add((PaperCard)Aggregates.removeRandom(otherPlanes));
        }
        return pool;
    }

    public void showGameOutcome(GameView game, IWinLoseView<? extends IButton> view) {
        this.activeBattle.showGameOutcome(this.model, game, this.humanPlayer, view);
    }

    public void finishEvent(IWinLoseView<? extends IButton> view) {
        if (this.activeBattle == null) {
            return;
        }
        this.activeBattle.onFinished(this.model, view);
        this.activeBattle = null;
    }

    public List<ConquestReward> awardBooster(ConquestAwardPool pool) {
        ConquestPreferences prefs = FModel.getConquestPreferences();
        ArrayList<PaperCard> rewards = new ArrayList<PaperCard>();
        int boostersPerMythic = prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTERS_PER_MYTHIC);
        int raresPerBooster = prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTER_RARES);
        for (int i = 0; i < raresPerBooster; ++i) {
            if (!pool.mythics.isEmpty() && Aggregates.randomInt(1, boostersPerMythic) == 1) {
                rewards.add(Aggregates.removeRandom(pool.mythics));
                continue;
            }
            if (pool.rares.isEmpty()) continue;
            rewards.add(Aggregates.removeRandom(pool.rares));
        }
        int uncommonsPerBooster = prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTER_UNCOMMONS);
        for (int i = 0; i < uncommonsPerBooster && !pool.uncommons.isEmpty(); ++i) {
            rewards.add(Aggregates.removeRandom(pool.uncommons));
        }
        int commonsPerBooster = prefs.getPrefInt(ConquestPreferences.CQPref.BOOSTER_COMMONS);
        for (int i = 0; i < commonsPerBooster && !pool.commons.isEmpty(); ++i) {
            rewards.add(Aggregates.removeRandom(pool.commons));
        }
        BoosterUtils.sort(rewards);
        int shards = 0;
        ArrayList<ConquestReward> allRewards = new ArrayList<ConquestReward>();
        for (int i = rewards.size() - 1; i >= 0; --i) {
            int replacementShards = 0;
            PaperCard card = (PaperCard)rewards.get(i);
            if (this.model.hasUnlockedCard(card)) {
                rewards.remove(i);
                replacementShards = ConquestUtil.getShardValue(card, ConquestPreferences.CQPref.AETHER_BASE_DUPLICATE_VALUE);
                shards += replacementShards;
            }
            allRewards.add(new ConquestReward(card, replacementShards));
        }
        this.model.unlockCards(rewards);
        this.model.rewardAEtherShards(shards);
        return allRewards;
    }
}

