/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net.client;

import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.game.player.actions.PlayerAction;
import forge.game.spellability.SpellAbilityView;
import forge.gamemodes.match.NextGameDecision;
import forge.gamemodes.net.GameProtocolSender;
import forge.gamemodes.net.ProtocolMethod;
import forge.gamemodes.net.client.IToServer;
import forge.interfaces.IDevModeCheats;
import forge.interfaces.IGameController;
import forge.interfaces.IMacroSystem;
import forge.util.ITriggerEvent;
import java.util.List;

public class NetGameController
implements IGameController {
    private final GameProtocolSender sender;
    private IMacroSystem macros;

    public NetGameController(IToServer server) {
        this.sender = new GameProtocolSender(server);
    }

    private void send(ProtocolMethod method, Object ... args) {
        this.sender.send(method, args);
    }

    private <T> T sendAndWait(ProtocolMethod method, Object ... args) {
        return this.sender.sendAndWait(method, args);
    }

    @Override
    public void useMana(byte color) {
        this.send(ProtocolMethod.useMana, color);
    }

    @Override
    public void undoLastAction() {
        this.send(ProtocolMethod.undoLastAction, new Object[0]);
    }

    @Override
    public void selectPlayer(PlayerView playerView, ITriggerEvent triggerEvent) {
        this.send(ProtocolMethod.selectPlayer, playerView, null);
    }

    @Override
    public boolean selectCard(CardView cardView, List<CardView> otherCardViewsToSelect, ITriggerEvent triggerEvent) {
        this.send(ProtocolMethod.selectCard, cardView, otherCardViewsToSelect, null);
        return true;
    }

    @Override
    public void selectButtonOk() {
        this.send(ProtocolMethod.selectButtonOk, new Object[0]);
    }

    @Override
    public void selectButtonCancel() {
        this.send(ProtocolMethod.selectButtonCancel, new Object[0]);
    }

    @Override
    public void selectAbility(SpellAbilityView sa) {
        this.send(ProtocolMethod.selectAbility, sa);
    }

    @Override
    public void passPriorityUntilEndOfTurn() {
        this.send(ProtocolMethod.passPriorityUntilEndOfTurn, new Object[0]);
    }

    @Override
    public void passPriority() {
        this.send(ProtocolMethod.passPriority, new Object[0]);
    }

    @Override
    public void nextGameDecision(NextGameDecision decision) {
        this.send(ProtocolMethod.nextGameDecision, new Object[]{decision});
    }

    @Override
    public boolean mayLookAtAllCards() {
        return false;
    }

    @Override
    public String getActivateDescription(CardView card) {
        return (String)this.sendAndWait(ProtocolMethod.getActivateDescription, card);
    }

    @Override
    public void concede() {
        this.send(ProtocolMethod.concede, new Object[0]);
    }

    @Override
    public IDevModeCheats cheat() {
        return IDevModeCheats.NO_CHEAT;
    }

    @Override
    public boolean canPlayUnlimitedLands() {
        return false;
    }

    @Override
    public void alphaStrike() {
        this.send(ProtocolMethod.alphaStrike, new Object[0]);
    }

    @Override
    public void reorderHand(CardView card, int index) {
        this.send(ProtocolMethod.reorderHand, card, index);
    }

    @Override
    public IMacroSystem macros() {
        if (this.macros == null) {
            this.macros = new NetMacroSystem();
        }
        return this.macros;
    }

    public class NetMacroSystem
    implements IMacroSystem {
        @Override
        public void addRememberedAction(PlayerAction action) {
        }

        @Override
        public void setRememberedActions() {
            NetGameController.this.send(ProtocolMethod.setRememberedActions, new Object[0]);
        }

        @Override
        public void nextRememberedAction() {
            NetGameController.this.send(ProtocolMethod.nextRememberedAction, new Object[0]);
        }

        @Override
        public boolean isRecording() {
            return false;
        }

        @Override
        public String playbackText() {
            return null;
        }
    }
}

