/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net;

import com.google.common.base.Function;
import forge.deck.CardPool;
import forge.game.GameEntityView;
import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.phase.PhaseType;
import forge.game.player.DelayedReveal;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbilityView;
import forge.gamemodes.match.NextGameDecision;
import forge.gui.GuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.interfaces.IGameController;
import forge.localinstance.skin.FSkinProp;
import forge.player.PlayerZoneUpdates;
import forge.trackable.TrackableCollection;
import forge.util.ITriggerEvent;
import forge.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public enum ProtocolMethod {
    setGameView(Mode.SERVER, Void.TYPE, GameView.class),
    openView(Mode.SERVER, Void.TYPE, TrackableCollection.class),
    afterGameEnd(Mode.SERVER, Void.TYPE),
    showCombat(Mode.SERVER, Void.TYPE),
    showPromptMessage(Mode.SERVER, Void.TYPE, PlayerView.class, String.class),
    showCardPromptMessage(Mode.SERVER, Void.TYPE, PlayerView.class, String.class, CardView.class),
    updateButtons(Mode.SERVER, Void.TYPE, PlayerView.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE),
    flashIncorrectAction(Mode.SERVER, Void.TYPE),
    alertUser(Mode.SERVER, Void.TYPE),
    updatePhase(Mode.SERVER, Void.TYPE, Boolean.TYPE),
    updateTurn(Mode.SERVER, Void.TYPE, PlayerView.class),
    updatePlayerControl(Mode.SERVER, Void.TYPE),
    enableOverlay(Mode.SERVER, Void.TYPE),
    disableOverlay(Mode.SERVER, Void.TYPE),
    finishGame(Mode.SERVER, Void.TYPE),
    showManaPool(Mode.SERVER, Void.TYPE, PlayerView.class),
    hideManaPool(Mode.SERVER, Void.TYPE, PlayerView.class),
    updateStack(Mode.SERVER, Void.TYPE),
    updateZones(Mode.SERVER, Void.TYPE, Iterable.class),
    tempShowZones(Mode.SERVER, Iterable.class, PlayerView.class, Iterable.class),
    hideZones(Mode.SERVER, Void.TYPE, PlayerView.class, Iterable.class),
    updateCards(Mode.SERVER, Void.TYPE, Iterable.class),
    updateManaPool(Mode.SERVER, Void.TYPE, Iterable.class),
    updateLives(Mode.SERVER, Void.TYPE, Iterable.class),
    setPanelSelection(Mode.SERVER, Void.TYPE, CardView.class),
    getAbilityToPlay(Mode.SERVER, SpellAbilityView.class, CardView.class, List.class, ITriggerEvent.class),
    assignCombatDamage(Mode.SERVER, Map.class, CardView.class, List.class, Integer.TYPE, GameEntityView.class, Boolean.TYPE, Boolean.TYPE),
    assignGenericAmount(Mode.SERVER, Map.class, CardView.class, Map.class, Integer.TYPE, Boolean.TYPE, String.class),
    message(Mode.SERVER, Void.TYPE, String.class, String.class),
    showErrorDialog(Mode.SERVER, Void.TYPE, String.class, String.class),
    showConfirmDialog(Mode.SERVER, Boolean.TYPE, String.class, String.class, String.class, String.class, Boolean.TYPE),
    showOptionDialog(Mode.SERVER, Integer.TYPE, String.class, String.class, FSkinProp.class, List.class, Integer.TYPE),
    showInputDialog(Mode.SERVER, String.class, String.class, String.class, FSkinProp.class, String.class, List.class, Boolean.TYPE),
    confirm(Mode.SERVER, Boolean.TYPE, CardView.class, String.class, Boolean.TYPE, List.class),
    getChoices(Mode.SERVER, List.class, String.class, Integer.TYPE, Integer.TYPE, List.class, Object.class, Function.class),
    order(Mode.SERVER, List.class, String.class, String.class, Integer.TYPE, Integer.TYPE, List.class, List.class, CardView.class, Boolean.TYPE),
    sideboard(Mode.SERVER, List.class, CardPool.class, CardPool.class, String.class),
    chooseSingleEntityForEffect(Mode.SERVER, GameEntityView.class, String.class, List.class, DelayedReveal.class, Boolean.TYPE),
    chooseEntitiesForEffect(Mode.SERVER, List.class, String.class, List.class, Integer.TYPE, Integer.TYPE, DelayedReveal.class),
    manipulateCardList(Mode.SERVER, List.class, String.class, Iterable.class, Iterable.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE),
    setCard(Mode.SERVER, Void.TYPE, CardView.class),
    setSelectables(Mode.SERVER, Void.TYPE, Iterable.class),
    clearSelectables(Mode.SERVER, Void.TYPE),
    refreshField(Mode.SERVER, Void.TYPE),
    openZones(Mode.SERVER, PlayerZoneUpdates.class, PlayerView.class, Collection.class, Map.class, Boolean.TYPE),
    restoreOldZones(Mode.SERVER, Void.TYPE, PlayerView.class, PlayerZoneUpdates.class),
    isUiSetToSkipPhase(Mode.SERVER, Boolean.TYPE, PlayerView.class, PhaseType.class),
    setRememberedActions(Mode.SERVER, Void.TYPE),
    nextRememberedAction(Mode.SERVER, Void.TYPE),
    useMana(Mode.CLIENT, Void.TYPE, Byte.TYPE),
    undoLastAction(Mode.CLIENT, Void.TYPE),
    selectPlayer(Mode.CLIENT, Void.TYPE, PlayerView.class, ITriggerEvent.class),
    selectCard(Mode.CLIENT, Void.TYPE, CardView.class, List.class, ITriggerEvent.class),
    selectButtonOk(Mode.CLIENT, Void.TYPE),
    selectButtonCancel(Mode.CLIENT, Void.TYPE),
    selectAbility(Mode.CLIENT, Void.TYPE, SpellAbilityView.class),
    passPriorityUntilEndOfTurn(Mode.CLIENT, Void.TYPE),
    passPriority(Mode.CLIENT, Void.TYPE),
    nextGameDecision(Mode.CLIENT, Void.TYPE, NextGameDecision.class),
    getActivateDescription(Mode.CLIENT, String.class, CardView.class),
    concede(Mode.CLIENT, Void.TYPE),
    alphaStrike(Mode.CLIENT, Void.TYPE),
    reorderHand(Mode.CLIENT, Void.TYPE, CardView.class, Integer.TYPE);

    private final Mode mode;
    private final Class<?> returnType;
    private final Class<?>[] args;

    private ProtocolMethod(Mode mode) {
        this(mode, Void.TYPE);
    }

    private ProtocolMethod(Mode mode, Class<?> returnType) {
        this(mode, returnType, null);
    }

    @SafeVarargs
    private ProtocolMethod(Mode mode, Class<?> returnType, Class<?> ... args) {
        this.mode = mode;
        this.returnType = returnType;
        this.args = args == null ? new Class[]{} : args;
    }

    public Method getMethod() {
        try {
            Class toCall = this.mode.toInvoke;
            Method candidate = toCall.getMethod(this.name(), this.args);
            if (this.mode == Mode.SERVER && !candidate.getReturnType().equals(this.returnType)) {
                throw new NoSuchMethodException(String.format("Wrong return type for method %s", this.name()));
            }
            return candidate;
        }
        catch (NoSuchMethodException | SecurityException e) {
            System.err.printf("Warning: class contains no accessible method named %s%n", this.name());
            return this.getMethodNoArgs();
        }
    }

    private Method getMethodNoArgs() {
        try {
            return this.mode.toInvoke.getMethod(this.name(), null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            System.err.printf("Warning: class contains no accessible arg-less method named %s%n", this.name());
            return null;
        }
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getArgTypes() {
        return this.args;
    }

    public void checkArgs(Object[] args) {
        if (!GuiBase.hasPropertyConfig()) {
            return;
        }
        try {
            for (int iArg = 0; iArg < args.length; ++iArg) {
                Object arg = args[iArg];
                Class<?> type = this.args[iArg];
                if (ReflectionUtil.isInstance(arg, type)) continue;
                System.err.printf("InternalError: Protocol method %s: illegal argument (%d) of type %s, %s expected (ProtocolMethod.java)%n", this.name(), iArg, arg.getClass().getName(), type.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkReturnValue(Object value) {
        if (this.returnType.equals(Void.TYPE)) {
            return;
        }
        if (!ReflectionUtil.isInstance(value, this.returnType)) {
            System.err.printf("IllegalStateException: Protocol method %s: illegal return object type %s returned by client, expected %s  (ProtocolMethod.java)%n", this.name(), value.getClass().getName(), this.getReturnType().getName());
        }
    }

    private static enum Mode {
        SERVER(IGuiGame.class),
        CLIENT(IGameController.class);

        private final Class<?> toInvoke;

        private Mode(Class<?> toInvoke) {
            this.toInvoke = toInvoke;
        }
    }
}

