/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net;

import forge.gamemodes.net.IRemote;
import forge.gamemodes.net.ProtocolMethod;
import forge.gamemodes.net.event.GuiGameEvent;
import java.util.concurrent.TimeoutException;

public final class GameProtocolSender {
    private final IRemote remote;

    public GameProtocolSender(IRemote remote) {
        this.remote = remote;
    }

    public void send(ProtocolMethod method, Object ... args) {
        method.checkArgs(args);
        this.remote.send(new GuiGameEvent(method, args));
    }

    public <T> T sendAndWait(ProtocolMethod method, Object ... args) {
        method.checkArgs(args);
        try {
            Object returned = this.remote.sendAndWait(new GuiGameEvent(method, args));
            method.checkReturnValue(returned);
            return (T)returned;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            return null;
        }
    }
}

