/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.gamemodes.match.input.InputBase;
import forge.gamemodes.match.input.InputSynchronized;
import forge.gui.FThreads;
import forge.gui.error.BugReporter;
import forge.player.PlayerControllerHuman;
import java.util.concurrent.CountDownLatch;

public abstract class InputSyncronizedBase
extends InputBase
implements InputSynchronized {
    private static final long serialVersionUID = 8756177361251703052L;
    private final CountDownLatch cdlDone = new CountDownLatch(1);

    public InputSyncronizedBase(PlayerControllerHuman controller) {
        super(controller);
    }

    @Override
    public void awaitLatchRelease() {
        FThreads.assertExecutedByEdt(false);
        try {
            this.cdlDone.await();
        }
        catch (InterruptedException e) {
            BugReporter.reportException(e);
        }
    }

    @Override
    public final void relaseLatchWhenGameIsOver() {
        this.cdlDone.countDown();
    }

    public void showAndWait() {
        this.getController().getInputQueue().setInput(this);
        this.awaitLatchRelease();
    }

    @Override
    public final void stop() {
        this.onStop();
        FThreads.invokeInEdtNowOrLater(this::setFinished);
        if (this.getController().getInputQueue().getInput() != null) {
            this.getController().getInputQueue().removeInput(this);
        }
        this.cdlDone.countDown();
    }

    protected void onStop() {
    }
}

