/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import com.google.common.collect.Iterables;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import java.util.Collection;

public abstract class InputSelectManyBase<T extends GameEntity>
extends InputSyncronizedBase {
    private static final long serialVersionUID = -2305549394512889450L;
    protected boolean bCancelled = false;
    protected final int min;
    protected final int max;
    protected boolean allowCancel = false;
    protected SpellAbility sa = null;
    protected CardView card;
    protected String tallyType;
    protected int tally;
    protected String message = "Source-Card-Name - Select %d more card(s)";

    protected InputSelectManyBase(PlayerControllerHuman controller, int min2, int max) {
        super(controller);
        if (min2 > max) {
            throw new IllegalArgumentException("Min must not be greater than Max");
        }
        this.min = min2;
        this.max = max;
    }

    protected InputSelectManyBase(PlayerControllerHuman controller, int min2, int max, SpellAbility sa0) {
        this(controller, min2, max);
        this.sa = sa0;
        if (sa0 != null) {
            this.card = sa0.getView().getHostCard();
        }
    }

    protected InputSelectManyBase(PlayerControllerHuman controller, int min2, int max, SpellAbility sa0, String tallyType0, int tally0) {
        this(controller, min2, max);
        this.sa = sa0;
        if (sa0 != null) {
            this.card = sa0.getView().getHostCard();
        }
        this.tallyType = tallyType0;
        this.tally = tally0;
    }

    protected InputSelectManyBase(PlayerControllerHuman controller, int min2, int max, CardView card0) {
        this(controller, min2, max);
        this.sa = null;
        this.card = card0;
    }

    protected void refresh() {
        if (this.hasAllTargets()) {
            this.selectButtonOK();
        } else {
            this.showMessage();
        }
    }

    protected abstract boolean hasEnoughTargets();

    protected abstract boolean hasAllTargets();

    protected abstract String getMessage();

    @Override
    public final void showMessage() {
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT) && this.card != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.card.toString());
            if (this.sa != null) {
                if (this.sa.isSpell() && this.sa.getHostCard().isPermanent() && !this.sa.hasParam("SpellDescription") && !this.sa.getPayCosts().isOnlyManaCost()) {
                    sb.append(" - ").append(this.sa.getPayCosts().toString());
                } else if (!this.sa.toString().isEmpty()) {
                    sb.append("\n - ").append(this.sa.toString());
                } else {
                    sb.append("\n");
                }
            }
            sb.append("\n").append(this.getMessage());
            this.showMessage(sb.toString(), this.card);
        } else if (this.card != null) {
            this.showMessage(this.getMessage(), this.card);
        } else {
            this.showMessage(this.getMessage());
        }
        this.getController().getGui().updateButtons(this.getOwner(), this.hasEnoughTargets(), this.allowCancel, true);
    }

    @Override
    protected final void onCancel() {
        this.bCancelled = true;
        this.resetUsedToPay();
        this.getSelected().clear();
        this.stop();
    }

    public final boolean hasCancelled() {
        return this.bCancelled;
    }

    public abstract Collection<T> getSelected();

    public T getFirstSelected() {
        return (T)((GameEntity)Iterables.getFirst(this.getSelected(), null));
    }

    @Override
    protected final void onOk() {
        this.resetUsedToPay();
        this.stop();
    }

    public void setMessage(String message0) {
        this.message = message0;
    }

    protected void onSelectStateChanged(GameEntity c, boolean newState) {
        if (c instanceof Card) {
            this.getController().getGui().setUsedToPay(CardView.get((Card)c), newState);
        } else if (c instanceof Player) {
            this.getController().getGui().setHighlighted(PlayerView.get((Player)c), newState);
        }
    }

    private void resetUsedToPay() {
        for (GameEntity c : this.getSelected()) {
            if (c instanceof Card) {
                this.getController().getGui().setUsedToPay(CardView.get((Card)c), false);
                continue;
            }
            if (!(c instanceof Player)) continue;
            this.getController().getGui().setHighlighted(PlayerView.get((Player)c), false);
        }
    }

    public final void setCancelAllowed(boolean allow) {
        this.allowCancel = allow;
    }
}

