/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.GameView;
import forge.gamemodes.match.input.Input;
import forge.gamemodes.match.input.InputLockUI;
import forge.gamemodes.match.input.InputProxy;
import forge.gamemodes.match.input.InputSynchronized;
import forge.player.PlayerControllerHuman;
import java.util.Observable;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class InputQueue
extends Observable {
    private final BlockingDeque<InputSynchronized> inputStack = new LinkedBlockingDeque<InputSynchronized>();
    private final GameView gameView;

    public InputQueue(GameView gameView, InputProxy inputProxy) {
        this.gameView = gameView;
        this.addObserver(inputProxy);
    }

    public final void updateObservers() {
        this.setChanged();
        this.notifyObservers();
    }

    public final Input getInput() {
        return this.inputStack.isEmpty() ? null : (Input)this.inputStack.peek();
    }

    public final void removeInput(Input inp) {
        Input topMostInput;
        Input input = topMostInput = this.inputStack.isEmpty() ? null : (Input)this.inputStack.peek();
        if (topMostInput != inp) {
            System.out.println("Cannot remove input " + inp.getClass().getSimpleName() + " because it's not on top of stack. Stack = " + this.inputStack);
        } else {
            this.inputStack.pop();
        }
        this.updateObservers();
    }

    public final void clearInputs() {
        while (!this.inputStack.isEmpty()) {
            ((InputSynchronized)this.inputStack.pop()).stop();
        }
        this.updateObservers();
    }

    public final Input getActualInput(PlayerControllerHuman controller) {
        Input topMost = this.inputStack.peek();
        if (topMost != null && !this.gameView.isGameOver()) {
            return topMost;
        }
        return new InputLockUI(this, controller);
    }

    public String printInputStack() {
        return this.inputStack.toString();
    }

    public void setInput(InputSynchronized input) {
        this.inputStack.push(input);
        this.syncPoint();
        this.updateObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncPoint() {
        InputQueue inputQueue = this;
        synchronized (inputQueue) {
        }
    }

    public void onGameOver(boolean releaseAllInputs) {
        for (InputSynchronized inp : this.inputStack) {
            inp.relaseLatchWhenGameIsOver();
            if (releaseAllInputs) continue;
            break;
        }
    }
}

