/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import com.google.common.collect.Lists;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.card.Card;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.player.actions.PayManaFromPoolAction;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityView;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.player.HumanPlay;
import forge.player.PlayerControllerHuman;
import forge.util.Evaluator;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class InputPayMana
extends InputSyncronizedBase {
    private static final long serialVersionUID = 718128600948280315L;
    protected int phyLifeToLose = 0;
    protected final Player player;
    protected final Game game;
    protected ManaCostBeingPaid manaCost;
    protected final SpellAbility saPaidFor;
    protected boolean effect;
    protected boolean mandatory = false;
    private final boolean wasFloatingMana;
    private final Queue<Card> delaySelectCards = new LinkedList<Card>();
    private boolean bPaid = false;
    protected Boolean canPayManaCost = null;
    private boolean locked = false;
    protected String messagePrefix;

    protected InputPayMana(PlayerControllerHuman controller, SpellAbility saPaidFor0, Player player0, boolean effect) {
        super(controller);
        this.player = player0;
        this.game = this.player.getGame();
        this.saPaidFor = saPaidFor0;
        this.effect = effect;
        boolean bl = this.wasFloatingMana = !this.player.getManaPool().isEmpty();
        if (this.wasFloatingMana) {
            this.getController().getGui().showManaPool(PlayerView.get(this.player));
        }
    }

    @Override
    protected void onStop() {
        if (!this.isFinished()) {
            this.saPaidFor.setManaCostBeingPaid(null);
            this.player.popPaidForSA();
            if (this.wasFloatingMana) {
                this.getController().getGui().hideManaPool(PlayerView.get(this.player));
            }
        }
    }

    @Override
    protected boolean onCardSelected(Card card, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            if (otherCardsToSelect != null) {
                block0: for (Card c : otherCardsToSelect) {
                    for (SpellAbility sa : this.getAllManaAbilities(c)) {
                        if (!sa.canPlay()) continue;
                        this.delaySelectCards.add(c);
                        continue block0;
                    }
                }
            }
            if (!this.getAllManaAbilities(card).isEmpty() && this.activateManaAbility(card)) {
                return true;
            }
            return this.activateDelayedCard();
        }
        List<SpellAbility> manaAbilities = this.getAllManaAbilities(card);
        if (manaAbilities.size() == 1) {
            this.activateManaAbility(card, manaAbilities.get(0));
        } else {
            SpellAbility spellAbility = this.getController().getAbilityToPlay(card, manaAbilities, triggerEvent);
            if (spellAbility != null) {
                this.activateManaAbility(card, spellAbility);
            }
        }
        return true;
    }

    protected List<SpellAbility> getAllManaAbilities(Card card) {
        ArrayList<SpellAbility> result = Lists.newArrayList();
        for (SpellAbility sa : card.getManaAbilities()) {
            result.add(sa);
            result.addAll(GameActionUtil.getAlternativeCosts(sa, this.player, false));
        }
        ArrayList<SpellAbility> toRemove = Lists.newArrayListWithCapacity(result.size());
        for (SpellAbility sa : result) {
            sa.setActivatingPlayer(this.player);
            if (sa.canPlay(true)) continue;
            toRemove.add(sa);
        }
        result.removeAll(toRemove);
        return result;
    }

    @Override
    public String getActivateAction(Card card) {
        for (SpellAbility sa : this.getAllManaAbilities(card)) {
            if (!sa.canPlay()) continue;
            return "pay mana with card";
        }
        return null;
    }

    private boolean activateDelayedCard() {
        if (this.delaySelectCards.isEmpty()) {
            return false;
        }
        if (this.manaCost.isPaid()) {
            this.delaySelectCards.clear();
            return false;
        }
        if (this.activateManaAbility(this.delaySelectCards.poll())) {
            return true;
        }
        return this.activateDelayedCard();
    }

    @Override
    public boolean selectAbility(SpellAbility ab) {
        if (ab != null && ab.isManaAbility()) {
            return this.activateManaAbility(ab.getHostCard(), ab);
        }
        return false;
    }

    @Deprecated
    public List<SpellAbility> getUsefulManaAbilities(Card card) {
        ArrayList<SpellAbility> abilities = new ArrayList<SpellAbility>();
        if (card.getController() != this.player) {
            return abilities;
        }
        byte colorCanUse = 0;
        for (byte color : ManaAtom.MANATYPES) {
            if (!this.manaCost.isAnyPartPayableWith(color, this.player.getManaPool())) continue;
            colorCanUse = (byte)(colorCanUse | color);
        }
        if (this.manaCost.isAnyPartPayableWith((byte)64, this.player.getManaPool())) {
            colorCanUse = (byte)(colorCanUse | 0x40);
        }
        if (colorCanUse == 0) {
            return abilities;
        }
        Object object = this.getAllManaAbilities(card).iterator();
        while (object.hasNext()) {
            SpellAbility ma = (SpellAbility)object.next();
            ma.setActivatingPlayer(this.player);
            if (!ma.isManaAbilityFor(this.saPaidFor, colorCanUse)) continue;
            abilities.add(ma);
        }
        return abilities;
    }

    public void useManaFromPool(byte colorCode) {
        if (this.player.getManaPool().tryPayCostWithColor(colorCode, this.saPaidFor, this.manaCost, this.saPaidFor.getPayingMana())) {
            this.getController().macros().addRememberedAction(new PayManaFromPoolAction(colorCode));
            this.onManaAbilityPaid();
            this.showMessage();
        }
    }

    protected boolean activateManaAbility(Card card) {
        return this.activateManaAbility(card, null);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean activateManaAbility(Card card, SpellAbility chosenAbility) {
        void var10_21;
        SpellAbility chosen;
        if (this.locked) {
            System.err.print("Should wait till previous call to playAbility finishes.");
            return false;
        }
        byte colorCanUse = 0;
        byte colorNeeded = 0;
        for (byte color : ManaAtom.MANATYPES) {
            if (this.manaCost.isAnyPartPayableWith(color, this.player.getManaPool())) {
                colorCanUse = (byte)(colorCanUse | color);
            }
            if (!this.manaCost.needsColor(color, this.player.getManaPool())) continue;
            colorNeeded = (byte)(colorNeeded | color);
        }
        if (this.manaCost.isAnyPartPayableWith((byte)64, this.player.getManaPool())) {
            colorCanUse = (byte)(colorCanUse | 0x40);
        }
        if (colorCanUse == 0) {
            return false;
        }
        if (chosenAbility == null) {
            HashMap<SpellAbilityView, SpellAbility> abilitiesMap = new HashMap<SpellAbilityView, SpellAbility>();
            boolean guessAbilityWithRequiredColors = true;
            int amountOfMana = -1;
            for (SpellAbility spellAbility : this.getAllManaAbilities(card)) {
                spellAbility.setActivatingPlayer(this.player);
                if (!spellAbility.isManaAbilityFor(this.saPaidFor, colorCanUse)) continue;
                int maAmount = spellAbility.totalAmountOfManaGenerated(this.saPaidFor, true);
                if (amountOfMana == -1) {
                    amountOfMana = maAmount;
                } else if (amountOfMana != maAmount) {
                    guessAbilityWithRequiredColors = false;
                }
                abilitiesMap.put(spellAbility.getView(), spellAbility);
                if (spellAbility.isUndoable() && spellAbility.getPayCosts().isRenewableResource() && spellAbility.getSubAbility() == null && !spellAbility.isManaCannotCounter(this.saPaidFor)) continue;
                guessAbilityWithRequiredColors = false;
            }
            if (abilitiesMap.isEmpty()) {
                return false;
            }
            if (colorNeeded == 0 && this.saPaidFor.getHostCard() != null && this.saPaidFor.getHostCard().hasSVar("ManaNeededToAvoidNegativeEffect")) {
                String[] negEffects;
                for (String negColor : negEffects = this.saPaidFor.getHostCard().getSVar("ManaNeededToAvoidNegativeEffect").split(",")) {
                    byte col = ManaAtom.fromName(negColor);
                    colorCanUse = (byte)(colorCanUse | col);
                }
            }
            if (this.saPaidFor.tracksManaSpent()) {
                colorCanUse = ColorSet.ALL_COLORS.getColor();
                guessAbilityWithRequiredColors = false;
            }
            boolean choice = true;
            if (guessAbilityWithRequiredColors) {
                if (colorNeeded == 0) {
                    choice = false;
                    colorNeeded = 1;
                } else {
                    HashMap<SpellAbilityView, SpellAbility> hashMap = new HashMap<SpellAbilityView, SpellAbility>();
                    for (SpellAbility sa : abilitiesMap.values()) {
                        if (!sa.isManaAbilityFor(this.saPaidFor, colorNeeded)) continue;
                        hashMap.put(sa.getView(), sa);
                    }
                    if (hashMap.isEmpty()) {
                        choice = false;
                    } else if (hashMap.size() < abilitiesMap.size()) {
                        abilitiesMap = hashMap;
                    }
                }
            }
            ArrayList arrayList = new ArrayList(abilitiesMap.keySet());
            chosen = abilitiesMap.size() > 1 && choice ? (SpellAbility)abilitiesMap.get(this.getController().getGui().one(Localizer.getInstance().getMessage("lblChooseManaAbility", new Object[0]), arrayList)) : (SpellAbility)abilitiesMap.get(arrayList.get(0));
        } else {
            chosen = chosenAbility;
        }
        ColorSet colors = ColorSet.fromMask(0 == colorNeeded ? colorCanUse : colorNeeded);
        int producedColorMask = 0;
        byte[] amountOfMana = ManaAtom.MANATYPES;
        int n = amountOfMana.length;
        boolean bl = false;
        while (var10_21 < n) {
            byte color = amountOfMana[var10_21];
            if (chosen.canProduce(MagicColor.toShortString(color)) && colors.hasAnyColor(color)) {
                producedColorMask |= color;
            }
            ++var10_21;
        }
        ColorSet producedAndNeededColors = ColorSet.fromMask(producedColorMask);
        chosen.setManaExpressChoice(producedAndNeededColors);
        this.locked = true;
        this.game.getAction().invoke(() -> {
            if (HumanPlay.playSpellAbility(this.getController(), chosen.getActivatingPlayer(), chosen)) {
                List<AbilityManaPart> manaAbilities = chosen.getAllManaParts();
                boolean restrictionsMet = true;
                for (AbilityManaPart sa : manaAbilities) {
                    if (sa.meetsManaRestrictions(this.saPaidFor)) continue;
                    restrictionsMet = false;
                    break;
                }
                if (restrictionsMet && !this.player.getController().isFullControl()) {
                    this.player.getManaPool().payManaFromAbility(this.saPaidFor, this.manaCost, chosen);
                }
                if (!restrictionsMet || chosen.getPayCosts().hasManaCost()) {
                    this.updateButtons();
                    this.canPayManaCost = null;
                }
                this.onManaAbilityPaid();
            }
            this.onStateChanged();
        });
        return true;
    }

    protected boolean isAlreadyPaid() {
        if (this.manaCost.isPaid()) {
            this.bPaid = true;
        }
        return this.bPaid;
    }

    protected boolean supportAutoPay() {
        return true;
    }

    protected void runAsAi(Runnable proc) {
        this.player.runWithController(proc, new PlayerControllerAi(this.game, this.player, this.player.getOriginalLobbyPlayer()));
    }

    @Override
    protected void onOk() {
        if (this.supportAutoPay() && !this.locked) {
            this.locked = true;
            Runnable proc = () -> ComputerUtilMana.payManaCost(this.manaCost, this.saPaidFor, this.player, this.effect);
            this.game.getAction().invoke(() -> {
                this.runAsAi(proc);
                this.onStateChanged();
            });
        }
    }

    protected void updateButtons() {
        if (this.supportAutoPay()) {
            this.getController().getGui().updateButtons(this.getOwner(), Localizer.getInstance().getMessage("lblAuto", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]), false, !this.mandatory, false);
        } else {
            this.getController().getGui().updateButtons(this.getOwner(), "", Localizer.getInstance().getMessage("lblCancel", new Object[0]), false, !this.mandatory, false);
        }
    }

    protected final void updateMessage() {
        this.locked = false;
        if (this.activateDelayedCard()) {
            return;
        }
        if (this.supportAutoPay()) {
            if (this.canPayManaCost == null) {
                Evaluator<Boolean> proc = new Evaluator<Boolean>(){

                    @Override
                    public Boolean evaluate() {
                        return ComputerUtilMana.canPayManaCost(InputPayMana.this.manaCost, InputPayMana.this.saPaidFor, InputPayMana.this.player, InputPayMana.this.effect);
                    }
                };
                this.runAsAi(proc);
                this.canPayManaCost = (Boolean)proc.getResult();
            }
            if (this.canPayManaCost.booleanValue()) {
                this.getController().getGui().updateButtons(this.getOwner(), Localizer.getInstance().getMessage("lblAuto", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]), true, !this.mandatory, true);
            }
        }
        this.showMessage(this.getMessage(), this.saPaidFor.getView());
    }

    @Override
    public void showMessage() {
        if (this.isFinished()) {
            return;
        }
        this.updateButtons();
        this.onStateChanged();
    }

    protected void onStateChanged() {
        if (this.isAlreadyPaid()) {
            this.done();
            this.stop();
        } else {
            FThreads.invokeInEdtNowOrLater(this::updateMessage);
        }
    }

    protected void onManaAbilityPaid() {
    }

    protected abstract void done();

    protected abstract String getMessage();

    public String toString() {
        return TextUtil.concatNoSpace("PayManaBase ", this.manaCost.toString(), " left");
    }

    public boolean isPaid() {
        return this.bPaid;
    }

    public void setMessagePrefix(String prompt) {
        this.messagePrefix = prompt;
    }
}

