/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.gamemodes.match.input.Input;
import forge.gamemodes.match.input.InputQueue;
import forge.gui.FThreads;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class InputLockUI
implements Input {
    private final AtomicInteger iCall = new AtomicInteger();
    private final InputQueue inputQueue;
    private final PlayerControllerHuman controller;
    private final Runnable showMessageFromEdt = new Runnable(){

        @Override
        public void run() {
            InputLockUI.this.controller.getGui().updateButtons(InputLockUI.this.getOwner(), "", "", false, false, false);
            InputLockUI.this.showMessage(Localizer.getInstance().getMessage("lblWaitingforActions", new Object[0]));
        }
    };

    public InputLockUI(InputQueue inputQueue0, PlayerControllerHuman controller) {
        this.inputQueue = inputQueue0;
        this.controller = controller;
    }

    @Override
    public PlayerView getOwner() {
        return null;
    }

    @Override
    public void showMessageInitial() {
        int ixCall = 1 + this.iCall.getAndIncrement();
        ThreadUtil.delay(500, new InputUpdater(ixCall));
    }

    public String toString() {
        return "lockUI";
    }

    protected final boolean isActive() {
        return this.inputQueue.getInput() == this;
    }

    protected void showMessage(String message) {
        this.controller.getGui().showPromptMessage(this.getOwner(), message);
    }

    @Override
    public boolean selectCard(Card c, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        return false;
    }

    @Override
    public boolean selectAbility(SpellAbility ab) {
        return false;
    }

    @Override
    public void selectPlayer(Player player, ITriggerEvent triggerEvent) {
    }

    @Override
    public void selectButtonOK() {
    }

    @Override
    public void selectButtonCancel() {
        for (Player player : this.controller.getGame().getPlayers()) {
            player.getController().autoPassCancel();
        }
    }

    @Override
    public String getActivateAction(Card card) {
        return null;
    }

    private class InputUpdater
    implements Runnable {
        final int ixCall;

        public InputUpdater(int idxCall) {
            this.ixCall = idxCall;
        }

        @Override
        public void run() {
            if (this.ixCall != InputLockUI.this.iCall.get() || !InputLockUI.this.isActive()) {
                return;
            }
            FThreads.invokeInEdtLater(InputLockUI.this.showMessageFromEdt);
        }
    }
}

