/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardView;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import java.util.List;

public class InputConfirmMulligan
extends InputSyncronizedBase {
    private static final long serialVersionUID = -8112954303001155622L;
    boolean keepHand = false;
    private final CardCollection selected = new CardCollection();
    private final Player player;
    private final Player startingPlayer;
    volatile boolean cardSelectLocked = false;

    public InputConfirmMulligan(PlayerControllerHuman controller, Player humanPlayer, Player startsGame) {
        super(controller);
        this.player = humanPlayer;
        this.startingPlayer = startsGame;
    }

    @Override
    public final void showMessage() {
        Localizer localizer = Localizer.getInstance();
        Game game = this.player.getGame();
        StringBuilder sb = new StringBuilder();
        if (this.startingPlayer == this.player) {
            sb.append(this.player).append(", ").append(localizer.getMessage("lblYouAreGoingFirst", new Object[0])).append("\n\n");
        } else {
            sb.append(this.startingPlayer.getName()).append(" ").append(localizer.getMessage("lblIsGoingFirst", new Object[0])).append(".\n");
            sb.append(this.player).append(", ").append(localizer.getMessage("lblYouAreGoing", new Object[0])).append(" ").append(Lang.getInstance().getOrdinal(game.getPosition(this.player, this.startingPlayer))).append(".\n\n");
        }
        this.getController().getGui().updateButtons(this.getOwner(), localizer.getMessage("lblKeep", new Object[0]), localizer.getMessage("lblMulligan", new Object[0]), true, true, true);
        sb.append(localizer.getMessage("lblDoYouWantToKeepYourHand", new Object[0]));
        this.showMessage(sb.toString());
    }

    @Override
    protected final boolean allowAwaitNextInput() {
        return true;
    }

    @Override
    protected final void onOk() {
        this.keepHand = true;
        this.done();
    }

    @Override
    protected final void onCancel() {
        this.keepHand = false;
        this.done();
    }

    private void done() {
        this.stop();
    }

    @Override
    protected boolean onCardSelected(Card c0, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        if (this.cardSelectLocked) {
            return false;
        }
        boolean fromHand = this.player.getZone(ZoneType.Hand).contains(c0);
        boolean isSerumPowder = c0.getName().equals("Serum Powder");
        if (!isSerumPowder || !fromHand) {
            return false;
        }
        CardView cView = c0.getView();
        if (this.getController().getGui().confirm(cView, "Use " + cView + "'s ability?")) {
            this.cardSelectLocked = true;
            ThreadUtil.invokeInGameThread(() -> {
                CardCollectionView hand = c0.getController().getCardsIn(ZoneType.Hand);
                int handSize = hand.size();
                for (Card c : hand.threadSafeIterable()) {
                    this.player.getGame().getAction().exile(c, null, null);
                }
                c0.getController().drawCards(handSize);
                this.cardSelectLocked = false;
            });
        }
        return true;
    }

    public final boolean isKeepHand() {
        return this.keepHand;
    }

    public CardCollectionView getSelectedCards() {
        return this.selected;
    }

    @Override
    public String getActivateAction(Card card) {
        return null;
    }
}

