/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.event.GameEventCombatChanged;
import forge.game.event.GameEventCombatUpdate;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.gui.FThreads;
import forge.gui.events.UiEventBlockerAssigned;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import java.util.List;

public class InputBlock
extends InputSyncronizedBase {
    private static final long serialVersionUID = 6120743598368928128L;
    private Card currentAttacker = null;
    private final Combat combat;
    private final Player defender;

    public InputBlock(PlayerControllerHuman controller, Player defender0, Combat combat0) {
        super(controller);
        this.defender = defender0;
        this.combat = combat0;
        for (Card attacker : this.combat.getAttackers()) {
            for (Card c : this.defender.getCreaturesInPlay()) {
                if (!CombatUtil.canBlock(attacker, c, this.combat)) continue;
                FThreads.invokeInEdtNowOrLater(() -> this.setCurrentAttacker(attacker));
                return;
            }
        }
    }

    @Override
    protected final void showMessage() {
        Localizer localizer = Localizer.getInstance();
        this.getController().getGui().updateButtons(this.getOwner(), true, false, true);
        if (this.currentAttacker == null) {
            this.showMessage(localizer.getMessage("lblSelectBlockTarget", new Object[0]));
        } else {
            String attackerName = this.currentAttacker.isFaceDown() ? localizer.getMessage("lblMorph", new Object[0]) : this.currentAttacker.getName() + " (" + this.currentAttacker.getId() + ")";
            String message = localizer.getMessage("lblSelectBlocker", new Object[0]) + attackerName + " " + localizer.getMessage("lblOrSelectBlockTarget", new Object[0]);
            this.showMessage(message);
        }
        if (this.combat != null) {
            this.getController().getGame().fireEvent(new GameEventCombatUpdate(this.combat.getAttackers(), this.combat.getAllBlockers()));
        }
        this.getController().getGui().showCombat();
    }

    @Override
    public final void onOk() {
        String blockErrors = CombatUtil.validateBlocks(this.combat, this.defender);
        if (blockErrors == null) {
            this.setCurrentAttacker(null);
            this.stop();
        } else {
            ThreadUtil.invokeInGameThread(() -> this.getController().getGui().message(blockErrors));
        }
    }

    @Override
    public final boolean onCardSelected(Card card, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        boolean isCorrectAction = false;
        if (triggerEvent != null && triggerEvent.getButton() == 3 && card.getController() == this.defender) {
            this.combat.removeFromCombat(card);
            card.getGame().getMatch().fireEvent(new UiEventBlockerAssigned(CardView.get(card), null));
            isCorrectAction = true;
        } else if (this.combat.isAttacking(card)) {
            this.setCurrentAttacker(card);
            isCorrectAction = true;
        } else if (this.currentAttacker != null && card.isCreature() && this.defender.getZone(ZoneType.Battlefield).contains(card)) {
            if (this.combat.isBlocking(card, this.currentAttacker)) {
                this.combat.removeBlockAssignment(this.currentAttacker, card);
                card.getGame().getMatch().fireEvent(new UiEventBlockerAssigned(CardView.get(card), null));
                isCorrectAction = true;
            } else {
                isCorrectAction = CombatUtil.canBlock(this.currentAttacker, card, this.combat);
                if (isCorrectAction) {
                    this.combat.addBlocker(this.currentAttacker, card);
                    card.getGame().getMatch().fireEvent(new UiEventBlockerAssigned(CardView.get(card), CardView.get(this.currentAttacker)));
                }
            }
        }
        if (isCorrectAction) {
            card.getGame().fireEvent(new GameEventCombatChanged());
        }
        this.showMessage();
        return isCorrectAction;
    }

    @Override
    public String getActivateAction(Card card) {
        if (this.combat.isAttacking(card)) {
            return "declare blockers for card";
        }
        if (this.currentAttacker != null && card.isCreature() && this.defender.getZone(ZoneType.Battlefield).contains(card)) {
            if (this.combat.isBlocking(card, this.currentAttacker)) {
                return "remove card from combat";
            }
            if (CombatUtil.canBlock(this.currentAttacker, card, this.combat)) {
                return "block with card";
            }
        }
        return null;
    }

    private void setCurrentAttacker(Card card) {
        this.currentAttacker = card;
        for (Card c : this.combat.getAttackers()) {
            this.getController().getGui().setUsedToPay(CardView.get(c), card == c);
        }
    }
}

