/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match;

import com.google.common.collect.ImmutableSet;
import forge.ai.AIOption;
import forge.deck.Deck;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.event.UpdateLobbyPlayerEvent;
import java.io.Serializable;
import java.util.Set;

public final class LobbySlot
implements Serializable {
    private static final long serialVersionUID = 9203252798721142264L;
    private LobbySlotType type;
    private String name;
    private int avatarIndex;
    private int sleeveIndex;
    private int team;
    private boolean isArchenemy;
    private boolean isReady;
    private boolean isDevMode;
    private Deck deck;
    private ImmutableSet<AIOption> aiOptions;
    private String AvatarVanguard;
    private String SchemeDeckName;
    private String PlanarDeckName;
    private String DeckName;

    public LobbySlot(LobbySlotType type, String name, int avatarIndex, int sleeveIndex, int team, boolean isArchenemy, boolean isReady, Set<AIOption> aiOptions) {
        this.type = type;
        this.name = name;
        this.avatarIndex = avatarIndex;
        this.sleeveIndex = sleeveIndex;
        this.team = team;
        this.isArchenemy = isArchenemy;
        this.isReady = isReady;
        this.isDevMode = false;
        this.setAiOptions(aiOptions);
    }

    boolean apply(UpdateLobbyPlayerEvent data) {
        boolean changed = false;
        if (data.getType() != null) {
            this.setType(data.getType());
            changed = true;
        }
        if (data.getName() != null) {
            this.setName(data.getName());
            changed = true;
        }
        if (data.getAvatarIndex() != -1) {
            this.setAvatarIndex(data.getAvatarIndex());
            changed = true;
        }
        if (data.getSleeveIndex() != -1) {
            this.setSleeveIndex(data.getSleeveIndex());
            changed = true;
        }
        if (data.getTeam() != -1) {
            this.setTeam(data.getTeam());
            changed = true;
        }
        if (data.getArchenemy() != null) {
            this.setIsArchenemy(data.getArchenemy());
            changed = true;
        }
        if (data.getReady() != null) {
            this.setIsReady(data.getReady());
            changed = true;
        }
        if (data.getDevMode() != null) {
            this.setIsDevMode(data.getDevMode());
            changed = true;
        }
        if (data.getAiOptions() != null) {
            this.setAiOptions(data.getAiOptions());
            changed = true;
        }
        Deck oldDeck = this.getDeck();
        if (data.getDeck() != null) {
            this.setDeck(data.getDeck());
        } else if (oldDeck != null && data.getSection() != null && data.getCards() != null) {
            oldDeck.putSection(data.getSection(), data.getCards());
        }
        if (data.getSchemeDeckName() != null) {
            this.setSchemeDeckName(data.getSchemeDeckName());
            changed = true;
        }
        if (data.getAvatarVanguard() != null) {
            this.setAvatarVanguard(data.getAvatarVanguard());
            changed = true;
        }
        if (data.getPlanarDeckName() != null) {
            this.setPlanarDeckName(data.getPlanarDeckName());
            changed = true;
        }
        if (data.getDeckName() != null) {
            this.setDeckName(data.getDeckName());
            changed = true;
        }
        return changed;
    }

    public LobbySlotType getType() {
        return this.type;
    }

    public void setType(LobbySlotType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAvatarIndex() {
        return this.avatarIndex;
    }

    public int getSleeveIndex() {
        return this.sleeveIndex;
    }

    public void setAvatarIndex(int avatarIndex) {
        this.avatarIndex = avatarIndex;
    }

    public void setSleeveIndex(int sleeveIndex) {
        this.sleeveIndex = sleeveIndex;
    }

    public int getTeam() {
        return this.team;
    }

    public void setTeam(int team) {
        this.team = team;
    }

    public String getSchemeDeckName() {
        return this.SchemeDeckName;
    }

    public String getAvatarVanguard() {
        return this.AvatarVanguard;
    }

    public String getPlanarDeckName() {
        return this.PlanarDeckName;
    }

    public String getDeckName() {
        return this.DeckName;
    }

    public void setSchemeDeckName(String schemeDeckName) {
        this.SchemeDeckName = schemeDeckName;
    }

    public void setAvatarVanguard(String avatarVanguard) {
        this.AvatarVanguard = avatarVanguard;
    }

    public void setPlanarDeckName(String planarDeckName) {
        this.PlanarDeckName = planarDeckName;
    }

    public void setDeckName(String DeckName) {
        this.DeckName = DeckName;
    }

    public boolean isArchenemy() {
        return this.isArchenemy;
    }

    public void setIsArchenemy(boolean isArchenemy) {
        this.isArchenemy = isArchenemy;
    }

    public boolean isReady() {
        return this.type == LobbySlotType.AI || this.isReady;
    }

    public void setIsReady(boolean isReady) {
        this.isReady = isReady;
    }

    public boolean isDevMode() {
        return this.isDevMode;
    }

    public void setIsDevMode(boolean isDevMode) {
        this.isDevMode = isDevMode;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public void setDeck(Deck deck) {
        this.deck = deck;
    }

    public ImmutableSet<AIOption> getAiOptions() {
        return this.aiOptions;
    }

    public void setAiOptions(Set<AIOption> aiOptions) {
        this.aiOptions = aiOptions == null ? ImmutableSet.of() : ImmutableSet.copyOf(aiOptions);
    }
}

