/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import forge.LobbyPlayer;
import forge.StaticData;
import forge.ai.AiProfileUtil;
import forge.game.Game;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.GameView;
import forge.game.Match;
import forge.game.event.GameEvent;
import forge.game.event.GameEventSubgameEnd;
import forge.game.event.GameEventSubgameStart;
import forge.game.event.IGameEventVisitor;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.NextGameDecision;
import forge.gamemodes.quest.QuestController;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.control.FControlGameEventHandler;
import forge.gui.control.FControlGamePlayback;
import forge.gui.control.PlaybackSpeed;
import forge.gui.control.WatchLocalGame;
import forge.gui.events.IUiEventVisitor;
import forge.gui.events.UiEvent;
import forge.gui.events.UiEventAttackerDeclared;
import forge.gui.events.UiEventBlockerAssigned;
import forge.gui.events.UiEventNextGameDecision;
import forge.gui.interfaces.IGuiGame;
import forge.interfaces.IGameController;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.player.LobbyPlayerHuman;
import forge.player.PlayerControllerHuman;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import forge.trackable.TrackableCollection;
import forge.util.CollectionSuppliers;
import forge.util.TextUtil;
import forge.util.maps.HashMapOfLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class HostedMatch {
    private Match match;
    private Game game;
    private String title;
    private MusicPlaylist matchPlaylist = null;
    public HashMap<LobbySlot, IGameController> gameControllers = null;
    private Runnable startGameHook = null;
    private Runnable endGameHook = null;
    private final List<PlayerControllerHuman> humanControllers = Lists.newArrayList();
    private Map<RegisteredPlayer, IGuiGame> guis;
    private int humanCount;
    private FControlGamePlayback playbackControl = null;
    private final MatchUiEventVisitor visitor = new MatchUiEventVisitor();
    private final Map<PlayerControllerHuman, NextGameDecision> nextGameDecisions = Maps.newHashMap();
    private boolean isMatchOver = false;
    public int subGameCount = 0;

    public void setStartGameHook(Runnable hook) {
        this.startGameHook = hook;
    }

    public void setEndGameHook(Runnable hook) {
        this.endGameHook = hook;
    }

    private static GameRules getDefaultRules(GameType gameType) {
        GameRules gameRules = new GameRules(gameType);
        gameRules.setPlayForAnte(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ANTE));
        gameRules.setMatchAnteRarity(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ANTE_MATCH_RARITY));
        gameRules.setManaBurn(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MANABURN));
        gameRules.setUseGrayText(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_GRAY_INACTIVE_TEXT));
        gameRules.setGamesPerMatch(FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_MATCHES_PER_GAME));
        switch (AiProfileUtil.getAISideboardingMode()) {
            case Off: {
                gameRules.setAISideboardingEnabled(false);
                gameRules.setSideboardForAI(false);
                break;
            }
            case AI: {
                gameRules.setAISideboardingEnabled(true);
                gameRules.setSideboardForAI(false);
                break;
            }
            case HumanForAI: {
                gameRules.setAISideboardingEnabled(true);
                gameRules.setSideboardForAI(true);
            }
        }
        return gameRules;
    }

    public void startMatch(GameType gameType, Set<GameType> appliedVariants, List<RegisteredPlayer> players, RegisteredPlayer human, IGuiGame gui) {
        this.startMatch(HostedMatch.getDefaultRules(gameType), appliedVariants, players, human, gui);
    }

    public void startMatch(GameType gameType, Set<GameType> appliedVariants, List<RegisteredPlayer> players, Map<RegisteredPlayer, IGuiGame> guis) {
        this.startMatch(HostedMatch.getDefaultRules(gameType), appliedVariants, players, guis, null);
    }

    public void startMatch(GameRules gameRules, Set<GameType> appliedVariants, List<RegisteredPlayer> players, RegisteredPlayer human, IGuiGame gui) {
        this.startMatch(gameRules, appliedVariants, players, human == null || gui == null ? null : ImmutableMap.of(human, gui), null);
    }

    public void startMatch(GameRules gameRules, Set<GameType> appliedVariants, List<RegisteredPlayer> players, Map<RegisteredPlayer, IGuiGame> guis, MusicPlaylist playlist) {
        if (gameRules == null || gameRules.getGameType() == null || players == null || players.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.guis = guis == null ? ImmutableMap.of() : guis;
        boolean useRandomFoil = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_RANDOM_FOIL);
        for (RegisteredPlayer rp : players) {
            rp.setRandomFoil(useRandomFoil);
        }
        if (appliedVariants != null && !appliedVariants.isEmpty()) {
            gameRules.setAppliedVariants(appliedVariants);
        }
        ArrayList<RegisteredPlayer> sortedPlayers = Lists.newArrayList(players);
        sortedPlayers.sort((p1, p2) -> {
            int v1 = p1.getPlayer() instanceof LobbyPlayerHuman ? 0 : 1;
            int v2 = p2.getPlayer() instanceof LobbyPlayerHuman ? 0 : 1;
            return Integer.compare(v1, v2);
        });
        this.title = sortedPlayers.size() == 2 ? TextUtil.concatNoSpace(((RegisteredPlayer)sortedPlayers.get(0)).getPlayer().getName(), " vs ", ((RegisteredPlayer)sortedPlayers.get(1)).getPlayer().getName()) : TextUtil.concatNoSpace("Multiplayer Game (", String.valueOf(sortedPlayers.size()), " players)");
        this.match = new Match(gameRules, sortedPlayers, this.title);
        this.match.subscribeToEvents(SoundSystem.instance);
        this.match.subscribeToEvents(this.visitor);
        this.matchPlaylist = playlist;
        this.startGame();
    }

    public void continueMatch() {
        this.endCurrentGame();
        this.startGame();
    }

    public void restartMatch() {
        this.endCurrentGame();
        this.startMatch(this.match.getRules(), null, this.match.getPlayers(), this.guis, this.matchPlaylist);
    }

    public void startGame() {
        this.nextGameDecisions.clear();
        SoundSystem.instance.setBackgroundMusic(this.matchPlaylist == null ? MusicPlaylist.MATCH : this.matchPlaylist);
        this.game = this.match.createGame();
        this.game.EXPERIMENTAL_RESTORE_SNAPSHOT = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.MATCH_EXPERIMENTAL_RESTORE);
        StaticData.instance().setSourceImageForClone(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_CLONE_MODE_SOURCE));
        if (this.game.getRules().getGameType() == GameType.Quest) {
            QuestController qc = FModel.getQuest();
            if (this.game.getMatch().getOutcomes().isEmpty()) {
                qc.getCards().resetNewList();
            }
            this.game.subscribeToEvents(qc);
        }
        this.game.subscribeToEvents(SoundSystem.instance);
        this.game.subscribeToEvents(this.visitor);
        PlayerCollection players = this.game.getPlayers();
        String[] avatarIndices = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        String[] sleeveIndices = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_SLEEVES).split(",");
        GameView gameView = this.getGameView();
        this.humanCount = 0;
        HashMapOfLists playersPerGui = new HashMapOfLists(CollectionSuppliers.arrayLists());
        for (int iPlayer = 0; iPlayer < players.size(); ++iPlayer) {
            RegisteredPlayer rp = this.match.getPlayers().get(iPlayer);
            Player p = (Player)players.get(iPlayer);
            p.getLobbyPlayer().setAvatarIndex(rp.getPlayer().getAvatarIndex());
            if (p.getLobbyPlayer().getAvatarIndex() == -1) {
                if (iPlayer < avatarIndices.length) {
                    p.getLobbyPlayer().setAvatarIndex(Integer.parseInt(avatarIndices[iPlayer]));
                } else {
                    p.getLobbyPlayer().setAvatarIndex(0);
                }
            }
            p.updateAvatar();
            p.getLobbyPlayer().setSleeveIndex(rp.getPlayer().getSleeveIndex());
            if (p.getLobbyPlayer().getSleeveIndex() == -1) {
                if (iPlayer < sleeveIndices.length) {
                    p.getLobbyPlayer().setSleeveIndex(Integer.parseInt(sleeveIndices[iPlayer]));
                } else {
                    p.getLobbyPlayer().setSleeveIndex(0);
                }
            }
            p.updateSleeve();
            if (!(p.getController() instanceof PlayerControllerHuman)) continue;
            PlayerControllerHuman humanController = (PlayerControllerHuman)p.getController();
            IGuiGame gui = this.guis.get(p.getRegisteredPlayer());
            humanController.setGui(gui);
            gui.setGameView(null);
            gui.setGameView(gameView);
            gui.setOriginalGameController(p.getView(), humanController);
            this.game.subscribeToEvents(new FControlGameEventHandler(humanController));
            playersPerGui.add(gui, p.getView());
            if (this.gameControllers != null) {
                LobbySlot lobbySlot = this.getLobbySlot(p.getLobbyPlayer());
                this.gameControllers.put(lobbySlot, humanController);
            }
            this.humanControllers.add(humanController);
            ++this.humanCount;
        }
        for (Map.Entry e : playersPerGui.entrySet()) {
            ((IGuiGame)e.getKey()).openView(new TrackableCollection<PlayerView>((Collection)e.getValue()));
        }
        if (this.humanCount == 0) {
            IGuiGame gui = GuiBase.getInterface().getNewGuiGame();
            gui.setGameView(null);
            gui.setGameView(gameView);
            this.registerSpectator(gui, new WatchLocalGame(this.game, (LobbyPlayer)new LobbyPlayerHuman("Spectator"), gui));
        }
        if (StringUtils.isBlank(FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME)) && this.humanCount == 1) {
            GamePlayerUtil.setPlayerName();
        }
        for (Player p : players) {
            p.updateOpponentsForView();
        }
        this.game.getAction().invoke(() -> {
            if (this.humanCount == 0) {
                this.playbackControl = new FControlGamePlayback(this.humanControllers.get(0));
                this.playbackControl.setGame(this.game);
                this.game.subscribeToEvents(this.playbackControl);
            }
            this.match.startGame(this.game, this.startGameHook);
            if (this.endGameHook != null) {
                this.endGameHook.run();
            }
            this.isMatchOver = this.match.isMatchOver();
            if (this.humanCount == 0) {
                if (this.isMatchOver) {
                    this.addNextGameDecision(null, NextGameDecision.QUIT);
                } else {
                    this.addNextGameDecision(null, NextGameDecision.CONTINUE);
                }
            }
        });
    }

    private LobbySlot getLobbySlot(LobbyPlayer lobbyPlayer) {
        for (LobbySlot key : this.gameControllers.keySet()) {
            IGameController value = this.gameControllers.get(key);
            if (!(value instanceof PlayerControllerHuman) || lobbyPlayer != ((PlayerControllerHuman)value).getLobbyPlayer()) continue;
            return key;
        }
        return null;
    }

    public void registerSpectator(IGuiGame gui) {
        WatchLocalGame humanController = new WatchLocalGame(this.game, null, gui);
        this.registerSpectator(gui, humanController);
    }

    public void registerSpectator(IGuiGame gui, PlayerControllerHuman humanController) {
        gui.setSpectator(humanController);
        gui.openView(null);
        this.game.subscribeToEvents(new FControlGameEventHandler(humanController));
        this.humanControllers.add(humanController);
    }

    public Game getGame() {
        return this.game;
    }

    public GameView getGameView() {
        return this.game == null ? null : this.game.getView();
    }

    public void endCurrentGame() {
        if (this.game == null) {
            return;
        }
        boolean isMatchOver = this.game.getView().isMatchOver();
        this.game = null;
        for (PlayerControllerHuman humanController : this.humanControllers) {
            humanController.getGui().setGameSpeed(PlaybackSpeed.NORMAL);
            if (FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AUTO_YIELD_MODE).equals("Per Card (Each Game)") || this.isMatchOver()) {
                humanController.getGui().clearAutoYields();
            }
            if (this.humanCount > 0) {
                humanController.getGui().afterGameEnd();
            } else if (!GuiBase.getInterface().isLibgdxPort() || !isMatchOver) {
                humanController.getGui().afterGameEnd();
            }
            humanController.getGui().updateDayTime(null);
        }
        this.humanControllers.clear();
    }

    public void pause() {
        ForgePreferences prefs = FModel.getPreferences();
        if (prefs == null) {
            return;
        }
        if (prefs.getPrefBoolean(ForgePreferences.FPref.UI_PAUSE_WHILE_MINIMIZED) && this.playbackControl != null) {
            this.playbackControl.getInput().pause();
        }
    }

    public void resume() {
    }

    public boolean isMatchOver() {
        return this.isMatchOver;
    }

    private void addNextGameDecision(PlayerControllerHuman controller, NextGameDecision decision) {
        if (decision == NextGameDecision.QUIT) {
            FThreads.invokeInEdtNowOrLater(() -> {
                this.endCurrentGame();
                this.isMatchOver = true;
            });
            return;
        }
        this.nextGameDecisions.put(controller, decision);
        if (this.nextGameDecisions.size() < this.humanControllers.size()) {
            return;
        }
        int newMatch = 0;
        int continueMatch = 0;
        for (NextGameDecision dec : this.nextGameDecisions.values()) {
            switch (dec) {
                case CONTINUE: {
                    ++continueMatch;
                    break;
                }
                case NEW: {
                    ++newMatch;
                    break;
                }
            }
        }
        if (continueMatch >= newMatch) {
            FThreads.invokeInEdtNowOrLater(this::continueMatch);
        } else {
            FThreads.invokeInEdtNowOrLater(this::restartMatch);
        }
    }

    public List<PlayerControllerHuman> getHumanControllers() {
        return this.humanControllers;
    }

    private final class MatchUiEventVisitor
    extends IGameEventVisitor.Base<Void>
    implements IUiEventVisitor<Void> {
        private MatchUiEventVisitor() {
        }

        @Override
        public Void visit(UiEventBlockerAssigned event) {
            for (PlayerControllerHuman humanController : HostedMatch.this.humanControllers) {
                humanController.getGui().updateSingleCard(event.blocker);
                PlayerView p = humanController.getPlayer().getView();
                if (event.attackerBeingBlocked == null || !event.attackerBeingBlocked.getController().equals(p)) continue;
                humanController.getGui().autoPassCancel(p);
            }
            return null;
        }

        @Override
        public Void visit(UiEventAttackerDeclared event) {
            for (PlayerControllerHuman humanController : HostedMatch.this.humanControllers) {
                humanController.getGui().updateSingleCard(event.attacker);
            }
            return null;
        }

        @Override
        public Void visit(UiEventNextGameDecision event) {
            HostedMatch.this.addNextGameDecision(event.getController(), event.getDecision());
            return null;
        }

        @Override
        public Void visit(GameEventSubgameStart event) {
            ++HostedMatch.this.subGameCount;
            event.subgame.subscribeToEvents(SoundSystem.instance);
            event.subgame.subscribeToEvents(HostedMatch.this.visitor);
            GameView gameView = event.subgame.getView();
            Runnable switchGameView = () -> {
                for (Player p : event.subgame.getPlayers()) {
                    if (!(p.getController() instanceof PlayerControllerHuman)) continue;
                    PlayerControllerHuman humanController = (PlayerControllerHuman)p.getController();
                    IGuiGame gui = (IGuiGame)HostedMatch.this.guis.get(p.getRegisteredPlayer());
                    humanController.setGui(gui);
                    gui.setGameView(null);
                    gui.setGameView(gameView);
                    gui.setOriginalGameController(p.getView(), humanController);
                    gui.openView(new TrackableCollection<PlayerView>(p.getView()));
                    gui.setGameView(null);
                    gui.setGameView(gameView);
                    event.subgame.subscribeToEvents(new FControlGameEventHandler(humanController));
                    gui.message(event.message);
                }
            };
            if (GuiBase.getInterface().isLibgdxPort()) {
                GuiBase.getInterface().invokeInEdtNow(switchGameView);
            } else {
                GuiBase.getInterface().invokeInEdtAndWait(switchGameView);
            }
            for (Player p : event.subgame.getPlayers()) {
                p.updateOpponentsForView();
            }
            return null;
        }

        @Override
        public Void visit(GameEventSubgameEnd event) {
            GameView gameView = event.maingame.getView();
            Runnable switchGameView = () -> {
                for (Player p : event.maingame.getPlayers()) {
                    if (!(p.getController() instanceof PlayerControllerHuman)) continue;
                    PlayerControllerHuman humanController = (PlayerControllerHuman)p.getController();
                    IGuiGame gui = (IGuiGame)HostedMatch.this.guis.get(p.getRegisteredPlayer());
                    gui.setGameView(null);
                    gui.setGameView(gameView);
                    gui.setOriginalGameController(p.getView(), humanController);
                    gui.openView(new TrackableCollection<PlayerView>(p.getView()));
                    gui.setGameView(null);
                    gui.setGameView(gameView);
                    gui.updatePhase(true);
                    gui.message(event.message);
                }
            };
            if (GuiBase.getInterface().isLibgdxPort()) {
                GuiBase.getInterface().invokeInEdtNow(switchGameView);
            } else {
                GuiBase.getInterface().invokeInEdtAndWait(switchGameView);
            }
            return null;
        }

        @Subscribe
        public void receiveEvent(UiEvent evt) {
            try {
                evt.visit(this);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }

        @Subscribe
        public void receiveGameEvent(GameEvent evt) {
            try {
                evt.visit(this);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

