/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.base.Predicate;
import forge.card.CardEdition;
import forge.game.GameFormat;
import forge.model.FModel;
import forge.util.TextUtil;
import forge.util.storage.StorageReaderFile;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ThemedChaosDraft
implements Comparable<ThemedChaosDraft> {
    private final String tag;
    private final String label;
    private final int orderNumber;
    private final Predicate<CardEdition> themedFilter = new Predicate<CardEdition>(){

        @Override
        public boolean apply(CardEdition cardEdition) {
            String[] themes;
            for (String theme : themes = cardEdition.getChaosDraftThemes()) {
                if (!ThemedChaosDraft.this.tag.equals(theme)) continue;
                return true;
            }
            return false;
        }
    };
    private static final Predicate<CardEdition> DEFAULT_FILTER = cardEdition -> {
        boolean isExpansion = cardEdition.getType().equals((Object)CardEdition.Type.EXPANSION);
        boolean isCoreSet = cardEdition.getType().equals((Object)CardEdition.Type.CORE);
        boolean isReprintSet = cardEdition.getType().equals((Object)CardEdition.Type.REPRINT);
        if ((isExpansion || isCoreSet || isReprintSet) && cardEdition.hasBoosterTemplate()) {
            List<Pair<String, Integer>> slots = cardEdition.getBoosterTemplate().getSlots();
            int boosterSize = 0;
            for (Pair<String, Integer> slot : slots) {
                boosterSize += slot.getRight().intValue();
            }
            return boosterSize == 15;
        }
        return false;
    };

    public ThemedChaosDraft(String tag, String label, int orderNumber) {
        this.tag = tag;
        this.label = label;
        this.orderNumber = orderNumber;
    }

    public String getTag() {
        return this.tag;
    }

    public String getLabel() {
        return this.label;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public Predicate<CardEdition> getEditionFilter() {
        Predicate<CardEdition> filter;
        switch (this.tag) {
            case "DEFAULT": {
                filter = DEFAULT_FILTER;
                break;
            }
            case "MODERN": 
            case "PIONEER": 
            case "STANDARD": {
                filter = this.getFormatFilter(this.tag);
                break;
            }
            default: {
                filter = this.themedFilter;
            }
        }
        return filter;
    }

    private Predicate<CardEdition> getFormatFilter(String formatName) {
        GameFormat format;
        GameFormat.Collection formats = FModel.getFormats();
        switch (formatName) {
            case "MODERN": {
                format = formats.getModern();
                break;
            }
            case "PIONEER": {
                format = formats.getPioneer();
                break;
            }
            default: {
                format = formats.getStandard();
            }
        }
        return cardEdition -> DEFAULT_FILTER.apply((CardEdition)cardEdition) && format.isSetLegal(cardEdition.getCode());
    }

    public String toString() {
        return this.label;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    @Override
    public int compareTo(ThemedChaosDraft other) {
        return this.orderNumber != other.orderNumber ? this.orderNumber - other.orderNumber : this.label.compareTo(other.label);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThemedChaosDraft other = (ThemedChaosDraft)obj;
        if (!this.label.equals(other.label)) {
            return false;
        }
        return this.tag.equals(other.tag);
    }

    public static class Reader
    extends StorageReaderFile<ThemedChaosDraft> {
        public Reader(String pathname) {
            super(pathname, ThemedChaosDraft::getTag);
        }

        @Override
        protected ThemedChaosDraft read(String line, int idx) {
            String[] sParts = TextUtil.splitWithParenthesis(line, ',', 3);
            int orderNumber = Integer.parseInt(sParts[0].trim(), 10);
            String tag = sParts[1].trim();
            String label = sParts[2].trim();
            return new ThemedChaosDraft(tag, label, orderNumber);
        }
    }
}

