/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.CardAiHints;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.deck.generation.DeckGeneratorBase;
import forge.gamemodes.limited.CardRanker;
import forge.gamemodes.limited.DeckColors;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public class LimitedDeckBuilder
extends DeckGeneratorBase {
    private final int numSpellsNeeded = 22;
    private int landsNeeded = 18;
    protected final DeckColors deckColors;
    protected Predicate<CardRules> hasColor;
    protected final List<PaperCard> availableList;
    protected final List<PaperCard> aiPlayables;
    protected final List<PaperCard> deckList = new ArrayList<PaperCard>();
    protected final List<String> setsWithBasicLands = new ArrayList<String>();
    protected List<PaperCard> rankedColorList;
    protected final List<PaperCard> draftedConspiracies;
    private Iterable<PaperCard> onColorCreatures;
    protected Iterable<PaperCard> onColorNonCreatures;
    protected static final boolean logToConsole = false;

    @Override
    protected final float getLandPercentage() {
        return 0.44f;
    }

    @Override
    protected final float getCreaturePercentage() {
        return 0.33f;
    }

    @Override
    protected final float getSpellPercentage() {
        return 0.23f;
    }

    public LimitedDeckBuilder(List<PaperCard> dList, DeckColors pClrs) {
        super(FModel.getMagicDb().getCommonCards(), DeckFormat.Limited);
        this.availableList = dList;
        this.deckColors = pClrs;
        this.colors = pClrs.getChosenColors();
        Iterable<PaperCard> playables = Iterables.filter(this.availableList, Predicates.compose(CardRulesPredicates.IS_KEPT_IN_AI_LIMITED_DECKS, PaperCard::getRules));
        this.aiPlayables = Lists.newArrayList(playables);
        this.availableList.removeAll(this.aiPlayables);
        Iterable<PaperCard> conspiracies = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.coreType(true, "Conspiracy"), PaperCard::getRules));
        this.draftedConspiracies = Lists.newArrayList(conspiracies);
        this.aiPlayables.removeAll(this.draftedConspiracies);
        this.findBasicLandSets();
    }

    public LimitedDeckBuilder(List<PaperCard> list) {
        this(list, new DeckColors());
    }

    @Override
    public CardPool getDeck(int size, boolean forAi) {
        return this.buildDeck().getMain();
    }

    public Deck buildDeck() {
        return this.buildDeck(null);
    }

    public Deck buildDeck(String landSetCode) {
        Iterable<PaperCard> nonLands;
        PaperCard card;
        this.hasColor = Predicates.or(new DeckGeneratorBase.MatchColorIdentity(this.colors), COLORLESS_CARDS);
        Iterable<PaperCard> colorList = Iterables.filter(this.aiPlayables, Predicates.compose(this.hasColor, PaperCard::getRules));
        this.rankedColorList = CardRanker.rankCardsInDeck(colorList);
        this.onColorCreatures = Iterables.filter(this.rankedColorList, Predicates.compose(CardRulesPredicates.Presets.IS_CREATURE, PaperCard::getRules));
        this.onColorNonCreatures = Iterables.filter(this.rankedColorList, Predicates.compose(CardRulesPredicates.Presets.IS_NON_CREATURE_SPELL, PaperCard::getRules));
        Iterable<PaperCard> onColorWalkers = Iterables.filter(colorList, Predicates.compose(CardRulesPredicates.Presets.IS_PLANESWALKER, PaperCard::getRules));
        ArrayList<PaperCard> walkers = Lists.newArrayList(onColorWalkers);
        this.deckList.addAll(walkers);
        this.aiPlayables.removeAll(walkers);
        this.rankedColorList.removeAll(walkers);
        if (walkers.size() > 0) {
            // empty if block
        }
        this.addManaCurveCreatures(this.onColorCreatures, 16);
        this.addNonCreatures(this.onColorNonCreatures, 22 - this.deckList.size());
        this.addCreatures(this.onColorCreatures, 22 - this.deckList.size());
        if (this.deckList.size() == 22 && LimitedDeckBuilder.getAverageCMC(this.deckList) < 4.0 && (card = (PaperCard)Iterables.getFirst(nonLands = Iterables.filter(this.rankedColorList, Predicates.compose(CardRulesPredicates.Presets.IS_NON_LAND, PaperCard::getRules)), null)) != null) {
            this.deckList.add(card);
            this.aiPlayables.remove(card);
            this.rankedColorList.remove(card);
            --this.landsNeeded;
        }
        this.addThirdColorCards(22 - this.deckList.size());
        this.addNonBasicLands();
        this.checkRemRandomDeckCards();
        int[] clrCnts = this.calculateLandNeeds();
        if (this.landsNeeded > 0) {
            this.addLands(clrCnts, landSetCode);
        }
        this.fixDeckSize(clrCnts, landSetCode);
        if (this.deckList.size() == 40) {
            Deck result = new Deck(this.generateName());
            result.getMain().add((Iterable<PaperCard>)this.deckList);
            CardPool cp = result.getOrCreate(DeckSection.Sideboard);
            cp.add((Iterable<PaperCard>)this.aiPlayables);
            cp.add((Iterable<PaperCard>)this.availableList);
            if (!this.draftedConspiracies.isEmpty()) {
                CardPool cpConsp = result.getOrCreate(DeckSection.Conspiracy);
                cpConsp.add((Iterable<PaperCard>)this.draftedConspiracies);
            }
            return result;
        }
        throw new RuntimeException("BoosterDraftAI : buildDeck() error, decksize not 40");
    }

    private String generateName() {
        return this.deckColors.toString();
    }

    private void debugFinalDeck() {
        int i = 0;
        System.out.println("DECK");
        for (PaperCard c : this.deckList) {
            System.out.println(++i + ". " + c.toString() + ": " + c.getRules().getManaCost().toString());
        }
        i = 0;
        System.out.println("NOT PLAYABLE");
        for (PaperCard c : this.availableList) {
            System.out.println(++i + ". " + c.toString() + ": " + c.getRules().getManaCost().toString());
        }
        i = 0;
        System.out.println("NOT PICKED");
        for (PaperCard c : this.aiPlayables) {
            System.out.println(++i + ". " + c.toString() + ": " + c.getRules().getManaCost().toString());
        }
    }

    private void fixDeckSize(int[] clrCnts, String landSetCode) {
        while (this.deckList.size() > 40) {
            PaperCard c = this.deckList.get(MyRandom.getRandom().nextInt(this.deckList.size() - 1));
            this.deckList.remove(c);
            this.aiPlayables.add(c);
        }
        block1: while (this.deckList.size() < 40) {
            if (this.aiPlayables.size() > 1) {
                PaperCard c = this.aiPlayables.get(MyRandom.getRandom().nextInt(this.aiPlayables.size() - 1));
                this.deckList.add(c);
                this.aiPlayables.remove(c);
                this.rankedColorList.remove(c);
                continue;
            }
            if (this.aiPlayables.size() == 1) {
                PaperCard c = this.aiPlayables.get(0);
                this.deckList.add(c);
                this.aiPlayables.remove(c);
                this.rankedColorList.remove(c);
                continue;
            }
            for (int i = 0; i < 5; ++i) {
                if (clrCnts[i] <= 0) continue;
                PaperCard cp = this.getBasicLand(i, landSetCode);
                this.deckList.add(cp);
                continue block1;
            }
        }
    }

    private void findBasicLandSets() {
        HashSet<String> sets = new HashSet<String>();
        for (PaperCard cp : this.aiPlayables) {
            CardEdition ee = FModel.getMagicDb().getEditions().get(cp.getEdition());
            if (sets.contains(cp.getEdition()) || !CardEdition.Predicates.hasBasicLands.apply(ee)) continue;
            sets.add(cp.getEdition());
        }
        this.setsWithBasicLands.addAll(sets);
        if (this.setsWithBasicLands.isEmpty()) {
            this.setsWithBasicLands.add("M13");
        }
    }

    private void addLands(int[] clrCnts, String landSetCode) {
        int i;
        Iterable<PaperCard> basicLands = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules));
        HashSet<PaperCard> snowLands = new HashSet<PaperCard>();
        int totalColor = 0;
        for (i = 0; i < 5; ++i) {
            totalColor += clrCnts[i];
        }
        if (totalColor == 0) {
            throw new RuntimeException("Add Lands to empty deck list!");
        }
        for (i = 0; i < 5; ++i) {
            if (clrCnts[i] <= 0) continue;
            int nLand = 2;
            System.out.printf("Basics[%s]: %d cards%n", MagicColor.Constant.BASIC_LANDS.get(i), nLand);
            for (int j = 0; j < nLand; ++j) {
                this.deckList.add(this.getBasicLand(i, landSetCode));
            }
        }
        for (i = 0; i < 5; ++i) {
            int slotsRemaining = 40 - this.deckList.size();
            if (clrCnts[i] <= 0) continue;
            float p = (float)clrCnts[i] / (float)totalColor;
            int nLand = Math.round((float)slotsRemaining * p);
            totalColor -= clrCnts[i];
            for (PaperCard cp : basicLands) {
                if (!cp.getName().equals(MagicColor.Constant.SNOW_LANDS.get(i))) continue;
                snowLands.add(cp);
                --nLand;
            }
            for (int j = 0; j < nLand; ++j) {
                this.deckList.add(this.getBasicLand(i, landSetCode));
            }
        }
        this.deckList.addAll(snowLands);
        this.aiPlayables.removeAll(snowLands);
    }

    private PaperCard getBasicLand(int basicLand, String landSetCode) {
        String set = landSetCode == null ? (this.setsWithBasicLands.size() > 1 ? this.setsWithBasicLands.get(MyRandom.getRandom().nextInt(this.setsWithBasicLands.size() - 1)) : this.setsWithBasicLands.get(0)) : landSetCode;
        return FModel.getMagicDb().getCommonCards().getCard((String)MagicColor.Constant.BASIC_LANDS.get(basicLand), set);
    }

    private int[] calculateLandNeeds() {
        int[] clrCnts = new int[]{0, 0, 0, 0, 0};
        for (PaperCard cp : this.deckList) {
            ManaCost mc = cp.getRules().getManaCost();
            for (ManaCostShard shard : mc) {
                for (int i = 0; i < MagicColor.WUBRG.length; ++i) {
                    byte c = MagicColor.WUBRG[i];
                    if (!shard.canBePaidWithManaOfColor(c) || !this.colors.hasAnyColor(c)) continue;
                    int n = i;
                    clrCnts[n] = clrCnts[n] + 1;
                }
            }
        }
        return clrCnts;
    }

    private void addNonBasicLands() {
        Iterable<PaperCard> lands = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_NONBASIC_LAND, PaperCard::getRules));
        ArrayList<PaperCard> landsToAdd = new ArrayList<PaperCard>();
        for (PaperCard card : lands) {
            if (this.landsNeeded <= 0 || !card.getRules().getDeckbuildingColors().hasNoColorsExcept(this.colors)) continue;
            landsToAdd.add(card);
            --this.landsNeeded;
        }
        this.deckList.addAll(landsToAdd);
        this.aiPlayables.removeAll(landsToAdd);
    }

    private void addThirdColorCards(int num) {
        if (num > 0) {
            Iterable<PaperCard> others = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_NON_LAND, PaperCard::getRules));
            List<PaperCard> rankedOthers = CardRanker.rankCardsInPack(others, this.deckList, this.colors, true);
            ArrayList<PaperCard> toAdd = new ArrayList<PaperCard>();
            for (PaperCard card : rankedOthers) {
                ColorSet off = this.colors.getOffColors(card.getRules().getColor());
                if (!off.isMonoColor()) continue;
                this.colors = ColorSet.fromMask(this.colors.getColor() | off.getColor());
                break;
            }
            this.hasColor = Predicates.or(new DeckGeneratorBase.MatchColorIdentity(this.colors), DeckGeneratorBase.COLORLESS_CARDS);
            Iterable<PaperCard> threeColorList = Iterables.filter(rankedOthers, Predicates.compose(this.hasColor, PaperCard::getRules));
            for (PaperCard card : threeColorList) {
                if (num <= 0) break;
                toAdd.add(card);
                --num;
            }
            this.deckList.addAll(toAdd);
            this.aiPlayables.removeAll(toAdd);
            this.rankedColorList.removeAll(toAdd);
        }
    }

    private void addRandomCards(int num) {
        Iterable<PaperCard> others = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_NON_LAND, PaperCard::getRules));
        ArrayList<PaperCard> toAdd = new ArrayList<PaperCard>();
        for (PaperCard card : others) {
            if (num <= 0) break;
            toAdd.add(card);
            --num;
        }
        this.deckList.addAll(toAdd);
        this.aiPlayables.removeAll(toAdd);
        this.rankedColorList.removeAll(toAdd);
    }

    private void addNonCreatures(Iterable<PaperCard> nonCreatures, int num) {
        ArrayList<PaperCard> toAdd = new ArrayList<PaperCard>();
        for (PaperCard card : nonCreatures) {
            if (num <= 0) break;
            toAdd.add(card);
            --num;
        }
        this.deckList.addAll(toAdd);
        this.aiPlayables.removeAll(toAdd);
        this.rankedColorList.removeAll(toAdd);
    }

    private void checkRemRandomDeckCards() {
        int numCreatures = 0;
        int numOthers = 0;
        ListIterator<PaperCard> it = this.deckList.listIterator();
        while (it.hasNext()) {
            PaperCard card = it.next();
            CardAiHints ai = card.getRules().getAiHints();
            if (!ai.getRemRandomDecks()) continue;
            ArrayList comboCards = new ArrayList();
            if (ai.getDeckNeeds() != null && ai.getDeckNeeds().isValid()) {
                Iterables.addAll(comboCards, ai.getDeckNeeds().filter(this.deckList));
            }
            if (ai.getDeckHints() != null && ai.getDeckHints().isValid()) {
                Iterables.addAll(comboCards, ai.getDeckHints().filter(this.deckList));
            }
            if (!comboCards.isEmpty()) continue;
            it.remove();
            this.availableList.add(card);
            if (card.getRules().getType().isCreature()) {
                ++numCreatures;
                continue;
            }
            if (card.getRules().getType().isLand()) continue;
            ++numOthers;
        }
        if (numCreatures > 0) {
            this.addCreatures(this.onColorCreatures, numCreatures);
        }
        if (numOthers > 0) {
            this.addNonCreatures(this.onColorNonCreatures, numOthers);
        }
        if ((numCreatures > 0 || numOthers > 0) && this.aiPlayables.size() > 0) {
            this.checkRemRandomDeckCards();
        }
    }

    private void addCreatures(Iterable<PaperCard> creatures, int num) {
        ArrayList<PaperCard> creaturesToAdd = new ArrayList<PaperCard>();
        for (PaperCard card : creatures) {
            if (num <= 0) break;
            creaturesToAdd.add(card);
            --num;
        }
        this.deckList.addAll(creaturesToAdd);
        this.aiPlayables.removeAll(creaturesToAdd);
        this.rankedColorList.removeAll(creaturesToAdd);
    }

    private void addManaCurveCreatures(Iterable<PaperCard> creatures, int num) {
        HashMap<Integer, Integer> creatureCosts = new HashMap<Integer, Integer>();
        for (int i = 1; i < 7; ++i) {
            creatureCosts.put(i, 0);
        }
        Predicate filter = Predicates.compose(CardRulesPredicates.Presets.IS_CREATURE, PaperCard::getRules);
        for (IPaperCard iPaperCard : Iterables.filter(this.deckList, filter)) {
            int cmc = iPaperCard.getRules().getManaCost().getCMC();
            if (cmc < 1) {
                cmc = 1;
            } else if (cmc > 6) {
                cmc = 6;
            }
            creatureCosts.put(cmc, (Integer)creatureCosts.get(cmc) + 1);
        }
        ArrayList<PaperCard> creaturesToAdd = new ArrayList<PaperCard>();
        for (PaperCard card : creatures) {
            int cmc = card.getRules().getManaCost().getCMC();
            if (cmc < 1) {
                cmc = 1;
            } else if (cmc > 6) {
                cmc = 6;
            }
            Integer currentAtCmc = (Integer)creatureCosts.get(cmc);
            boolean willAddCreature = false;
            if (cmc <= 1 && currentAtCmc < 2) {
                willAddCreature = true;
            } else if (cmc == 2 && currentAtCmc < 6) {
                willAddCreature = true;
            } else if (cmc == 3 && currentAtCmc < 7) {
                willAddCreature = true;
            } else if (cmc == 4 && currentAtCmc < 4) {
                willAddCreature = true;
            } else if (cmc == 5 && currentAtCmc < 3) {
                willAddCreature = true;
            } else if (cmc >= 6 && currentAtCmc < 2) {
                willAddCreature = true;
            }
            if (willAddCreature) {
                creaturesToAdd.add(card);
                --num;
                creatureCosts.put(cmc, (Integer)creatureCosts.get(cmc) + 1);
            }
            if (num > 0) continue;
            break;
        }
        this.deckList.addAll(creaturesToAdd);
        this.aiPlayables.removeAll(creaturesToAdd);
        this.rankedColorList.removeAll(creaturesToAdd);
    }

    private static double getAverageCMC(List<PaperCard> cards) {
        double sum = 0.0;
        for (IPaperCard iPaperCard : cards) {
            sum += (double)iPaperCard.getRules().getManaCost().getCMC();
        }
        return sum / (double)cards.size();
    }

    public ColorSet getColors() {
        return this.colors;
    }

    public void setColors(ColorSet colors) {
        this.colors = colors;
    }

    public List<PaperCard> getAiPlayables() {
        return this.aiPlayables;
    }
}

