/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.item.IPaperCard;
import java.util.List;

public class DeckColors {
    protected ColorSet chosen;
    protected int colorMask;
    public int MAX_COLORS = 2;

    DeckColors() {
    }

    DeckColors(int max_col) {
        this.MAX_COLORS = max_col;
    }

    public ColorSet getChosenColors() {
        if (null == this.chosen) {
            this.chosen = ColorSet.fromMask(this.colorMask);
        }
        return this.chosen;
    }

    public void addColorsOf(IPaperCard pickedCard) {
        boolean haveSpace;
        ColorSet colorsCanAdd = this.chosen.inverse();
        ColorSet toAdd = colorsCanAdd.getSharedColors(pickedCard.getRules().getDeckbuildingColors());
        int cntColorsAssigned = this.getChosenColors().countColors();
        boolean bl = haveSpace = cntColorsAssigned < this.MAX_COLORS;
        if (!haveSpace || toAdd.isColorless()) {
            return;
        }
        for (byte color : MagicColor.WUBRG) {
            if (toAdd.hasAnyColor(color)) {
                this.colorMask |= color;
                this.chosen = null;
                ++cntColorsAssigned;
            }
            if (cntColorsAssigned >= this.MAX_COLORS) break;
        }
    }

    public void setColorsByList(List<Byte> colors) {
        this.colorMask = 0;
        for (Byte col : colors) {
            this.colorMask |= col.byteValue();
        }
        this.chosen = null;
    }

    public boolean canChoseMoreColors() {
        return this.getChosenColors().countColors() < this.MAX_COLORS;
    }
}

