/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGenPool;
import forge.gamemodes.limited.CardThemedDeckBuilder;
import forge.item.PaperCard;
import forge.model.FModel;
import java.util.List;

public class CardThemedCommanderDeckBuilder
extends CardThemedDeckBuilder {
    public CardThemedCommanderDeckBuilder(PaperCard commanderCard0, PaperCard partner0, List<PaperCard> dList, boolean isForAI, DeckFormat format) {
        super(new DeckGenPool(FModel.getMagicDb().getCommonCards().getUniqueCards()), format);
        this.availableList = dList;
        this.keyCard = commanderCard0;
        this.secondKeyCard = partner0;
        if (isForAI) {
            Iterable playables = Iterables.filter(this.availableList, Predicates.compose(CardRulesPredicates.IS_KEPT_IN_AI_DECKS, PaperCard::getRules));
            this.aiPlayables = Lists.newArrayList(playables);
        } else {
            this.aiPlayables = Lists.newArrayList(this.availableList);
        }
        this.availableList.removeAll(this.aiPlayables);
        this.targetSize = format.getMainRange().getMinimum();
        this.colors = this.keyCard.getRules().getColorIdentity();
        this.colors = ColorSet.fromMask(this.colors.getColor() | this.keyCard.getRules().getColorIdentity().getColor());
        if (this.secondKeyCard != null && !format.equals((Object)DeckFormat.Oathbreaker)) {
            this.colors = ColorSet.fromMask(this.colors.getColor() | this.secondKeyCard.getRules().getColorIdentity().getColor());
            --this.targetSize;
        }
        this.numSpellsNeeded = Double.valueOf(Math.floor((float)this.targetSize * (this.getCreaturePercentage() + this.getSpellPercentage()))).intValue();
        this.numCreaturesToStart = Double.valueOf(Math.ceil((float)this.targetSize * this.getCreaturePercentage())).intValue();
        this.landsNeeded = Double.valueOf(Math.ceil((float)this.targetSize * this.getLandPercentage())).intValue();
        this.findBasicLandSets();
    }

    @Override
    protected void addKeyCards() {
    }

    @Override
    protected void addLandKeyCards() {
    }

    @Override
    protected void addThirdColorCards(int num) {
    }

    @Override
    protected void updateColors() {
    }

    @Override
    protected String generateName() {
        return this.keyCard.getName() + " based commander deck";
    }
}

