/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.card.ColorSet;
import forge.deck.Deck;
import forge.gamemodes.limited.BoosterDeckBuilder;
import forge.gamemodes.limited.CardRanker;
import forge.gamemodes.limited.DeckColors;
import forge.gamemodes.limited.IBoosterDraft;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import java.util.ArrayList;
import java.util.List;

public class BoosterDraftAI {
    private IBoosterDraft bd = null;
    protected static final int N_DECKS = 7;
    protected final List<List<PaperCard>> decks = new ArrayList<List<PaperCard>>();
    protected final List<DeckColors> playerColors = new ArrayList<DeckColors>();

    public PaperCard choose(List<PaperCard> chooseFrom, int player) {
        if (ForgePreferences.DEV_MODE) {
            System.out.println("Player[" + player + "] pack: " + chooseFrom.toString());
        }
        List<PaperCard> deck = this.decks.get(player);
        DeckColors deckCols = this.playerColors.get(player);
        ColorSet chosenColors = deckCols.getChosenColors();
        boolean canAddMoreColors = deckCols.canChoseMoreColors();
        List<PaperCard> rankedCards = CardRanker.rankCardsInPack(chooseFrom, deck, chosenColors, canAddMoreColors);
        PaperCard bestPick = rankedCards.get(0);
        if (canAddMoreColors) {
            deckCols.addColorsOf(bestPick);
        }
        if (ForgePreferences.DEV_MODE) {
            System.out.println("Player[" + player + "] picked: " + bestPick);
        }
        this.decks.get(player).add(bestPick);
        return bestPick;
    }

    public Deck[] getDecks() {
        Deck[] out = new Deck[this.decks.size()];
        for (int i = 0; i < this.decks.size(); ++i) {
            if (ForgePreferences.DEV_MODE) {
                System.out.println("Deck[" + i + "]");
            }
            out[i] = new BoosterDeckBuilder(this.decks.get(i), this.playerColors.get(i)).buildDeck();
        }
        return out;
    }

    public BoosterDraftAI() {
        for (int i = 0; i < 7; ++i) {
            this.decks.add(new ArrayList());
            this.playerColors.add(new DeckColors());
        }
    }

    public IBoosterDraft getBd() {
        return this.bd;
    }

    public void setBd(IBoosterDraft bd0) {
        this.bd = bd0;
    }
}

