/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.CardEdition;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.gamemodes.limited.CustomLimited;
import forge.gamemodes.limited.DraftPack;
import forge.gamemodes.limited.IBoosterDraft;
import forge.gamemodes.limited.IDraftLog;
import forge.gamemodes.limited.LimitedPlayer;
import forge.gamemodes.limited.LimitedPlayerAI;
import forge.gamemodes.limited.LimitedPoolType;
import forge.gamemodes.limited.ThemedChaosDraft;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.ChaosBoosterSupplier;
import forge.item.generation.IUnOpenedProduct;
import forge.item.generation.UnOpenedProduct;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.CardBlock;
import forge.model.FModel;
import forge.util.FileUtil;
import forge.util.ItemPool;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.storage.IStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;

public class BoosterDraft
implements IBoosterDraft {
    private int nextId = 0;
    private static final int N_PLAYERS = 8;
    public static final String FILE_EXT = ".draft";
    private final List<LimitedPlayer> players = new ArrayList<LimitedPlayer>();
    private final LimitedPlayer localPlayer;
    private IDraftLog draftLog = null;
    private String doublePickDuringDraft = "";
    protected int nextBoosterGroup = 0;
    private int currentBoosterSize = 0;
    private int currentBoosterPick = 0;
    private int packsInDraft;
    private final Map<String, Float> draftPicks = new TreeMap<String, Float>();
    static final List<CustomLimited> customs = new ArrayList<CustomLimited>();
    protected LimitedPoolType draftFormat;
    protected final List<Supplier<List<PaperCard>>> product = new ArrayList<Supplier<List<PaperCard>>>();

    public static void initializeCustomDrafts() {
        BoosterDraft.loadCustomDrafts();
    }

    public static BoosterDraft createDraft(LimitedPoolType draftType) {
        BoosterDraft draft = new BoosterDraft(draftType);
        if (!draft.generateProduct()) {
            return null;
        }
        draft.initializeBoosters();
        return draft;
    }

    protected boolean generateProduct() {
        switch (this.draftFormat) {
            case Full: {
                UnOpenedProduct s2 = new UnOpenedProduct(SealedTemplate.genericDraftBooster);
                for (int i = 0; i < 3; ++i) {
                    this.product.add(s2);
                }
                IBoosterDraft.LAND_SET_CODE[0] = CardEdition.Predicates.getRandomSetWithAllBasicLands(FModel.getMagicDb().getEditions());
                IBoosterDraft.CUSTOM_RANKINGS_FILE[0] = null;
                break;
            }
            case Block: 
            case FantasyBlock: {
                ArrayList<CardBlock> blocks = new ArrayList<CardBlock>();
                IStorage<CardBlock> storage = this.draftFormat == LimitedPoolType.Block ? FModel.getBlocks() : FModel.getFantasyBlocks();
                for (CardBlock b : storage) {
                    if (b.getCntBoostersDraft() <= 0) continue;
                    blocks.add(b);
                }
                CardBlock block = (CardBlock)SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseBlock", new Object[0]), blocks);
                if (block == null) {
                    return false;
                }
                List<CardEdition> cardSets = block.getSets();
                Stack<String> sets = new Stack<String>();
                for (int k = cardSets.size() - 1; k >= 0; --k) {
                    sets.add(cardSets.get(k).getCode());
                }
                for (String setCode : block.getMetaSetNames()) {
                    if (!block.getMetaSet(setCode).isDraftable()) continue;
                    sets.push(setCode);
                }
                if (sets.isEmpty()) {
                    SOptionPane.showErrorDialog(Localizer.getInstance().getMessage("lblBlockNotContainSetCombinations", block.toString()));
                    return false;
                }
                int nPacks = block.getCntBoostersDraft();
                if (sets.size() > 1) {
                    String p = nPacks == 3 && sets.size() < 4 ? SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseSetCombination", new Object[0]), BoosterDraft.getSetCombos(sets)) : BoosterDraft.choosePackByPack(sets, nPacks);
                    if (p == null) {
                        return false;
                    }
                    String[] pp = p.toString().split("/");
                    for (int i = 0; i < nPacks; ++i) {
                        this.product.add(block.getBooster(pp[i]));
                    }
                } else {
                    String setCode;
                    setCode = (String)sets.get(0);
                    CardEdition edition = FModel.getMagicDb().getEditions().get(setCode);
                    if (edition != null) {
                        this.doublePickDuringDraft = edition.getDoublePickDuringDraft();
                    }
                    IUnOpenedProduct product1 = block.getBooster(setCode);
                    for (int i = 0; i < nPacks; ++i) {
                        this.product.add(product1);
                    }
                }
                IBoosterDraft.LAND_SET_CODE[0] = block.getLandSet();
                IBoosterDraft.CUSTOM_RANKINGS_FILE[0] = null;
                break;
            }
            case Custom: {
                List<CustomLimited> myDrafts = BoosterDraft.loadCustomDrafts();
                if (myDrafts.isEmpty()) {
                    SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblNotFoundCustomDraftFiles", new Object[0]));
                    break;
                }
                myDrafts.sort(Comparator.comparing(DeckBase::getName));
                CustomLimited customDraft = SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseCustomDraft", new Object[0]), myDrafts);
                if (customDraft == null) {
                    return false;
                }
                this.setupCustomDraft(customDraft);
                break;
            }
            case Chaos: {
                ChaosBoosterSupplier ChaosDraftSupplier;
                ThemedChaosDraft theme2;
                ArrayList<ThemedChaosDraft> themes = new ArrayList<ThemedChaosDraft>();
                IStorage<ThemedChaosDraft> themeStorage = FModel.getThemedChaosDrafts();
                for (ThemedChaosDraft theme2 : themeStorage) {
                    themes.add(theme2);
                }
                Collections.sort(themes);
                String dialogQuestion = Localizer.getInstance().getMessage("lblChooseChaosTheme", new Object[0]);
                theme2 = (ThemedChaosDraft)SGuiChoose.oneOrNone(dialogQuestion, themes);
                if (theme2 == null) {
                    return false;
                }
                Predicate<CardEdition> themeFilter = theme2.getEditionFilter();
                CardEdition.Collection allEditions = StaticData.instance().getEditions();
                Iterable<CardEdition> chaosDraftEditions = Iterables.filter(allEditions.getOrderedEditions(), themeFilter);
                try {
                    ChaosDraftSupplier = new ChaosBoosterSupplier(chaosDraftEditions);
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e.getMessage());
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    this.product.add(ChaosDraftSupplier);
                }
                break;
            }
            default: {
                throw new NoSuchElementException("Draft for mode " + (Object)((Object)this.draftFormat) + " has not been set up!");
            }
        }
        return true;
    }

    public static BoosterDraft createDraft(LimitedPoolType draftType, CardBlock block, String[] boosters) {
        BoosterDraft draft = new BoosterDraft(draftType);
        for (String booster : boosters) {
            try {
                draft.product.add(block.getBooster(booster));
            }
            catch (Exception ex) {
                System.err.println("Booster Draft Error: " + ex.getMessage());
            }
        }
        IBoosterDraft.LAND_SET_CODE[0] = block.getLandSet();
        IBoosterDraft.CUSTOM_RANKINGS_FILE[0] = null;
        draft.initializeBoosters();
        return draft;
    }

    protected BoosterDraft() {
        this(LimitedPoolType.Full);
    }

    protected BoosterDraft(LimitedPoolType draftType) {
        this(draftType, 8);
    }

    protected BoosterDraft(LimitedPoolType draftType, int numPlayers) {
        this.draftFormat = draftType;
        this.localPlayer = new LimitedPlayer(0, this);
        this.players.add(this.localPlayer);
        for (int i = 1; i < numPlayers; ++i) {
            this.players.add(new LimitedPlayerAI(i, this));
        }
    }

    @Override
    public DraftPack addBooster(CardEdition edition) {
        UnOpenedProduct product = new UnOpenedProduct(FModel.getMagicDb().getBoosters().get(edition.getCode()));
        return new DraftPack((List<PaperCard>)product.get(), this.nextId++);
    }

    @Override
    public boolean isPileDraft() {
        return false;
    }

    @Override
    public void setLogEntry(IDraftLog draftingProcess) {
        this.draftLog = draftingProcess;
    }

    @Override
    public IDraftLog getDraftLog() {
        return this.draftLog;
    }

    @Override
    public int getRound() {
        return this.nextBoosterGroup;
    }

    @Override
    public LimitedPlayer getNeighbor(LimitedPlayer player, boolean left) {
        return this.players.get((player.order + (left ? 1 : -1) + 8) % 8);
    }

    private void setupCustomDraft(CustomLimited draft) {
        ItemPool<PaperCard> dPool = draft.getCardPool();
        if (dPool == null) {
            throw new RuntimeException("BoosterGenerator : deck not found");
        }
        SealedTemplate tpl = draft.getSealedProductTemplate();
        UnOpenedProduct toAdd = new UnOpenedProduct(tpl, dPool);
        toAdd.setLimitedPool(draft.isSingleton());
        for (int i = 0; i < draft.getNumPacks(); ++i) {
            this.product.add(toAdd);
        }
        IBoosterDraft.LAND_SET_CODE[0] = FModel.getMagicDb().getEditions().get(draft.getLandSetCode());
        IBoosterDraft.CUSTOM_RANKINGS_FILE[0] = draft.getCustomRankingsFileName();
    }

    private static List<CustomLimited> loadCustomDrafts() {
        if (customs.isEmpty()) {
            String[] dList;
            File dFolder = new File(ForgeConstants.DRAFT_DIR);
            if (!dFolder.exists()) {
                throw new RuntimeException("BoosterDraft : folder not found -- folder is " + dFolder.getAbsolutePath());
            }
            if (!dFolder.isDirectory()) {
                throw new RuntimeException("BoosterDraft : not a folder -- " + dFolder.getAbsolutePath());
            }
            for (String element : dList = dFolder.list()) {
                if (!element.endsWith(FILE_EXT)) continue;
                List<String> dfData = FileUtil.readFile(ForgeConstants.DRAFT_DIR + element);
                customs.add(CustomLimited.parse(dfData, FModel.getDecks().getCubes()));
            }
        }
        return customs;
    }

    @Override
    public CardPool nextChoice() {
        if (this.isRoundOver() && !this.startRound()) {
            return null;
        }
        this.computerChoose();
        CardPool result = new CardPool();
        DraftPack nextChoice = this.localPlayer.nextChoice();
        if (nextChoice != null && !nextChoice.isEmpty()) {
            result.addAllFlat(nextChoice);
        }
        if (result.isEmpty()) {
            this.passPacks();
            return this.nextChoice();
        }
        return result;
    }

    public void initializeBoosters() {
        for (Supplier<List<PaperCard>> boosterRound : this.product) {
            for (int i = 0; i < 8; ++i) {
                DraftPack pack = new DraftPack(boosterRound.get(), this.nextId++);
                this.players.get(i).receiveUnopenedPack(pack);
            }
        }
        this.startRound();
    }

    public boolean startRound() {
        ++this.nextBoosterGroup;
        this.currentBoosterPick = 0;
        this.packsInDraft = this.players.size();
        LimitedPlayer firstPlayer = this.players.get(0);
        if (firstPlayer.unopenedPacks.isEmpty()) {
            return false;
        }
        for (LimitedPlayer pl : this.players) {
            pl.newPack();
        }
        if (this.getDraftLog() != null) {
            this.getDraftLog().addLogEntry("Round " + this.nextBoosterGroup + " is starting...");
        }
        this.currentBoosterSize = firstPlayer.packQueue.peek().size();
        return true;
    }

    @Override
    public Deck[] getDecks() {
        Deck[] decks = new Deck[7];
        for (int i = 1; i < 8; ++i) {
            decks[i - 1] = ((LimitedPlayerAI)this.players.get(i)).buildDeck(IBoosterDraft.LAND_SET_CODE[0] != null ? IBoosterDraft.LAND_SET_CODE[0].getCode() : null);
        }
        return decks;
    }

    @Override
    public LimitedPlayer[] getOpposingPlayers() {
        return this.players.toArray(new LimitedPlayer[7]);
    }

    @Override
    public LimitedPlayer getHumanPlayer() {
        return this.localPlayer;
    }

    @Override
    public LimitedPlayer getPlayer(int i) {
        if (i == 0) {
            return this.localPlayer;
        }
        return this.players.get(i - 1);
    }

    public void passPacks() {
        int adjust;
        int n = adjust = this.nextBoosterGroup % 2 == 1 ? 1 : -1;
        if ("FirstPick".equals(this.doublePickDuringDraft) && this.currentBoosterPick == 1) {
            adjust = 0;
        } else if (this.currentBoosterPick % 2 == 1 && "Always".equals(this.doublePickDuringDraft)) {
            adjust = 0;
        }
        ArrayList<LimitedPlayer> dredgers = new ArrayList<LimitedPlayer>();
        for (LimitedPlayer pl : this.players) {
            if (!pl.hasCanalDredger()) continue;
            dredgers.add(pl);
        }
        for (int i = 0; i < 8; ++i) {
            LimitedPlayer pl;
            pl = this.players.get(i);
            DraftPack passingPack = pl.passPack();
            if (passingPack == null) continue;
            LimitedPlayer passToPlayer = null;
            if (passingPack.isEmpty()) {
                --this.packsInDraft;
                continue;
            }
            if (passingPack.size() == 1) {
                if (dredgers.size() == 1) {
                    passToPlayer = (LimitedPlayer)dredgers.get(0);
                } else if (dredgers.size() > 1) {
                    if (dredgers.contains(pl)) {
                        passToPlayer = pl;
                    } else if (pl instanceof LimitedPlayerAI) {
                        Collections.shuffle(dredgers);
                        passToPlayer = (LimitedPlayer)dredgers.get(0);
                    } else {
                        passToPlayer = (LimitedPlayer)SGuiChoose.one("Which player with Canal Dredger should we pass the last card to?", dredgers);
                    }
                }
            }
            if (passToPlayer == null) {
                passToPlayer = this.players.get((i + adjust + 8) % 8);
            }
            passToPlayer.receiveOpenedPack(passingPack);
        }
    }

    protected void computerChoose() {
        for (int i = 1; i < 8; ++i) {
            Boolean passPack;
            LimitedPlayer pl = this.players.get(i);
            if (pl.shouldSkipThisPick()) continue;
            while ((passPack = pl.draftCard(pl.chooseCard())) != null && !passPack.booleanValue()) {
            }
        }
    }

    public int getCurrentBoosterIndex() {
        return this.localPlayer.currentPack;
    }

    @Override
    public boolean isRoundOver() {
        return this.packsInDraft == 0;
    }

    @Override
    public boolean hasNextChoice() {
        return !this.isRoundOver() || !this.localPlayer.unopenedPacks.isEmpty();
    }

    @Override
    public boolean setChoice(PaperCard c) {
        DraftPack thisBooster = this.localPlayer.nextChoice();
        if (!thisBooster.contains(c)) {
            throw new RuntimeException("BoosterDraft : setChoice() error - card not found - " + c + " - booster pack = " + thisBooster);
        }
        this.recordDraftPick(thisBooster, c);
        boolean passPack = this.localPlayer.draftCard(c);
        if (passPack) {
            this.passPacks();
        }
        ++this.currentBoosterPick;
        return passPack;
    }

    @Override
    public void postDraftActions() {
        ArrayList<LimitedPlayer> brokers = new ArrayList<LimitedPlayer>();
        for (LimitedPlayer pl : this.players) {
            if (!pl.hasBrokers()) continue;
            brokers.add(pl);
        }
        Collections.shuffle(brokers);
        for (LimitedPlayer pl : brokers) {
            pl.activateBrokers(this.players);
        }
    }

    private static String choosePackByPack(List<String> setz, int packs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= packs; ++i) {
            String choice = SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseSetForNPack", String.valueOf(i), String.valueOf(packs)), setz);
            if (choice == null) {
                return null;
            }
            sb.append(choice);
            if (i == packs) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    private static List<String> getSetCombos(List<String> setz) {
        String[] sets = setz.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        ArrayList<String> setCombos = new ArrayList<String>();
        if (sets.length >= 2) {
            setCombos.add(TextUtil.concatNoSpace(sets[0], "/", sets[0], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[0], "/", sets[0], "/", sets[1]));
            setCombos.add(TextUtil.concatNoSpace(sets[0], "/", sets[1], "/", sets[1]));
            if (sets.length >= 3) {
                setCombos.add(TextUtil.concatNoSpace(sets[0], "/", sets[1], "/", sets[2]));
                setCombos.add(TextUtil.concatNoSpace(sets[0], "/", sets[2], "/", sets[2]));
            }
            setCombos.add(TextUtil.concatNoSpace(sets[1], "/", sets[0], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[1], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[1], "/", sets[1], "/", sets[1]));
            if (sets.length >= 3) {
                setCombos.add(TextUtil.concatNoSpace(sets[1], "/", sets[1], "/", sets[2]));
                setCombos.add(TextUtil.concatNoSpace(sets[1], "/", sets[2], "/", sets[2]));
            }
        }
        if (sets.length >= 3) {
            setCombos.add(TextUtil.concatNoSpace(sets[2], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[2], "/", sets[2], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[2], "/", sets[2], "/", sets[1]));
            setCombos.add(TextUtil.concatNoSpace(sets[2], "/", sets[2], "/", sets[2]));
        }
        if (sets.length >= 4) {
            setCombos.add(TextUtil.concatNoSpace(sets[3], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], "/", sets[2], "/", sets[1]));
        }
        if (sets.length >= 5) {
            setCombos.add(TextUtil.concatNoSpace(sets[4], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], "/", sets[3], "/", sets[2]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], "/", sets[2], "/", sets[0]));
        }
        if (sets.length >= 6) {
            setCombos.add(TextUtil.concatNoSpace(sets[5], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[5], "/", sets[3], "/", sets[2]));
            setCombos.add(TextUtil.concatNoSpace(sets[5], "/", sets[4], "/", sets[3]));
            setCombos.add(TextUtil.concatNoSpace(sets[5], "/", sets[2], "/", sets[0]));
        }
        if (sets.length >= 7) {
            setCombos.add(TextUtil.concatNoSpace(sets[6], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[6], "/", sets[3], "/", sets[2]));
            setCombos.add(TextUtil.concatNoSpace(sets[6], "/", sets[5], "/", sets[4]));
            setCombos.add(TextUtil.concatNoSpace(sets[6], "/", sets[3], "/", sets[0]));
        }
        if (sets.length >= 8) {
            setCombos.add(TextUtil.concatNoSpace(sets[7], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[7], "/", sets[3], "/", sets[2]));
            setCombos.add(TextUtil.concatNoSpace(sets[7], "/", sets[5], "/", sets[4]));
            setCombos.add(TextUtil.concatNoSpace(sets[7], "/", sets[6], "/", sets[5]));
            setCombos.add(TextUtil.concatNoSpace(sets[7], "/", sets[3], "/", sets[0]));
        }
        if (sets.length >= 9) {
            setCombos.add(TextUtil.concatNoSpace(sets[8], "/", sets[1], "/", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[8], "/", sets[3], "/", sets[2]));
            setCombos.add(TextUtil.concatNoSpace(sets[8], "/", sets[5], "/", sets[4]));
            setCombos.add(TextUtil.concatNoSpace(sets[8], "/", sets[7], "/", sets[6]));
            setCombos.add(TextUtil.concatNoSpace(sets[8], "/", sets[4], "/", sets[0]));
        }
        return setCombos;
    }

    private void recordDraftPick(List<PaperCard> thisBooster, PaperCard c) {
        if (!ForgePreferences.UPLOAD_DRAFT) {
            return;
        }
        for (int i = 0; i < thisBooster.size(); ++i) {
            PaperCard cc = thisBooster.get(i);
            String cnBk = cc.getName() + "|" + cc.getEdition();
            float pickValue = cc.equals(c) ? (float)thisBooster.size() * (1.0f - (float)this.currentBoosterPick / (float)this.currentBoosterSize * 2.0f) : 0.0f;
            if (!this.draftPicks.containsKey(cnBk)) {
                this.draftPicks.put(cnBk, Float.valueOf(pickValue));
                continue;
            }
            float curValue = this.draftPicks.get(cnBk).floatValue();
            float newValue = (curValue + pickValue) / 2.0f;
            this.draftPicks.put(cnBk, Float.valueOf(newValue));
        }
    }
}

