/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.gauntlet;

import forge.deck.Deck;
import forge.deck.DeckType;
import forge.deck.DeckgenUtil;
import forge.deck.NetDeckCategory;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.model.FModel;
import forge.util.MyRandom;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class GauntletUtil {
    public static GauntletData createQuickGauntlet(Deck userDeck, int numOpponents, List<DeckType> allowedDeckTypes, NetDeckCategory netDecks) {
        GauntletData gauntlet = new GauntletData();
        GauntletUtil.setDefaultGauntletName(gauntlet, "Quick_");
        FModel.setGauntletData(gauntlet);
        ArrayList<String> eventNames = new ArrayList<String>();
        ArrayList<Deck> decks = new ArrayList<Deck>();
        Object[] netDeckNames = netDecks != null ? netDecks.getItemNames().toArray() : null;
        block18: for (int i = 0; i < numOpponents; ++i) {
            Deck deck;
            int randType = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allowedDeckTypes.size());
            switch (allowedDeckTypes.get(randType)) {
                case COLOR_DECK: {
                    deck = DeckgenUtil.getRandomColorDeck(true);
                    eventNames.add("Random colors deck");
                    break;
                }
                case STANDARD_COLOR_DECK: {
                    deck = DeckgenUtil.getRandomColorDeck(FModel.getFormats().getStandard().getFilterPrinted(), true);
                    break;
                }
                case STANDARD_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getStandard(), true);
                    break;
                }
                case PIONEER_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getPioneer(), true);
                    break;
                }
                case HISTORIC_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getHistoric(), true);
                    break;
                }
                case MODERN_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getModern(), true);
                    break;
                }
                case LEGACY_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck((GameFormat)FModel.getFormats().get("Legacy"), true);
                    break;
                }
                case VINTAGE_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck((GameFormat)FModel.getFormats().get("Vintage"), true);
                    break;
                }
                case PAUPER_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getPauper(), true);
                    break;
                }
                case MODERN_COLOR_DECK: {
                    deck = DeckgenUtil.getRandomColorDeck(FModel.getFormats().getModern().getFilterPrinted(), true);
                    break;
                }
                case PAUPER_COLOR_DECK: {
                    deck = DeckgenUtil.getRandomColorDeck(FModel.getFormats().getPauper().getFilterPrinted(), true);
                    break;
                }
                case CUSTOM_DECK: {
                    deck = DeckgenUtil.getRandomCustomDeck();
                    if (deck != null) {
                        eventNames.add(deck.getName());
                        break;
                    }
                }
                case PRECONSTRUCTED_DECK: {
                    deck = DeckgenUtil.getRandomPreconDeck();
                    eventNames.add(deck.getName());
                    break;
                }
                case QUEST_OPPONENT_DECK: {
                    deck = DeckgenUtil.getRandomQuestDeck();
                    eventNames.add(deck.getName());
                    break;
                }
                case THEME_DECK: {
                    deck = DeckgenUtil.getRandomThemeDeck();
                    eventNames.add(deck.getName());
                    break;
                }
                case NET_DECK: {
                    int deckIndex = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)netDeckNames.length);
                    deck = (Deck)netDecks.get((String)netDeckNames[deckIndex]);
                    eventNames.add(deck.getName());
                    break;
                }
                default: {
                    continue block18;
                }
            }
            decks.add(deck);
        }
        gauntlet.setDecks(decks);
        gauntlet.setEventNames(eventNames);
        gauntlet.setUserDeck(userDeck);
        gauntlet.reset();
        return gauntlet;
    }

    public static GauntletData createCommanderGauntlet(Deck userDeck, int numOpponents, List<DeckType> allowedDeckTypes, NetDeckCategory netDecks) {
        GauntletData gauntlet = new GauntletData(true);
        GauntletUtil.setDefaultGauntletName(gauntlet, "Commander_");
        FModel.setGauntletData(gauntlet);
        ArrayList<String> eventNames = new ArrayList<String>();
        ArrayList<Deck> decks = new ArrayList<Deck>();
        Object[] netDeckNames = netDecks != null ? netDecks.getItemNames().toArray() : null;
        block5: for (int i = 0; i < numOpponents; ++i) {
            Deck deck;
            int randType = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allowedDeckTypes.size());
            switch (allowedDeckTypes.get(randType)) {
                case RANDOM_COMMANDER_DECK: {
                    deck = DeckgenUtil.generateCommanderDeck(true, GameType.Commander);
                    eventNames.add(deck.getName());
                    break;
                }
                case PRECON_COMMANDER_DECK: {
                    deck = DeckgenUtil.getRandomCommanderPreconDeck();
                    eventNames.add(deck.getName());
                    break;
                }
                case COMMANDER_DECK: {
                    deck = DeckgenUtil.getCommanderDeck();
                    if (deck == null) break;
                    eventNames.add(deck.getName());
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (deck == null) continue;
            decks.add(deck);
        }
        gauntlet.setDecks(decks);
        gauntlet.setEventNames(eventNames);
        gauntlet.setUserDeck(userDeck);
        gauntlet.reset();
        return gauntlet;
    }

    public static void setDefaultGauntletName(GauntletData gauntlet, String prefix) {
        File[] arrFiles = GauntletIO.getGauntletFilesUnlocked(prefix);
        HashSet<String> setNames = new HashSet<String>();
        for (File f : arrFiles) {
            setNames.add(f.getName());
        }
        int num = 1;
        while (setNames.contains(prefix + num + ".dat")) {
            ++num;
        }
        gauntlet.setName(prefix + num);
    }
}

