/*
 * Decompiled with CFR 0.152.
 */
package forge.game.zone;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.GameType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.event.EventValueChangeType;
import forge.game.event.GameEventZone;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.util.CollectionSuppliers;
import forge.util.MyRandom;
import forge.util.maps.EnumMapOfLists;
import forge.util.maps.MapOfLists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Zone
implements Serializable,
Iterable<Card> {
    private static final long serialVersionUID = -5687652485777639176L;
    private final CardCollection cardList = new CardCollection();
    protected final ZoneType zoneType;
    protected final Game game;
    protected final transient MapOfLists<ZoneType, Card> cardsAddedThisTurn = new EnumMapOfLists(ZoneType.class, CollectionSuppliers.arrayLists());
    protected final transient MapOfLists<ZoneType, Card> cardsAddedLastTurn = new EnumMapOfLists(ZoneType.class, CollectionSuppliers.arrayLists());

    public Zone(ZoneType zone0, Game game0) {
        this.zoneType = zone0;
        this.game = game0;
    }

    protected void onChanged() {
    }

    public Player getPlayer() {
        return null;
    }

    public final void reorder(Card c, int index) {
        this.cardList.remove(c);
        this.cardList.add(index, c);
    }

    public final void add(Card c) {
        this.add(c, null);
    }

    public final void add(Card c, Integer index) {
        this.add(c, index, null);
    }

    public void add(Card c, Integer index, Card latestState) {
        this.add(c, index, latestState, false);
    }

    public void add(Card c, Integer index, Card latestState, boolean rollback) {
        if (index != null && this.cardList.isEmpty() && index > 0) {
            System.out.println("Warning: tried to add a card to zone with a specific non-zero index, but the zone was empty! Canceling Zone#add to avoid a crash.");
            return;
        }
        if (index == null && this.zoneType == ZoneType.Command && c.isCommander()) {
            index = 0;
            if (this.game.getRules().hasAppliedVariant(GameType.Oathbreaker) && c.getRules().canBeSignatureSpell() && !this.cardList.isEmpty() && ((Card)this.cardList.get(false)).isCommander()) {
                index = 1;
            }
        }
        if (!rollback) {
            if (!c.isImmutable()) {
                ZoneType zt;
                Zone oldZone = this.game.getZoneOf(c);
                ZoneType zoneType = zt = oldZone == null ? ZoneType.Stack : oldZone.getZoneType();
                if (zt != this.zoneType) {
                    c.setTurnInController(this.getPlayer());
                    c.setTurnInZone(this.game.getPhaseHandler().getTurn());
                    if (latestState != null) {
                        this.cardsAddedThisTurn.add(zt, latestState);
                    }
                }
            }
            if (this.zoneType != ZoneType.Battlefield) {
                c.setTapped(false);
            }
            if (this.zoneType == ZoneType.Graveyard && c.isPermanent() && !c.isToken()) {
                c.getOwner().descend();
            }
        }
        c.setZone(this);
        if (this.zoneType == ZoneType.Battlefield || !c.isToken() || this.zoneType == ZoneType.Stack && c.getCopiedPermanent() != null) {
            if (index == null) {
                this.cardList.add(c);
            } else {
                this.cardList.add((int)index, c);
            }
        }
        this.onChanged();
        this.game.fireEvent(new GameEventZone(this.zoneType, this.getPlayer(), EventValueChangeType.Added, c));
    }

    public final boolean contains(Card c) {
        return this.cardList.contains(c);
    }

    public final boolean contains(Predicate<Card> condition) {
        return Iterables.any(this.cardList, condition);
    }

    public void remove(Card c) {
        if (this.cardList.remove(c)) {
            this.onChanged();
            this.game.fireEvent(new GameEventZone(this.zoneType, this.getPlayer(), EventValueChangeType.Removed, c));
        }
    }

    public final void setCards(Iterable<Card> cards) {
        this.cardList.clear();
        for (Card c : cards) {
            c.setZone(this);
            this.cardList.add(c);
        }
        this.onChanged();
        this.game.fireEvent(new GameEventZone(this.zoneType, this.getPlayer(), EventValueChangeType.ComplexUpdate, null));
    }

    public final void removeAllCards(boolean forcedWithoutEvents) {
        if (forcedWithoutEvents) {
            this.cardList.clear();
        } else {
            for (Card c : this.cardList) {
                this.remove(c);
            }
        }
    }

    public final boolean is(ZoneType zone) {
        return zone == this.zoneType;
    }

    public final boolean is(ZoneType zone, Player player) {
        return this.zoneType == zone && player == this.getPlayer();
    }

    public final ZoneType getZoneType() {
        return this.zoneType;
    }

    public final int size() {
        return this.cardList.size();
    }

    public final Card get(int index) {
        return (Card)this.cardList.get(index);
    }

    public final CardCollectionView getCards() {
        return this.getCards(true);
    }

    public CardCollectionView getCards(boolean filter) {
        return this.cardList;
    }

    public final boolean isEmpty() {
        return this.cardList.isEmpty();
    }

    public final List<Card> getCardsAddedThisTurn(ZoneType origin) {
        return Zone.getCardsAdded(this.cardsAddedThisTurn, origin);
    }

    public final List<Card> getCardsAddedLastTurn(ZoneType origin) {
        return Zone.getCardsAdded(this.cardsAddedLastTurn, origin);
    }

    public final boolean isCardAddedThisTurn(Card card, ZoneType origin) {
        if (!this.cardsAddedThisTurn.containsKey((Object)origin)) {
            return false;
        }
        if (((Collection)this.cardsAddedThisTurn.get((Object)origin)).contains(card)) {
            List<Card> cardsAddedThisTurnOrigin = this.getCardsAddedThisTurn(origin);
            int cardIndexOrigin = cardsAddedThisTurnOrigin.lastIndexOf(card);
            long cardTimestampOrigin = cardsAddedThisTurnOrigin.get(cardIndexOrigin).getGameTimestamp();
            for (ZoneType z : this.cardsAddedThisTurn.keySet()) {
                int cardIndex;
                List<Card> cardsAddedThisTurnNonOrigin;
                long cardTimestamp;
                if (z == origin || !((Collection)this.cardsAddedThisTurn.get((Object)z)).contains(card) || (cardTimestamp = (cardsAddedThisTurnNonOrigin = this.getCardsAddedThisTurn(z)).get(cardIndex = cardsAddedThisTurnNonOrigin.lastIndexOf(card)).getGameTimestamp()) <= cardTimestampOrigin) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<Card> getCardsAdded(MapOfLists<ZoneType, Card> cardsAdded, ZoneType origin) {
        if (origin != null) {
            Collection cards = (Collection)cardsAdded.get((Object)origin);
            return cards == null ? ImmutableList.of() : Lists.newArrayList(cards);
        }
        if (cardsAdded.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Card> ret = Lists.newArrayList();
        for (Collection kv : cardsAdded.values()) {
            ret.addAll(kv);
        }
        return ret;
    }

    public final void resetCardsAddedThisTurn() {
        this.cardsAddedLastTurn.clear();
        for (Map.Entry entry : this.cardsAddedThisTurn.entrySet()) {
            this.cardsAddedLastTurn.addAll((ZoneType)((Object)entry.getKey()), (Collection)entry.getValue());
        }
        this.cardsAddedThisTurn.clear();
    }

    @Override
    public Iterator<Card> iterator() {
        return this.cardList.iterator();
    }

    public void shuffle() {
        Collections.shuffle(this.cardList, MyRandom.getRandom());
        this.onChanged();
    }

    public String toString() {
        return this.zoneType.toString();
    }

    public Zone getLKICopy(Map<Integer, Card> cachedMap) {
        Zone result = new Zone(this.zoneType, this.game);
        result.setCards(CardCopyService.getLKICopyList(this.getCards(), cachedMap));
        return result;
    }

    public void saveLKI(Card c, Card old) {
        ZoneType zt;
        Zone oldZone = this.game.getZoneOf(old);
        ZoneType zoneType = zt = oldZone == null ? ZoneType.Stack : oldZone.getZoneType();
        if (zt == this.zoneType) {
            return;
        }
        this.cardsAddedThisTurn.add(zt, CardCopyService.getLKICopy(c));
    }
}

