/*
 * Decompiled with CFR 0.152.
 */
package forge.game.zone;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.card.CardStateName;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Lang;

public class PlayerZone
extends Zone {
    private static final long serialVersionUID = -5687652485777639176L;
    private final Player player;

    private static Predicate<Card> alienCardsActivationFilter(Player who) {
        return c -> !c.mayPlay(who).isEmpty() || c.mayPlayerLook(who);
    }

    private boolean isOnAdventure(Card c) {
        if (!c.isAdventureCard()) {
            return false;
        }
        if (c.getExiledWith() == null) {
            return false;
        }
        return CardStateName.Adventure.equals((Object)c.getExiledWith().getCurrentStateName());
    }

    public PlayerZone(ZoneType zone, Player inPlayer) {
        super(zone, inPlayer.getGame());
        this.player = inPlayer;
    }

    @Override
    protected void onChanged() {
        this.player.updateZoneForView(this);
    }

    @Override
    public final Player getPlayer() {
        return this.player;
    }

    @Override
    public final String toString() {
        return Lang.getInstance().getPossessedObject(this.player.toString(), this.zoneType.toString());
    }

    public Iterable<Card> getCardsPlayerCanActivate(Player who) {
        boolean checkingForOwner;
        Iterable<Card> cl = this.getCards(false);
        boolean bl = checkingForOwner = who == this.player;
        if (checkingForOwner && (this.is(ZoneType.Battlefield) || this.is(ZoneType.Hand))) {
            return cl;
        }
        if (this.is(ZoneType.Library)) {
            cl = Iterables.limit(cl, 1);
        }
        Predicate<Card> filterPredicate = checkingForOwner ? new OwnCardsActivationFilter() : PlayerZone.alienCardsActivationFilter(who);
        return CardLists.filter(cl, filterPredicate);
    }

    private final class OwnCardsActivationFilter
    implements Predicate<Card> {
        private OwnCardsActivationFilter() {
        }

        @Override
        public boolean apply(Card c) {
            if (c.mayPlayerLook(c.getController())) {
                return true;
            }
            if (c.isLand() && !c.mayPlay(c.getController()).isEmpty()) {
                return true;
            }
            boolean graveyardCastable = c.hasKeyword(Keyword.FLASHBACK) || c.hasKeyword(Keyword.RETRACE) || c.hasKeyword(Keyword.JUMP_START) || c.hasKeyword(Keyword.ESCAPE) || c.hasKeyword(Keyword.DISTURB);
            boolean exileCastable = c.isForetold() || PlayerZone.this.isOnAdventure(c);
            for (SpellAbility sa : c.getSpellAbilities()) {
                ZoneType restrictZone = sa.getRestrictions().getZone();
                if (sa.isSpell() && c.mayPlay(sa.getMayPlay()) != null) {
                    return true;
                }
                if (PlayerZone.this.is(restrictZone)) {
                    return true;
                }
                if (sa.isSpell() && graveyardCastable && PlayerZone.this.is(ZoneType.Graveyard) && restrictZone.equals((Object)ZoneType.Hand)) {
                    return true;
                }
                if (!sa.isSpell() || !exileCastable || !PlayerZone.this.is(ZoneType.Exile) || !restrictZone.equals((Object)ZoneType.Hand)) continue;
                return true;
            }
            return false;
        }
    }
}

