/*
 * Decompiled with CFR 0.152.
 */
package forge.game.zone;

import com.esotericsoftware.minlog.Log;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.GameCommand;
import forge.game.CardTraitPredicates;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameLogEntryType;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.effects.PlayEffect;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.event.EventValueChangeType;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.event.GameEventSpellAbilityCast;
import forge.game.event.GameEventSpellRemovedFromStack;
import forge.game.event.GameEventSpellResolved;
import forge.game.event.GameEventZone;
import forge.game.keyword.Keyword;
import forge.game.mana.Mana;
import forge.game.mana.ManaRefundService;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.AbilityStatic;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.TargetChoices;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingDeque;

public class MagicStack
implements Iterable<SpellAbilityStackInstance> {
    private final List<SpellAbility> simultaneousStackEntryList = Lists.newArrayList();
    private final List<SpellAbility> activePlayerSAs = Lists.newArrayList();
    private final Deque<SpellAbilityStackInstance> stack = new LinkedBlockingDeque<SpellAbilityStackInstance>();
    private final Stack<SpellAbilityStackInstance> frozenStack = new Stack();
    private final Stack<SpellAbility> undoStack = new Stack();
    private Player undoStackOwner;
    private SpellAbility primaryAbility = null;
    private boolean frozen = false;
    private boolean bResolving = false;
    private final List<Card> thisTurnCast = Lists.newArrayList();
    private List<Card> lastTurnCast = Lists.newArrayList();
    private final List<SpellAbility> thisTurnActivated = Lists.newArrayList();
    private Card curResolvingCard = null;
    private final Map<String, List<GameCommand>> commandList = Maps.newHashMap();
    private final Game game;
    private int maxDistinctSources = 0;

    public MagicStack(Game gameState) {
        this.game = gameState;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final void setFrozen(boolean frozen0) {
        this.frozen = frozen0;
    }

    public int getMaxDistinctSources() {
        return this.maxDistinctSources;
    }

    public void resetMaxDistinctSources() {
        this.maxDistinctSources = 0;
    }

    public final void reset() {
        this.clear();
        this.simultaneousStackEntryList.clear();
        this.frozen = false;
        this.primaryAbility = null;
        this.lastTurnCast.clear();
        this.thisTurnCast.clear();
        this.curResolvingCard = null;
        this.frozenStack.clear();
        this.clearUndoStack();
        this.game.updateStackForView();
    }

    public final boolean isSplitSecondOnStack() {
        for (SpellAbilityStackInstance si : this.stack) {
            if (!si.isSpell() || !si.getSourceCard().hasKeyword(Keyword.SPLIT_SECOND)) continue;
            return true;
        }
        return false;
    }

    public final void freezeStack(SpellAbility ability) {
        if (this.primaryAbility == null) {
            this.primaryAbility = ability;
        }
        this.frozen = true;
    }

    public final void addAndUnfreeze(SpellAbility ability) {
        Card source = ability.getHostCard();
        if (ability.isSpell() && !source.isCopiedSpell()) {
            if (!source.isInZone(ZoneType.Stack)) {
                ability.setHostCard(this.game.getAction().moveToStack(source, ability));
            }
            if (ability.equals(source.getCastSA())) {
                SpellAbility cause = ability.copy(source, true);
                cause.setLastStateBattlefield(this.game.getLastStateBattlefield());
                cause.setLastStateGraveyard(this.game.getLastStateGraveyard());
                source.setCastSA(cause);
            }
            source.cleanupExiledWith();
        }
        this.add(ability);
        if (this.primaryAbility == null || ability.equals(this.primaryAbility)) {
            this.unfreezeStack();
        }
    }

    public final void unfreezeStack() {
        this.frozen = false;
        this.primaryAbility = null;
        while (!this.frozenStack.isEmpty()) {
            SpellAbilityStackInstance si = this.frozenStack.pop();
            this.add(si.getSpellAbility(), si);
        }
        this.game.getTriggerHandler().resetActiveTriggers();
        this.game.getTriggerHandler().runWaitingTriggers();
    }

    public final void clearFrozen() {
        this.frozen = false;
        this.frozenStack.clear();
    }

    public final boolean isResolving() {
        return this.bResolving;
    }

    public final void setResolving(boolean b) {
        this.bResolving = b;
    }

    public final boolean isResolving(Card c) {
        if (!this.isResolving() || this.curResolvingCard == null) {
            return false;
        }
        return c.equals(this.curResolvingCard);
    }

    public final boolean canUndo(Player player) {
        return this.undoStackOwner == player;
    }

    public final boolean undo() {
        if (this.undoStack.isEmpty()) {
            return false;
        }
        SpellAbility sa = this.undoStack.peek();
        if (sa.undo()) {
            this.clearUndoStack(sa);
            new ManaRefundService(sa).refundManaPaid();
        } else {
            this.clearUndoStack(sa);
            for (Mana pay : sa.getPayingMana()) {
                this.clearUndoStack(pay.getManaAbility().getSourceSA());
            }
        }
        return true;
    }

    public final void clearUndoStack(SpellAbility sa) {
        if (sa == null) {
            return;
        }
        this.clearUndoStack(Lists.newArrayList(sa));
    }

    private void clearUndoStack(List<SpellAbility> sas) {
        for (SpellAbility sa : sas) {
            sa.setUndoable(true);
            int idx = this.undoStack.lastIndexOf(sa);
            if (idx == -1) continue;
            this.undoStack.remove(idx);
        }
        if (this.undoStack.isEmpty()) {
            this.undoStackOwner = null;
        }
    }

    public final void clearUndoStack() {
        if (this.undoStackOwner == null) {
            return;
        }
        this.clearUndoStack(Lists.newArrayList(this.undoStack));
        this.undoStackOwner = null;
    }

    public Iterable<SpellAbility> filterUndoStackByHost(Card c) {
        return Iterables.filter(this.undoStack, CardTraitPredicates.isHostCard(c));
    }

    public final void add(SpellAbility sp) {
        this.add(sp, null, SpellAbilityStackInstance.nextId());
    }

    public final void add(SpellAbility sp, int id) {
        this.add(sp, null, id);
    }

    public final void add(SpellAbility sp, SpellAbilityStackInstance si) {
        this.add(sp, si, si.getId());
    }

    public final void add(SpellAbility sp, SpellAbilityStackInstance si, int id) {
        List<TargetChoices> chosenTargets;
        Card source = sp.getHostCard();
        Player activator = sp.getActivatingPlayer();
        if (null == activator) {
            sp.setActivatingPlayer(source.getController());
            activator = sp.getActivatingPlayer();
            System.out.println(source.getName() + " - activatingPlayer not set before adding to stack.");
        }
        this.recordUndoableActions(sp, activator);
        if (sp.isManaAbility()) {
            this.game.getAction().checkStaticAbilities();
            if (!sp.isCopied() && !sp.isTrigger()) {
                this.addAbilityActivatedThisTurn(sp, source);
            }
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(source.getController());
            runParams.put(AbilityKey.Cost, sp.getPayCosts());
            runParams.put(AbilityKey.Activator, activator);
            runParams.put(AbilityKey.SpellAbility, sp);
            this.game.getTriggerHandler().runTrigger(TriggerType.SpellAbilityCast, runParams, true);
            if (sp.isActivatedAbility()) {
                this.game.getTriggerHandler().runTrigger(TriggerType.AbilityCast, runParams, true);
            }
            AbilityUtils.resolve(sp);
            Map<AbilityKey, Object> runParams2 = AbilityKey.mapFromCard(source);
            runParams2.put(AbilityKey.SpellAbility, sp);
            this.game.getTriggerHandler().runTrigger(TriggerType.AbilityResolves, runParams2, false);
            this.game.getGameLog().add(GameLogEntryType.MANA, source + " - " + sp.getDescription());
            sp.resetOnceResolved();
            return;
        }
        if (sp.isSpell()) {
            source.setController(activator, 0L);
            if (source.isFaceDown() && !sp.isCastFaceDown()) {
                source.turnFaceUp(null);
            }
            source.setSplitStateToPlayAbility(sp);
            if (source.isCopiedSpell()) {
                this.game.getStackZone().add(source);
            }
        }
        if (!sp.isCopied() && !this.hasLegalTargeting(sp)) {
            String str = source + " - [Couldn't add to stack, failed to target] - " + sp.getDescription();
            System.err.println(str + sp.getAllTargetChoices());
            this.game.getGameLog().add(GameLogEntryType.STACK_ADD, str);
            return;
        }
        if (!sp.isTrigger()) {
            for (Player p : activator.getOpponents()) {
                p.getController().autoPassCancel();
            }
        }
        if (si == null && sp.isActivatedAbility() && !sp.isCopied()) {
            SpellAbility original = sp;
            sp = sp.copy(sp.getHostCard(), activator, false, true);
            sp.setOriginalAbility(original);
            original.clearTargets();
            original.setXManaCostPaid(null);
            if (original.getApi() == ApiType.Charm) {
                original.setSubAbility(null);
            }
        }
        if (this.frozen && !sp.hasParam("IgnoreFreeze") && !sp.isCastFromPlayEffect()) {
            si = new SpellAbilityStackInstance(sp, id);
            this.frozenStack.push(si);
            return;
        }
        if (sp.isAbility() && !sp.isCopied() && !sp.isTrigger()) {
            this.addAbilityActivatedThisTurn(sp, source);
        }
        if (sp instanceof AbilityStatic || sp.isTrigger() && sp.getTrigger().getOverridingAbility() instanceof AbilityStatic) {
            AbilityUtils.resolve(sp);
            return;
        }
        si = this.push(sp, si, id);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(sp.getHostCard().getController());
        if (sp.isSpell() && !sp.isCopied()) {
            Player manaPayer;
            Card lki = CardCopyService.getLKICopy(sp.getHostCard());
            runParams.put(AbilityKey.CardLKI, lki);
            this.thisTurnCast.add(lki);
            sp.getActivatingPlayer().addSpellCastThisTurn();
            HashMap<Player, Integer> expendPlayers = Maps.newHashMap();
            for (Mana mana : sp.getPayingMana()) {
                manaPayer = sp.getActivatingPlayer();
                expendPlayers.put(manaPayer, expendPlayers.getOrDefault(manaPayer, 0) + 1);
            }
            for (Map.Entry entry : expendPlayers.entrySet()) {
                manaPayer = (Player)entry.getKey();
                int startingMana = manaPayer.getExpentThisTurn();
                int totalMana = startingMana + (Integer)entry.getValue();
                if (totalMana == 0) continue;
                manaPayer.setExpentThisTurn(totalMana);
                for (int i = startingMana + 1; i <= totalMana; ++i) {
                    Map<AbilityKey, Object> expendParams = AbilityKey.mapFromPlayer(manaPayer);
                    expendParams.put(AbilityKey.SpellAbility, sp);
                    expendParams.put(AbilityKey.Amount, i);
                    this.game.getTriggerHandler().runTrigger(TriggerType.ManaExpend, expendParams, true);
                }
            }
        }
        runParams.put(AbilityKey.Cost, sp.getPayCosts());
        runParams.put(AbilityKey.Activator, sp.getActivatingPlayer());
        runParams.put(AbilityKey.SpellAbility, si.getSpellAbility());
        runParams.put(AbilityKey.CurrentStormCount, this.thisTurnCast.size());
        runParams.put(AbilityKey.CurrentCastSpells, Lists.newArrayList(this.thisTurnCast));
        if (!sp.isCopied()) {
            this.game.getTriggerHandler().runTrigger(TriggerType.SpellAbilityCast, runParams, true);
            sp.applyPayingManaEffects();
            if (sp.isSpell()) {
                if (source.isCommander() && source.getCastFrom() != null && ZoneType.Command == source.getCastFrom().getZoneType() && source.getOwner().equals(activator)) {
                    activator.incCommanderCast(source);
                }
                this.game.getTriggerHandler().runTrigger(TriggerType.SpellCast, runParams, true);
                this.executeCastCommand(si.getSpellAbility().getHostCard());
            }
            if (sp.isActivatedAbility()) {
                this.game.getTriggerHandler().runTrigger(TriggerType.AbilityCast, runParams, true);
            }
            if (sp.isCycling()) {
                activator.addCycled(sp);
            }
            if (sp.isCrew()) {
                runParams.put(AbilityKey.Vehicle, sp.getHostCard());
                runParams.put(AbilityKey.Crew, sp.getPaidList("TappedCards", true));
                this.game.getTriggerHandler().runTrigger(TriggerType.Crewed, runParams, false);
            }
        } else {
            if (sp.isSpell()) {
                this.game.getTriggerHandler().runTrigger(TriggerType.SpellCopy, runParams, false);
            }
            this.game.getTriggerHandler().runTrigger(TriggerType.SpellAbilityCopy, runParams, false);
        }
        if (sp.isSpell()) {
            this.game.getTriggerHandler().runTrigger(TriggerType.SpellCastOrCopy, runParams, false);
        }
        if (!(chosenTargets = sp.getAllTargetChoices()).isEmpty()) {
            SpellAbility s2 = sp;
            if (si != null) {
                s2 = si.getSpellAbility();
                chosenTargets = s2.getAllTargetChoices();
            }
            HashSet<GameObject> distinctObjects = Sets.newHashSet();
            for (TargetChoices tc : chosenTargets) {
                for (GameObject tgt : tc) {
                    if (!distinctObjects.add(tgt)) continue;
                    runParams = AbilityKey.newMap();
                    runParams.put(AbilityKey.SourceSA, s2);
                    if (tgt instanceof Card && !((Card)tgt).hasBecomeTargetThisTurn()) {
                        runParams.put(AbilityKey.FirstTime, null);
                        ((Card)tgt).setBecameTargetThisTurn(true);
                    }
                    if (tgt instanceof Card && !((Card)tgt).isValiant() && activator.equals(((Card)tgt).getController())) {
                        runParams.put(AbilityKey.Valiant, null);
                        ((Card)tgt).setValiant(true);
                    }
                    runParams.put(AbilityKey.Target, tgt);
                    this.game.getTriggerHandler().runTrigger(TriggerType.BecomesTarget, runParams, false);
                }
            }
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.SourceSA, s2);
            runParams.put(AbilityKey.Targets, distinctObjects);
            runParams.put(AbilityKey.Cause, s2.getHostCard());
            this.game.getTriggerHandler().runTrigger(TriggerType.BecomesTargetOnce, runParams, false);
        }
        if (sp.getActivatingPlayer() != null && MagicStack.commitCrimeCheck(sp.getActivatingPlayer(), chosenTargets)) {
            sp.getActivatingPlayer().commitCrime();
        }
        this.game.fireEvent(new GameEventZone(ZoneType.Stack, sp.getActivatingPlayer(), EventValueChangeType.Added, source));
        if (sp.getActivatingPlayer() != null && !this.game.getCardsPlayerCanActivateInStack().isEmpty()) {
            for (Player p : this.game.getPlayers()) {
                p.updateFlashbackForView();
            }
        }
    }

    private void recordUndoableActions(SpellAbility sp, Player activator) {
        if (sp.isUndoable()) {
            if (!this.canUndo(activator)) {
                this.clearUndoStack();
                this.undoStackOwner = activator;
            }
            this.undoStack.push(sp);
        } else {
            this.clearUndoStack();
        }
    }

    public final int size() {
        return this.stack.size();
    }

    public final boolean isEmpty() {
        return this.stack.isEmpty();
    }

    private SpellAbilityStackInstance push(SpellAbility sp, SpellAbilityStackInstance si, int id) {
        if (null == sp.getActivatingPlayer()) {
            sp.setActivatingPlayer(sp.getHostCard().getController());
            System.out.println(sp.getHostCard().getName() + " - activatingPlayer not set before adding to stack.");
        }
        if (sp.isSpell() && sp.getMayPlay() != null) {
            sp.getMayPlay().incMayPlayTurn();
            if (sp.getMayPlay().hasParam("ReplaceGraveyard")) {
                PlayEffect.addReplaceGraveyardEffect(sp.getHostCard(), sp.getMayPlay().getHostCard(), sp, sp, sp.getMayPlay().getParam("ReplaceGraveyard"));
            }
        }
        si = si == null ? new SpellAbilityStackInstance(sp, id) : si;
        this.stack.addFirst(si);
        int stackIndex = this.stack.size() - 1;
        int distinctSources = 0;
        TreeSet<Integer> sources = new TreeSet<Integer>();
        for (SpellAbilityStackInstance s2 : this.stack) {
            if (s2.isSpell()) {
                ++distinctSources;
                continue;
            }
            sources.add(s2.getSourceCard().getId());
        }
        if ((distinctSources += sources.size()) > this.maxDistinctSources) {
            this.maxDistinctSources = distinctSources;
        }
        if (!sp.isTrigger() && !(sp instanceof AbilityStatic)) {
            this.game.getPhaseHandler().setPriority(sp.getActivatingPlayer());
        }
        GameActionUtil.checkStaticAfterPaying(sp.getHostCard());
        if (sp.isActivatedAbility() && sp.isPwAbility()) {
            sp.getActivatingPlayer().setActivateLoyaltyAbilityThisTurn(true);
        }
        this.game.updateStackForView();
        this.game.fireEvent(new GameEventSpellAbilityCast(sp, si, stackIndex));
        return si;
    }

    public final void resolveStack() {
        Card source;
        this.freezeStack(null);
        this.setResolving(true);
        SpellAbility sa = this.peekAbility();
        if (sa.isSpell()) {
            sa.changeText();
        }
        this.game.getPhaseHandler().resetPriority();
        this.curResolvingCard = source = sa.getHostCard();
        boolean thisHasFizzled = this.hasFizzled(sa, source, null);
        if (!thisHasFizzled) {
            this.game.copyLastState();
        }
        if (sa.getControlledByPlayer() != null) {
            sa.getActivatingPlayer().addController(sa.getControlledByPlayer().getLeft(), sa.getControlledByPlayer().getRight());
        }
        if (thisHasFizzled) {
            if (sa.isBestow()) {
                source.unanimateBestow();
                SpellAbility first = source.getFirstSpellAbility();
                first.setActivatingPlayer(sa.getActivatingPlayer());
                this.game.fireEvent(new GameEventCardStatsChanged(source));
                AbilityUtils.resolve(first);
            } else if (sa.isMutate()) {
                SpellAbility first = source.getFirstSpellAbility();
                first.setActivatingPlayer(sa.getActivatingPlayer());
                this.game.fireEvent(new GameEventCardStatsChanged(source));
                AbilityUtils.resolve(first);
            } else {
                Log.debug(source.getName() + " ability fizzles.");
            }
        } else if (sa.getApi() != null) {
            AbilityUtils.handleRemembering(sa);
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(source);
            runParams.put(AbilityKey.SpellAbility, sa);
            this.game.getTriggerHandler().runTrigger(TriggerType.AbilityResolves, runParams, false);
            AbilityUtils.resolve(sa);
        } else {
            sa.resolve();
        }
        if (sa.getControlledByPlayer() != null) {
            sa.getActivatingPlayer().removeController(sa.getControlledByPlayer().getLeft());
            sa.setControlledByPlayer(-1L, null);
            sa.setManaCostBeingPaid(null);
        }
        this.game.fireEvent(new GameEventSpellResolved(sa, thisHasFizzled));
        this.finishResolving(sa, thisHasFizzled);
        this.game.getAction().checkStaticAbilities();
        this.game.copyLastState();
        if (this.isEmpty() && !this.hasSimultaneousStackEntries()) {
            this.game.clearChangeZoneLKIInfo();
        }
    }

    private void finishResolving(SpellAbility sa, boolean fizzle) {
        SpellAbilityStackInstance si = this.getInstanceMatchingSpellAbilityID(sa);
        this.removeCardFromStack(sa, si, fizzle);
        if (si != null) {
            this.remove(si);
        }
        this.setResolving(false);
        this.unfreezeStack();
        sa.resetOnceResolved();
        this.game.getPhaseHandler().onStackResolved();
        this.curResolvingCard = null;
    }

    private void removeCardFromStack(SpellAbility sa, SpellAbilityStackInstance si, boolean fizzle) {
        Card source = sa.getHostCard();
        this.game.getTriggerHandler().resetActiveTriggers();
        if (sa.isAbility()) {
            return;
        }
        if (source.isCopiedSpell() && source.isInZone(ZoneType.Stack)) {
            this.game.getAction().ceaseToExist(source, true);
            return;
        }
        if ((source.isInstant() || source.isSorcery() || fizzle) && source.isInZone(ZoneType.Stack)) {
            EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
            params.put(AbilityKey.StackSa, sa);
            params.put(AbilityKey.Fizzle, Boolean.valueOf(fizzle));
            this.game.getAction().moveToGraveyard(source, null, params);
        }
    }

    public final boolean hasLegalTargeting(SpellAbility sa) {
        if (sa == null) {
            return true;
        }
        if (!sa.isTargetNumberValid()) {
            return false;
        }
        return this.hasLegalTargeting(sa.getSubAbility());
    }

    private boolean hasFizzled(SpellAbility sa, Card source, Boolean fizzle) {
        ArrayList<GameObject> toRemove = Lists.newArrayList();
        if (sa.usesTargeting() && !sa.isZeroTargets()) {
            if (fizzle == null) {
                fizzle = true;
            }
            for (GameObject o : sa.getTargets()) {
                boolean invalidTarget = false;
                if (o instanceof Card) {
                    Card card = (Card)o;
                    Card current = this.game.getCardState(card);
                    if (current != null) {
                        invalidTarget = !current.equalsWithGameTimestamp(card);
                    }
                    invalidTarget = invalidTarget || !sa.canTarget(card, true);
                } else if (o instanceof SpellAbility) {
                    SpellAbilityStackInstance si = this.getInstanceMatchingSpellAbilityID((SpellAbility)o);
                    invalidTarget = si == null ? true : !sa.canTarget(si.getSpellAbility(), true);
                } else {
                    boolean bl = invalidTarget = !sa.canTarget(o, true);
                }
                if (invalidTarget) {
                    toRemove.add(o);
                } else {
                    fizzle = false;
                }
                if (!sa.hasParam("CantFizzle")) continue;
                fizzle = false;
            }
        }
        if (sa.getSubAbility() != null) {
            fizzle = this.hasFizzled(sa.getSubAbility(), source, fizzle);
        }
        if (sa.usesTargeting() && !sa.isZeroTargets()) {
            sa.getTargets().removeAll(toRemove);
        }
        return fizzle != null && fizzle != false;
    }

    public final SpellAbilityStackInstance peek() {
        return this.stack.peekFirst();
    }

    public final SpellAbility peekAbility() {
        return this.stack.peekFirst().getSpellAbility();
    }

    public final void remove(SpellAbilityStackInstance si) {
        this.stack.remove(si);
        this.frozenStack.remove(si);
        this.game.updateStackForView();
        SpellAbility sa = si.getSpellAbility();
        this.game.fireEvent(new GameEventSpellRemovedFromStack(sa));
    }

    public final void remove(Card c) {
        for (SpellAbilityStackInstance si : this.stack) {
            if (!c.equals(si.getSourceCard()) || !si.isSpell()) continue;
            this.remove(si);
        }
    }

    public final void removeInstancesControlledBy(Player p) {
        for (SpellAbilityStackInstance si : this.stack) {
            if (!si.getActivatingPlayer().equals(p)) continue;
            this.remove(si);
        }
        for (SpellAbility sa : Lists.newArrayList(this.simultaneousStackEntryList)) {
            Player activator = sa.getActivatingPlayer();
            if (activator == null) {
                if (!sa.getHostCard().getController().equals(p)) continue;
                this.simultaneousStackEntryList.remove(sa);
                continue;
            }
            if (!activator.equals(p)) continue;
            this.simultaneousStackEntryList.remove(sa);
        }
    }

    public final SpellAbilityStackInstance getInstanceMatchingSpellAbilityID(SpellAbility sa) {
        for (SpellAbilityStackInstance si : this.stack) {
            if (sa.getId() != si.getSpellAbility().getId()) continue;
            return si;
        }
        return null;
    }

    public final SpellAbility getSpellMatchingHost(Card host) {
        for (SpellAbilityStackInstance si : this.stack) {
            if (!si.isSpell() || !host.equals(si.getSpellAbility().getHostCard())) continue;
            return si.getSpellAbility();
        }
        return null;
    }

    public final boolean hasSimultaneousStackEntries() {
        return !this.simultaneousStackEntryList.isEmpty();
    }

    public final void clearSimultaneousStack() {
        this.simultaneousStackEntryList.clear();
    }

    public final void addSimultaneousStackEntry(SpellAbility sa) {
        this.simultaneousStackEntryList.add(sa);
    }

    public boolean addAllTriggeredAbilitiesToStack() {
        boolean result = false;
        Player playerTurn = this.game.getPhaseHandler().getPlayerTurn();
        if (playerTurn == null) {
            return false;
        }
        if (playerTurn.hasLost()) {
            playerTurn = this.game.getNextPlayerAfter(playerTurn);
        }
        PlayerCollection players = this.game.getPlayersInTurnOrder(playerTurn);
        for (Player p : players) {
            if (p.hasLost()) continue;
            result |= this.chooseOrderOfSimultaneousStackEntry(p, false);
        }
        for (Player p : players) {
            if (p.hasLost()) continue;
            result |= this.chooseOrderOfSimultaneousStackEntry(p, true);
        }
        return result;
    }

    private boolean chooseOrderOfSimultaneousStackEntry(Player activePlayer, boolean isAbilityTriggered) {
        if (this.simultaneousStackEntryList.isEmpty()) {
            return false;
        }
        this.activePlayerSAs.clear();
        for (SpellAbility sa : this.simultaneousStackEntryList) {
            if (isAbilityTriggered != (sa.isTrigger() && sa.getTrigger().getMode() == TriggerType.AbilityTriggered)) continue;
            Player activator = sa.getActivatingPlayer();
            if (activator == null) {
                activator = sa.getHostCard().getController();
            }
            if (!activator.equals(activePlayer)) continue;
            this.adjustAuraHost(sa);
            this.activePlayerSAs.add(sa);
        }
        this.simultaneousStackEntryList.removeAll(this.activePlayerSAs);
        if (this.activePlayerSAs.isEmpty()) {
            return false;
        }
        activePlayer.getController().orderAndPlaySimultaneousSa(this.activePlayerSAs);
        this.activePlayerSAs.clear();
        return true;
    }

    public void adjustAuraHost(SpellAbility sa) {
        Card host = sa.getHostCard();
        Trigger trig = sa.getTrigger();
        Card newHost = this.game.getCardState(host);
        if (host.isAura() && newHost.isInZone(ZoneType.Graveyard) && trig.getMode() == TriggerType.ChangesZone && "Battlefield".equals(trig.getParam("Origin")) && "Card.EnchantedBy".equals(trig.getParam("ValidCard"))) {
            sa.setHostCard(newHost);
        }
    }

    public final boolean hasStateTrigger(int triggerID) {
        for (SpellAbilityStackInstance sasi : this.stack) {
            if (!sasi.isStateTrigger(triggerID)) continue;
            return true;
        }
        for (SpellAbilityStackInstance sasi : this.frozenStack) {
            if (!sasi.isStateTrigger(triggerID)) continue;
            return true;
        }
        for (SpellAbility sa : this.simultaneousStackEntryList) {
            if (sa.getSourceTrigger() != triggerID) continue;
            return true;
        }
        for (SpellAbility sa : this.activePlayerSAs) {
            if (sa.getSourceTrigger() != triggerID) continue;
            return true;
        }
        return false;
    }

    public final List<Card> getSpellsCastThisTurn() {
        return this.thisTurnCast;
    }

    public final List<Card> getSpellsCastLastTurn() {
        return this.lastTurnCast;
    }

    public final void onNextTurn() {
        Player active = this.game.getPhaseHandler().getPlayerTurn();
        this.game.getStackZone().resetCardsAddedThisTurn();
        this.thisTurnActivated.clear();
        if (this.thisTurnCast.isEmpty()) {
            this.lastTurnCast = Lists.newArrayList();
            active.resetSpellCastSinceBegOfYourLastTurn();
            return;
        }
        for (Player nonActive : this.game.getNonactivePlayers()) {
            nonActive.addSpellCastSinceBegOfYourLastTurn(this.thisTurnCast);
        }
        this.lastTurnCast = Lists.newArrayList(this.thisTurnCast);
        active.setSpellCastSinceBegOfYourLastTurn(this.thisTurnCast);
        this.thisTurnCast.clear();
        this.game.updateStackForView();
    }

    public void addAbilityActivatedThisTurn(SpellAbility sa, Card source) {
        source.addAbilityActivated(sa);
        this.thisTurnActivated.add(sa.copy(CardCopyService.getLKICopy(source), true));
    }

    public List<SpellAbility> getAbilityActivatedThisTurn() {
        return this.thisTurnActivated;
    }

    public final void addCastCommand(String valid, GameCommand c) {
        if (this.commandList.containsKey(valid)) {
            this.commandList.get(valid).add(0, c);
        } else {
            this.commandList.put(valid, Lists.newArrayList(c));
        }
    }

    private void executeCastCommand(Card cast) {
        for (Map.Entry<String, List<GameCommand>> ev : this.commandList.entrySet()) {
            if (!cast.getType().hasStringType(ev.getKey())) continue;
            MagicStack.execute(ev.getValue());
        }
    }

    private static void execute(List<GameCommand> c) {
        int length = c.size();
        for (int i = 0; i < length; ++i) {
            c.remove(0).run();
        }
    }

    public final boolean hasSourceOnStack(Card source, Predicate<SpellAbility> pred) {
        if (source == null) {
            return false;
        }
        for (SpellAbilityStackInstance si : this.stack) {
            if (!si.isTrigger() || !si.getSourceCard().equals(source) || pred != null && !pred.apply(si.getSpellAbility())) continue;
            return true;
        }
        for (SpellAbility sa : this.simultaneousStackEntryList) {
            if (!sa.isTrigger() || !sa.getHostCard().equals(source) || pred != null && !pred.apply(sa)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<SpellAbilityStackInstance> iterator() {
        return this.stack.iterator();
    }

    public Iterator<SpellAbilityStackInstance> reverseIterator() {
        return this.stack.descendingIterator();
    }

    public void clear() {
        if (this.stack.isEmpty()) {
            return;
        }
        this.stack.clear();
        this.game.updateStackForView();
        this.game.fireEvent(new GameEventSpellRemovedFromStack(null));
    }

    public String toString() {
        return TextUtil.concatNoSpace(this.simultaneousStackEntryList.toString(), "==", this.frozenStack.toString(), "==", this.stack.toString());
    }

    protected static boolean commitCrimeCheck(Player p, Iterable<TargetChoices> chosenTargets) {
        ImmutableList<ZoneType> zoneList = ImmutableList.of(ZoneType.Battlefield, ZoneType.Graveyard, ZoneType.Stack);
        for (TargetChoices tc : chosenTargets) {
            if (Iterables.any(tc.getTargetPlayers(), PlayerPredicates.isOpponentOf(p))) {
                return true;
            }
            for (SpellAbility sp : tc.getTargetSpells()) {
                if (!sp.getActivatingPlayer().isOpponentOf(p)) continue;
                return true;
            }
            for (Card c : tc.getTargetCards()) {
                if (!c.isInZones(zoneList) || !c.getController().isOpponentOf(p)) continue;
                return true;
            }
        }
        return false;
    }
}

