/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.player.Player;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.util.TextUtil;
import java.util.List;
import java.util.Map;

public class TriggerWaiting {
    private TriggerType mode;
    private Map<AbilityKey, Object> params;
    private Map<Trigger, Player> triggers;

    public TriggerWaiting(TriggerType m4, Map<AbilityKey, Object> p) {
        this.mode = m4;
        this.params = p;
    }

    public TriggerType getMode() {
        return this.mode;
    }

    public Map<AbilityKey, Object> getParams() {
        return this.params;
    }

    public Iterable<Trigger> getTriggers() {
        if (this.triggers == null) {
            return null;
        }
        return this.triggers.keySet();
    }

    public void setTriggers(List<Trigger> trigs) {
        this.triggers = Maps.newHashMap();
        for (Trigger t2 : trigs) {
            this.triggers.put(t2, t2.getHostCard().getController());
        }
    }

    public Player getController(Trigger t2) {
        if (this.triggers == null) {
            return null;
        }
        return this.triggers.get(t2);
    }

    public String toString() {
        return TextUtil.concatWithSpace("Waiting trigger:", this.mode.toString(), "with", this.params.toString());
    }
}

