/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.HashMap;
import java.util.Map;

public class TriggerUntapAll
extends Trigger {
    public TriggerUntapAll(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        Map<Player, CardCollection> testMap = this.filteredMap((Map)runParams.get((Object)AbilityKey.Map));
        return !testMap.isEmpty();
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        Map<Player, CardCollection> map = this.filteredMap((Map)runParams.get((Object)AbilityKey.Map));
        sa.setTriggeringObject(AbilityKey.Map, map);
        sa.setTriggeringObject(AbilityKey.Player, map.keySet());
        CardCollection untapped = new CardCollection();
        for (Map.Entry<Player, CardCollection> e : map.entrySet()) {
            untapped.addAll(e.getValue());
        }
        sa.setTriggeringObject(AbilityKey.Cards, untapped);
        sa.setTriggeringObject(AbilityKey.Amount, untapped.size());
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ");
        sb.append(sa.getTriggeringObject(AbilityKey.Amount));
        return sb.toString();
    }

    private Map<Player, CardCollection> filteredMap(Map<Player, CardCollection> map) {
        HashMap<Player, CardCollection> passMap = Maps.newHashMap();
        for (Map.Entry<Player, CardCollection> e : map.entrySet()) {
            if (!this.matchesValidParam("ValidPlayer", e.getKey())) continue;
            CardCollection passCards = new CardCollection();
            if (this.hasParam("ValidCards")) {
                for (Card c : e.getValue()) {
                    if (!this.matchesValidParam("ValidCards", c)) continue;
                    passCards.add(c);
                }
            }
            if (passCards.isEmpty()) continue;
            passMap.put(e.getKey(), passCards);
        }
        return passMap;
    }
}

